/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.util;

import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class FilterToBeanProxy
implements Filter {
    private Filter delegate;
    private FilterConfig filterConfig;
    private boolean initialized = false;
    private boolean servletContainerManaged = false;

    public void destroy() {
        if (this.delegate != null && this.servletContainerManaged) {
            this.delegate.destroy();
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.initialized) {
            this.doInit();
        }
        this.delegate.doFilter(request, response, chain);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        String strategy = filterConfig.getInitParameter("init");
        if (strategy != null && strategy.toLowerCase().equals("lazy")) {
            return;
        }
        this.doInit();
    }

    protected ApplicationContext getContext(FilterConfig filterConfig) {
        return WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)filterConfig.getServletContext());
    }

    private void doInit() throws ServletException {
        String lifecycle;
        this.initialized = true;
        String targetBean = this.filterConfig.getInitParameter("targetBean");
        if ("".equals(targetBean)) {
            targetBean = null;
        }
        if ("servlet-container-managed".equals(lifecycle = this.filterConfig.getInitParameter("lifecycle"))) {
            this.servletContainerManaged = true;
        }
        ApplicationContext ctx = this.getContext(this.filterConfig);
        String beanName = null;
        if (targetBean != null && ctx.containsBean(targetBean)) {
            beanName = targetBean;
        } else {
            Class<?> targetClass;
            if (targetBean != null) {
                throw new ServletException("targetBean '" + targetBean + "' not found in context");
            }
            String targetClassString = this.filterConfig.getInitParameter("targetClass");
            if (targetClassString == null || "".equals(targetClassString)) {
                throw new ServletException("targetClass or targetBean must be specified");
            }
            try {
                targetClass = Thread.currentThread().getContextClassLoader().loadClass(targetClassString);
            }
            catch (ClassNotFoundException ex) {
                throw new ServletException("Class of type " + targetClassString + " not found in classloader");
            }
            Map beans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)ctx, targetClass, (boolean)true, (boolean)true);
            if (beans.size() == 0) {
                throw new ServletException("Bean context must contain at least one bean of type " + targetClassString);
            }
            beanName = (String)beans.keySet().iterator().next();
        }
        Object object = ctx.getBean(beanName);
        if (!(object instanceof Filter)) {
            throw new ServletException("Bean '" + beanName + "' does not implement javax.servlet.Filter");
        }
        this.delegate = (Filter)object;
        if (this.servletContainerManaged) {
            this.delegate.init(this.filterConfig);
        }
    }
}

