/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.xpath;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.xml.xpath.SecuritySupport;
import javax.xml.xpath.XPathFactory;

class XPathFactoryFinder {
    private static SecuritySupport ss = new SecuritySupport();
    private static boolean debug = false;
    private static Properties cacheProps;
    private static boolean firstTime;
    private final ClassLoader classLoader;
    private static final Class SERVICE_CLASS;
    private static final String SERVICE_ID;
    static /* synthetic */ Class class$javax$xml$xpath$XPathFactoryFinder;
    static /* synthetic */ Class class$javax$xml$xpath$XPathFactory;

    private static void debugPrintln(String msg) {
        if (debug) {
            System.err.println("JAXP: " + msg);
        }
    }

    public XPathFactoryFinder(ClassLoader loader) {
        this.classLoader = loader;
        if (debug) {
            this.debugDisplayClassLoader();
        }
    }

    private void debugDisplayClassLoader() {
        try {
            if (this.classLoader == ss.getContextClassLoader()) {
                XPathFactoryFinder.debugPrintln("using thread context class loader (" + this.classLoader + ") for search");
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.classLoader == ClassLoader.getSystemClassLoader()) {
            XPathFactoryFinder.debugPrintln("using system class loader (" + this.classLoader + ") for search");
            return;
        }
        XPathFactoryFinder.debugPrintln("using class loader (" + this.classLoader + ") for search");
    }

    public XPathFactory newFactory(String uri) {
        if (uri == null) {
            throw new NullPointerException();
        }
        XPathFactory f = this._newFactory(uri);
        if (f != null) {
            XPathFactoryFinder.debugPrintln("factory '" + f.getClass().getName() + "' was found for " + uri);
        } else {
            XPathFactoryFinder.debugPrintln("unable to find a factory for " + uri);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XPathFactory _newFactory(String uri) {
        XPathFactory sf;
        block19: {
            String propertyName;
            block18: {
                propertyName = SERVICE_CLASS.getName() + ":" + uri;
                try {
                    XPathFactoryFinder.debugPrintln("Looking up system property '" + propertyName + "'");
                    String r = ss.getSystemProperty(propertyName);
                    if (r != null) {
                        XPathFactoryFinder.debugPrintln("The value is '" + r + "'");
                        sf = this.createInstance(r);
                        if (sf != null) {
                            return sf;
                        }
                    } else {
                        XPathFactoryFinder.debugPrintln("The property is undefined.");
                    }
                }
                catch (Throwable t) {
                    if (!debug) break block18;
                    XPathFactoryFinder.debugPrintln("failed to look up system property '" + propertyName + "'");
                    t.printStackTrace();
                }
            }
            String javah = ss.getSystemProperty("java.home");
            String configFile = javah + File.separator + "lib" + File.separator + "jaxp.properties";
            String factoryClassName = null;
            try {
                if (firstTime) {
                    Properties properties = cacheProps;
                    synchronized (properties) {
                        if (firstTime) {
                            File f = new File(configFile);
                            firstTime = false;
                            if (ss.doesFileExist(f)) {
                                XPathFactoryFinder.debugPrintln("Read properties file " + f);
                                cacheProps.load(ss.getFileInputStream(f));
                            }
                        }
                    }
                }
                factoryClassName = cacheProps.getProperty(propertyName);
                XPathFactoryFinder.debugPrintln("found " + factoryClassName + " in $java.home/jaxp.properties");
                if (factoryClassName != null && (sf = this.createInstance(factoryClassName)) != null) {
                    return sf;
                }
            }
            catch (Exception ex) {
                if (!debug) break block19;
                ex.printStackTrace();
            }
        }
        Iterator sitr = this.createServiceFileIterator();
        while (sitr.hasNext()) {
            URL resource = (URL)sitr.next();
            XPathFactoryFinder.debugPrintln("looking into " + resource);
            try {
                sf = this.loadFromProperty(uri, resource.toExternalForm(), ss.getURLInputStream(resource));
                if (sf == null) continue;
                return sf;
            }
            catch (IOException e) {
                if (!debug) continue;
                XPathFactoryFinder.debugPrintln("failed to read " + resource);
                e.printStackTrace();
            }
        }
        if (uri.equals("http://java.sun.com/jaxp/xpath/dom")) {
            XPathFactoryFinder.debugPrintln("attempting to use the platform default W3C DOM XPath lib");
            return this.createInstance("com.sun.org.apache.xpath.internal.jaxp.XPathFactoryImpl");
        }
        XPathFactoryFinder.debugPrintln("all things were tried, but none was found. bailing out.");
        return null;
    }

    private XPathFactory createInstance(String className) {
        block4: {
            try {
                Object o;
                XPathFactoryFinder.debugPrintln("instanciating " + className);
                Class<?> clazz = this.classLoader != null ? this.classLoader.loadClass(className) : Class.forName(className);
                if (debug) {
                    XPathFactoryFinder.debugPrintln("loaded it from " + XPathFactoryFinder.which(clazz));
                }
                if ((o = clazz.newInstance()) instanceof XPathFactory) {
                    return (XPathFactory)o;
                }
                XPathFactoryFinder.debugPrintln(className + " is not assignable to " + SERVICE_CLASS.getName());
            }
            catch (Throwable t) {
                XPathFactoryFinder.debugPrintln("failed to instanciate " + className);
                if (!debug) break block4;
                t.printStackTrace();
            }
        }
        return null;
    }

    private XPathFactory loadFromProperty(String keyName, String resourceName, InputStream in) throws IOException {
        XPathFactoryFinder.debugPrintln("Reading " + resourceName);
        Properties props = new Properties();
        props.load(in);
        in.close();
        String factoryClassName = props.getProperty(keyName);
        if (factoryClassName != null) {
            XPathFactoryFinder.debugPrintln("found " + keyName + " = " + factoryClassName);
            return this.createInstance(factoryClassName);
        }
        XPathFactoryFinder.debugPrintln(keyName + " is not in the property file");
        return null;
    }

    private Iterator createServiceFileIterator() {
        if (this.classLoader == null) {
            return new SingleIterator(){

                protected Object value() {
                    ClassLoader classLoader = (class$javax$xml$xpath$XPathFactoryFinder == null ? (class$javax$xml$xpath$XPathFactoryFinder = XPathFactoryFinder.class$("javax.xml.xpath.XPathFactoryFinder")) : class$javax$xml$xpath$XPathFactoryFinder).getClassLoader();
                    return ss.getResourceAsURL(classLoader, SERVICE_ID);
                }
            };
        }
        try {
            final Enumeration e = ss.getResources(this.classLoader, SERVICE_ID);
            if (!e.hasMoreElements()) {
                XPathFactoryFinder.debugPrintln("no " + SERVICE_ID + " file was found");
            }
            return new Iterator(){

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public boolean hasNext() {
                    return e.hasMoreElements();
                }

                public Object next() {
                    return e.nextElement();
                }
            };
        }
        catch (IOException e) {
            XPathFactoryFinder.debugPrintln("failed to enumerate resources " + SERVICE_ID);
            if (debug) {
                e.printStackTrace();
            }
            return new ArrayList().iterator();
        }
    }

    private static String which(Class clazz) {
        return XPathFactoryFinder.which(clazz.getName(), clazz.getClassLoader());
    }

    private static String which(String classname, ClassLoader loader) {
        URL it;
        String classnameAsResource = classname.replace('.', '/') + ".class";
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        if ((it = ss.getResourceAsURL(loader, classnameAsResource)) != null) {
            return it.toString();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            debug = ss.getSystemProperty("jaxp.debug") != null;
        }
        catch (Exception _) {
            debug = false;
        }
        cacheProps = new Properties();
        firstTime = true;
        SERVICE_CLASS = class$javax$xml$xpath$XPathFactory == null ? (class$javax$xml$xpath$XPathFactory = XPathFactoryFinder.class$("javax.xml.xpath.XPathFactory")) : class$javax$xml$xpath$XPathFactory;
        SERVICE_ID = "META-INF/services/" + SERVICE_CLASS.getName();
    }

    private static abstract class SingleIterator
    implements Iterator {
        private boolean seen = false;

        private SingleIterator() {
        }

        public final void remove() {
            throw new UnsupportedOperationException();
        }

        public final boolean hasNext() {
            return !this.seen;
        }

        public final Object next() {
            if (this.seen) {
                throw new NoSuchElementException();
            }
            this.seen = true;
            return this.value();
        }

        protected abstract Object value();
    }
}

