/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository.zoo;

import ai.djl.engine.Engine;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.zoo.BaseModelLoader;
import ai.djl.repository.zoo.ModelLoader;
import ai.djl.repository.zoo.ModelZoo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultModelZoo
extends ModelZoo {
    public static final String GROUP_ID = "ai.djl.localmodelzoo";
    private static final Logger logger = LoggerFactory.getLogger(DefaultModelZoo.class);
    private List<ModelLoader> modelLoaders;

    public DefaultModelZoo() {
    }

    public DefaultModelZoo(String locations) {
        this.modelLoaders = this.parseLocation(locations);
    }

    @Override
    public List<ModelLoader> getModelLoaders() {
        if (this.modelLoaders != null) {
            return this.modelLoaders;
        }
        String locations = System.getProperty("ai.djl.repository.zoo.location");
        if (locations != null) {
            return this.parseLocation(locations);
        }
        return Collections.emptyList();
    }

    @Override
    public String getGroupId() {
        return GROUP_ID;
    }

    @Override
    public Set<String> getSupportedEngines() {
        return Engine.getAllEngines();
    }

    private List<ModelLoader> parseLocation(String locations) {
        String[] urls = locations.split("\\s*,\\s*");
        ArrayList<ModelLoader> list = new ArrayList<ModelLoader>(urls.length);
        for (String url : urls) {
            if (!url.isEmpty()) {
                Repository repo = Repository.newInstance(url, url);
                logger.debug("Scanning models in repo: {}, {}", repo.getClass(), (Object)url);
                List<MRL> mrls = repo.getResources();
                for (MRL mrl : mrls) {
                    list.add(new BaseModelLoader(mrl));
                }
                continue;
            }
            logger.warn("Model location is empty.");
        }
        return list;
    }
}

