/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.translate;

import ai.djl.Model;
import ai.djl.modality.cv.translator.ImageClassificationTranslatorFactory;
import ai.djl.ndarray.NDList;
import ai.djl.translate.NoopTranslator;
import ai.djl.translate.ServingTranslatorFactory;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Pair;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultTranslatorFactory
implements TranslatorFactory {
    protected Map<Pair<Type, Type>, Translator<?, ?>> translators;
    private ServingTranslatorFactory servingTranslatorFactory = new ServingTranslatorFactory();
    private ImageClassificationTranslatorFactory imageClassificationTranslatorFactory = new ImageClassificationTranslatorFactory();

    public <I, O> void registerTranslator(Class<I> input, Class<O> output, Translator<I, O> translator) {
        if (this.translators == null) {
            this.translators = new ConcurrentHashMap();
        }
        this.translators.put(new Pair<Class<I>, Class<O>>(input, output), translator);
    }

    @Override
    public Set<Pair<Type, Type>> getSupportedTypes() {
        HashSet<Pair<Type, Type>> set = new HashSet<Pair<Type, Type>>();
        if (this.translators != null) {
            set.addAll(this.translators.keySet());
        }
        set.add(new Pair<Class<NDList>, Class<NDList>>(NDList.class, NDList.class));
        return set;
    }

    @Override
    public boolean isSupported(Class<?> input, Class<?> output) {
        if (input == NDList.class && output == NDList.class) {
            return true;
        }
        if (this.translators != null && this.translators.containsKey(new Pair(input, output))) {
            return true;
        }
        return this.servingTranslatorFactory.isSupported(input, output) || this.imageClassificationTranslatorFactory.isSupported(input, output);
    }

    @Override
    public Translator<?, ?> newInstance(Class<?> input, Class<?> output, Model model, Map<String, ?> arguments) throws TranslateException {
        Translator<?, ?> translator;
        if (this.translators != null && (translator = this.translators.get(new Pair(input, output))) != null) {
            return translator;
        }
        if (input == NDList.class && output == NDList.class) {
            return new NoopTranslator();
        }
        if (this.servingTranslatorFactory.isSupported(input, output)) {
            return this.servingTranslatorFactory.newInstance(input, output, model, arguments);
        }
        if (this.imageClassificationTranslatorFactory.isSupported(input, output)) {
            return this.imageClassificationTranslatorFactory.newInstance(input, output, model, arguments);
        }
        return null;
    }
}

