/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.util.LinkedHashMap;
import java.util.Map;
import org.tensorflow.Graph;
import org.tensorflow.Operand;
import org.tensorflow.Output;
import org.tensorflow.Signature;
import org.tensorflow.Tensor;

public interface TensorFunction {
    public Signature signature();

    public Map<String, Tensor> call(Map<String, Tensor> var1);

    default public Tensor call(Tensor tensor) {
        if (this.signature().inputNames().size() > 1) {
            throw new IllegalArgumentException("Can't use call(Tensor) on function \"" + this.signature().methodName() + "\" with more than one input.");
        }
        if (this.signature().inputNames().size() < 1) {
            throw new IllegalArgumentException("Can't use call(Tensor) on function \"" + this.signature().methodName() + "\" with no inputs.");
        }
        if (this.signature().outputNames().size() > 1) {
            throw new IllegalArgumentException("Can't use call(Tensor) on function \"" + this.signature().methodName() + "\" with more than one output.");
        }
        if (this.signature().outputNames().size() < 1) {
            throw new IllegalArgumentException("Can't use call(Tensor) on function \"" + this.signature().methodName() + "\" with no outputs.");
        }
        String inputName = this.signature().inputNames().iterator().next();
        String outputName = this.signature().outputNames().iterator().next();
        LinkedHashMap<String, Tensor> inputMap = new LinkedHashMap<String, Tensor>();
        inputMap.put(inputName, tensor);
        return this.call(inputMap).get(outputName);
    }

    public static Operand<?> validateDescription(Signature.TensorDescription description, Graph graph, String name, String prefix) {
        Output<?> operand = graph.output(description.name);
        if (operand == null) {
            throw new IllegalArgumentException(prefix + " \"" + name + "\"'s operand \"" + description.name + "\" does not exist on the graph.");
        }
        if (operand.dataType() != description.dataType) {
            throw new IllegalArgumentException(prefix + " \"" + name + "\"'s operand \"" + description.name + "\" has data type " + (Object)((Object)operand.dataType()) + " in the graph, but the signature requires data type " + (Object)((Object)description.dataType) + ".");
        }
        if (!operand.shape().isCompatibleWith(description.shape)) {
            throw new IllegalArgumentException(prefix + " \"" + name + "\"'s operand \"" + description.name + "\" has shape " + operand.shape() + ", which is incompatible with the signature's required shape of " + description.shape + ".");
        }
        return operand;
    }
}

