/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="MaxPoolWithArgmax", inputsClass=Inputs.class)
public final class MaxPoolWithArgmax<T extends TNumber, U extends TNumber>
extends RawOp {
    public static final String OP_NAME = "MaxPoolWithArgmax";
    private Output<T> output;
    private Output<U> argmax;

    public MaxPoolWithArgmax(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
        this.argmax = operation.output(outputIdx++);
    }

    public static <T extends TNumber, U extends TNumber> MaxPoolWithArgmax<T, U> create(Scope scope, Operand<T> input, List<Long> ksize, List<Long> strides, Class<U> Targmax, String padding, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        long[] ksizeArray = new long[ksize.size()];
        for (int i = 0; i < ksizeArray.length; ++i) {
            ksizeArray[i] = ksize.get(i);
        }
        opBuilder.setAttr("ksize", ksizeArray);
        long[] stridesArray = new long[strides.size()];
        for (int i = 0; i < stridesArray.length; ++i) {
            stridesArray[i] = strides.get(i);
        }
        opBuilder.setAttr("strides", stridesArray);
        opBuilder.setAttr("Targmax", Operands.toDataType(Targmax));
        opBuilder.setAttr("padding", padding);
        if (options != null) {
            for (Options opts : options) {
                if (opts.includeBatchInIndex == null) continue;
                opBuilder.setAttr("include_batch_in_index", opts.includeBatchInIndex);
            }
        }
        return new MaxPoolWithArgmax<T, U>(opBuilder.build());
    }

    public static <T extends TNumber> MaxPoolWithArgmax<T, TInt64> create(Scope scope, Operand<T> input, List<Long> ksize, List<Long> strides, String padding, Options[] options) {
        return MaxPoolWithArgmax.create(scope, input, ksize, strides, TInt64.class, padding, options);
    }

    public static Options includeBatchInIndex(Boolean includeBatchInIndex) {
        return new Options().includeBatchInIndex(includeBatchInIndex);
    }

    public Output<T> output() {
        return this.output;
    }

    public Output<U> argmax() {
        return this.argmax;
    }

    @OpInputsMetadata(outputsClass=MaxPoolWithArgmax.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<MaxPoolWithArgmax<T, ?>> {
        public final Operand<T> input;
        public final long[] ksize;
        public final long[] strides;
        public final DataType Targmax;
        public final String padding;
        public final boolean includeBatchInIndex;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new MaxPoolWithArgmax(op), op, Arrays.asList("ksize", "strides", "Targmax", "padding", "include_batch_in_index", "T"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.ksize = op.attributes().getAttrIntList("ksize");
            this.strides = op.attributes().getAttrIntList("strides");
            this.Targmax = op.attributes().getAttrType("Targmax");
            this.padding = op.attributes().getAttrString("padding");
            this.includeBatchInIndex = op.attributes().getAttrBool("include_batch_in_index");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private Boolean includeBatchInIndex;

        private Options() {
        }

        public Options includeBatchInIndex(Boolean includeBatchInIndex) {
            this.includeBatchInIndex = includeBatchInIndex;
            return this;
        }
    }
}

