/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.quantization;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="QuantizeAndDequantizeV4", inputsClass=Inputs.class)
public final class QuantizeAndDequantizeV4<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "QuantizeAndDequantizeV4";
    private Output<T> output;

    public QuantizeAndDequantizeV4(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TNumber> QuantizeAndDequantizeV4<T> create(Scope scope, Operand<T> input, Operand<T> inputMin, Operand<T> inputMax, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(inputMin.asOutput());
        opBuilder.addInput(inputMax.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.signedInput != null) {
                    opBuilder.setAttr("signed_input", opts.signedInput);
                }
                if (opts.numBits != null) {
                    opBuilder.setAttr("num_bits", opts.numBits);
                }
                if (opts.rangeGiven != null) {
                    opBuilder.setAttr("range_given", opts.rangeGiven);
                }
                if (opts.roundMode != null) {
                    opBuilder.setAttr("round_mode", opts.roundMode);
                }
                if (opts.narrowRange != null) {
                    opBuilder.setAttr("narrow_range", opts.narrowRange);
                }
                if (opts.axis == null) continue;
                opBuilder.setAttr("axis", opts.axis);
            }
        }
        return new QuantizeAndDequantizeV4<T>(opBuilder.build());
    }

    public static Options signedInput(Boolean signedInput) {
        return new Options().signedInput(signedInput);
    }

    public static Options numBits(Long numBits) {
        return new Options().numBits(numBits);
    }

    public static Options rangeGiven(Boolean rangeGiven) {
        return new Options().rangeGiven(rangeGiven);
    }

    public static Options roundMode(String roundMode) {
        return new Options().roundMode(roundMode);
    }

    public static Options narrowRange(Boolean narrowRange) {
        return new Options().narrowRange(narrowRange);
    }

    public static Options axis(Long axis) {
        return new Options().axis(axis);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=QuantizeAndDequantizeV4.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<QuantizeAndDequantizeV4<T>> {
        public final Operand<T> input;
        public final Operand<T> inputMin;
        public final Operand<T> inputMax;
        public final boolean signedInput;
        public final long numBits;
        public final boolean rangeGiven;
        public final DataType T;
        public final String roundMode;
        public final boolean narrowRange;
        public final long axis;

        public Inputs(GraphOperation op) {
            super(new QuantizeAndDequantizeV4(op), op, Arrays.asList("signed_input", "num_bits", "range_given", "T", "round_mode", "narrow_range", "axis"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.inputMin = op.input(inputIndex++);
            this.inputMax = op.input(inputIndex++);
            this.signedInput = op.attributes().getAttrBool("signed_input");
            this.numBits = op.attributes().getAttrInt("num_bits");
            this.rangeGiven = op.attributes().getAttrBool("range_given");
            this.T = op.attributes().getAttrType("T");
            this.roundMode = op.attributes().getAttrString("round_mode");
            this.narrowRange = op.attributes().getAttrBool("narrow_range");
            this.axis = op.attributes().getAttrInt("axis");
        }
    }

    public static class Options {
        private Boolean signedInput;
        private Long numBits;
        private Boolean rangeGiven;
        private String roundMode;
        private Boolean narrowRange;
        private Long axis;

        private Options() {
        }

        public Options signedInput(Boolean signedInput) {
            this.signedInput = signedInput;
            return this;
        }

        public Options numBits(Long numBits) {
            this.numBits = numBits;
            return this;
        }

        public Options rangeGiven(Boolean rangeGiven) {
            this.rangeGiven = rangeGiven;
            return this;
        }

        public Options roundMode(String roundMode) {
            this.roundMode = roundMode;
            return this;
        }

        public Options narrowRange(Boolean narrowRange) {
            this.narrowRange = narrowRange;
            return this;
        }

        public Options axis(Long axis) {
            this.axis = axis;
            return this;
        }
    }
}

