/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import androidx.navigation.NavDestination;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import java.util.HashMap;
import java.util.Map;

@SuppressLint(value={"TypeParameterUnusedInFormals"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class SimpleNavigatorProvider
implements NavigatorProvider {
    private static final HashMap<Class, String> sAnnotationNames = new HashMap();
    private final HashMap<String, Navigator<? extends NavDestination>> mNavigators = new HashMap();

    @NonNull
    private String getNameForNavigator(@NonNull Class<? extends Navigator> navigatorClass) {
        String name = sAnnotationNames.get(navigatorClass);
        if (name == null) {
            Navigator.Name annotation = navigatorClass.getAnnotation(Navigator.Name.class);
            String string = name = annotation != null ? annotation.value() : null;
            if (!this.validateName(name)) {
                throw new IllegalArgumentException("No @Navigator.Name annotation found for " + navigatorClass.getSimpleName());
            }
            sAnnotationNames.put(navigatorClass, name);
        }
        return name;
    }

    @Override
    @NonNull
    public <D extends NavDestination, T extends Navigator<? extends D>> T getNavigator(@NonNull Class<T> navigatorClass) {
        String name = this.getNameForNavigator(navigatorClass);
        return this.getNavigator(name);
    }

    @Override
    @NonNull
    public <D extends NavDestination, T extends Navigator<? extends D>> T getNavigator(@NonNull String name) {
        if (!this.validateName(name)) {
            throw new IllegalArgumentException("navigator name cannot be an empty string");
        }
        Navigator<? extends NavDestination> navigator = this.mNavigators.get(name);
        if (navigator == null) {
            throw new IllegalStateException("Could not find Navigator with name \"" + name + "\". You must call NavController.addNavigator() for each navigation type.");
        }
        return (T)navigator;
    }

    @Override
    @Nullable
    public Navigator<? extends NavDestination> addNavigator(@NonNull Navigator<? extends NavDestination> navigator) {
        String name = this.getNameForNavigator(navigator.getClass());
        return this.addNavigator(name, navigator);
    }

    @Override
    @Nullable
    public Navigator<? extends NavDestination> addNavigator(@NonNull String name, @NonNull Navigator<? extends NavDestination> navigator) {
        if (!this.validateName(name)) {
            throw new IllegalArgumentException("navigator name cannot be an empty string");
        }
        return this.mNavigators.put(name, navigator);
    }

    Map<String, Navigator<? extends NavDestination>> getNavigators() {
        return this.mNavigators;
    }

    private boolean validateName(String name) {
        return name != null && !name.isEmpty();
    }
}

