/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.CallSuper;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.Pair;
import android.support.v4.util.SparseArrayCompat;
import android.util.AttributeSet;
import androidx.navigation.NavAction;
import androidx.navigation.NavDeepLink;
import androidx.navigation.NavGraph;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import androidx.navigation.common.R;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;

public class NavDestination {
    private static final HashMap<String, Class> sClasses = new HashMap();
    private final String mNavigatorName;
    private NavGraph mParent;
    private int mId;
    private String mIdName;
    private CharSequence mLabel;
    private Bundle mDefaultArgs;
    private ArrayList<NavDeepLink> mDeepLinks;
    private SparseArrayCompat<NavAction> mActions;

    @NonNull
    protected static <C> Class<? extends C> parseClassFromName(@NonNull Context context, @NonNull String name, @NonNull Class<? extends C> expectedClassType) {
        Class<?> clazz;
        if (name.charAt(0) == '.') {
            name = context.getPackageName() + name;
        }
        if ((clazz = sClasses.get(name)) == null) {
            try {
                clazz = Class.forName(name, true, context.getClassLoader());
                sClasses.put(name, clazz);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (!expectedClassType.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(name + " must be a subclass of " + expectedClassType);
        }
        return clazz;
    }

    @NonNull
    static String getDisplayName(@NonNull Context context, int id) {
        try {
            return context.getResources().getResourceName(id);
        }
        catch (Resources.NotFoundException e) {
            return Integer.toString(id);
        }
    }

    public NavDestination(@NonNull Navigator<? extends NavDestination> navigator) {
        this(NavigatorProvider.getNameForNavigator(navigator.getClass()));
    }

    public NavDestination(@NonNull String navigatorName) {
        this.mNavigatorName = navigatorName;
    }

    @CallSuper
    public void onInflate(@NonNull Context context, @NonNull AttributeSet attrs) {
        TypedArray a = context.getResources().obtainAttributes(attrs, R.styleable.Navigator);
        this.setId(a.getResourceId(R.styleable.Navigator_android_id, 0));
        this.mIdName = NavDestination.getDisplayName(context, this.mId);
        this.setLabel(a.getText(R.styleable.Navigator_android_label));
        a.recycle();
    }

    final void setParent(NavGraph parent) {
        this.mParent = parent;
    }

    @Nullable
    public final NavGraph getParent() {
        return this.mParent;
    }

    @IdRes
    public final int getId() {
        return this.mId;
    }

    public final void setId(@IdRes int id) {
        this.mId = id;
        this.mIdName = null;
    }

    @NonNull
    String getDisplayName() {
        if (this.mIdName == null) {
            this.mIdName = Integer.toString(this.mId);
        }
        return this.mIdName;
    }

    public final void setLabel(@Nullable CharSequence label) {
        this.mLabel = label;
    }

    @Nullable
    public final CharSequence getLabel() {
        return this.mLabel;
    }

    @NonNull
    public final String getNavigatorName() {
        return this.mNavigatorName;
    }

    @NonNull
    public final Bundle getDefaultArguments() {
        if (this.mDefaultArgs == null) {
            this.mDefaultArgs = new Bundle();
        }
        return this.mDefaultArgs;
    }

    public final void setDefaultArguments(@Nullable Bundle args) {
        this.mDefaultArgs = args;
    }

    public final void addDefaultArguments(@NonNull Bundle args) {
        this.getDefaultArguments().putAll(args);
    }

    public final void addDeepLink(@NonNull String uriPattern) {
        if (this.mDeepLinks == null) {
            this.mDeepLinks = new ArrayList();
        }
        this.mDeepLinks.add(new NavDeepLink(uriPattern));
    }

    @Nullable
    Pair<NavDestination, Bundle> matchDeepLink(@NonNull Uri uri) {
        if (this.mDeepLinks == null) {
            return null;
        }
        for (NavDeepLink deepLink : this.mDeepLinks) {
            Bundle matchingArguments = deepLink.getMatchingArguments(uri);
            if (matchingArguments == null) continue;
            return Pair.create((Object)this, (Object)matchingArguments);
        }
        return null;
    }

    @NonNull
    int[] buildDeepLinkIds() {
        NavGraph parent;
        ArrayDeque<NavDestination> hierarchy = new ArrayDeque<NavDestination>();
        NavDestination current = this;
        do {
            if ((parent = current.getParent()) != null && parent.getStartDestination() == current.getId()) continue;
            hierarchy.addFirst(current);
        } while ((current = parent) != null);
        int[] deepLinkIds = new int[hierarchy.size()];
        int index = 0;
        for (NavDestination destination : hierarchy) {
            deepLinkIds[index++] = destination.getId();
        }
        return deepLinkIds;
    }

    boolean supportsActions() {
        return true;
    }

    @Nullable
    public final NavAction getAction(@IdRes int id) {
        NavAction destination;
        NavAction navAction = destination = this.mActions == null ? null : (NavAction)this.mActions.get(id);
        return destination != null ? destination : (this.getParent() != null ? this.getParent().getAction(id) : null);
    }

    public final void putAction(@IdRes int actionId, @IdRes int destId) {
        this.putAction(actionId, new NavAction(destId));
    }

    public final void putAction(@IdRes int actionId, @NonNull NavAction action) {
        if (!this.supportsActions()) {
            throw new UnsupportedOperationException("Cannot add action " + actionId + " to " + this + " as it does not support actions, indicating that it is a " + "terminal destination in your navigation graph and will never trigger " + "actions.");
        }
        if (actionId == 0) {
            throw new IllegalArgumentException("Cannot have an action with actionId 0");
        }
        if (this.mActions == null) {
            this.mActions = new SparseArrayCompat();
        }
        this.mActions.put(actionId, (Object)action);
    }

    public final void removeAction(@IdRes int actionId) {
        if (this.mActions == null) {
            return;
        }
        this.mActions.delete(actionId);
    }

    @Nullable
    Bundle addInDefaultArgs(@Nullable Bundle args) {
        Bundle defaultArgs = this.getDefaultArguments();
        if (args == null && defaultArgs.isEmpty()) {
            return null;
        }
        Bundle finalArgs = new Bundle();
        finalArgs.putAll(defaultArgs);
        if (args != null) {
            finalArgs.putAll(args);
        }
        return finalArgs;
    }

    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.TYPE})
    public static @interface ClassType {
        public Class value();
    }
}

