/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.AnimRes;
import android.support.annotation.AnimatorRes;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

public final class NavOptions {
    private static final String KEY_NAV_OPTIONS = "android-support-nav:navOptions";
    private static final String KEY_SINGLE_TOP = "singleTop";
    private static final String KEY_POP_UP_TO = "popUpTo";
    private static final String KEY_POP_UP_TO_INCLUSIVE = "popUpToInclusive";
    private static final String KEY_ENTER_ANIM = "enterAnim";
    private static final String KEY_EXIT_ANIM = "exitAnim";
    private static final String KEY_POP_ENTER_ANIM = "popEnterAnim";
    private static final String KEY_POP_EXIT_ANIM = "popExitAnim";
    private boolean mSingleTop;
    @IdRes
    private int mPopUpTo;
    private boolean mPopUpToInclusive;
    @AnimRes
    @AnimatorRes
    private int mEnterAnim;
    @AnimRes
    @AnimatorRes
    private int mExitAnim;
    @AnimRes
    @AnimatorRes
    private int mPopEnterAnim;
    @AnimRes
    @AnimatorRes
    private int mPopExitAnim;

    public static void addPopAnimationsToIntent(@NonNull Intent intent, @Nullable NavOptions navOptions) {
        if (navOptions != null) {
            intent.putExtra(KEY_NAV_OPTIONS, navOptions.toBundle());
        }
    }

    public static void applyPopAnimationsToPendingTransition(@NonNull Activity activity) {
        Intent intent = activity.getIntent();
        if (intent == null) {
            return;
        }
        Bundle bundle = intent.getBundleExtra(KEY_NAV_OPTIONS);
        if (bundle != null) {
            NavOptions navOptions = NavOptions.fromBundle(bundle);
            int popEnterAnim = navOptions.getPopEnterAnim();
            int popExitAnim = navOptions.getPopExitAnim();
            if (popEnterAnim != -1 || popExitAnim != -1) {
                popEnterAnim = popEnterAnim != -1 ? popEnterAnim : 0;
                popExitAnim = popExitAnim != -1 ? popExitAnim : 0;
                activity.overridePendingTransition(popEnterAnim, popExitAnim);
            }
        }
    }

    NavOptions(boolean singleTop, @IdRes int popUpTo, boolean popUpToInclusive, @AnimRes @AnimatorRes int enterAnim, @AnimRes @AnimatorRes int exitAnim, @AnimRes @AnimatorRes int popEnterAnim, @AnimRes @AnimatorRes int popExitAnim) {
        this.mSingleTop = singleTop;
        this.mPopUpTo = popUpTo;
        this.mPopUpToInclusive = popUpToInclusive;
        this.mEnterAnim = enterAnim;
        this.mExitAnim = exitAnim;
        this.mPopEnterAnim = popEnterAnim;
        this.mPopExitAnim = popExitAnim;
    }

    public boolean shouldLaunchSingleTop() {
        return this.mSingleTop;
    }

    @IdRes
    public int getPopUpTo() {
        return this.mPopUpTo;
    }

    public boolean isPopUpToInclusive() {
        return this.mPopUpToInclusive;
    }

    @AnimRes
    @AnimatorRes
    public int getEnterAnim() {
        return this.mEnterAnim;
    }

    @AnimRes
    @AnimatorRes
    public int getExitAnim() {
        return this.mExitAnim;
    }

    @AnimRes
    @AnimatorRes
    public int getPopEnterAnim() {
        return this.mPopEnterAnim;
    }

    @AnimRes
    @AnimatorRes
    public int getPopExitAnim() {
        return this.mPopExitAnim;
    }

    @NonNull
    private Bundle toBundle() {
        Bundle b = new Bundle();
        b.putBoolean(KEY_SINGLE_TOP, this.mSingleTop);
        b.putInt(KEY_POP_UP_TO, this.mPopUpTo);
        b.putBoolean(KEY_POP_UP_TO_INCLUSIVE, this.mPopUpToInclusive);
        b.putInt(KEY_ENTER_ANIM, this.mEnterAnim);
        b.putInt(KEY_EXIT_ANIM, this.mExitAnim);
        b.putInt(KEY_POP_ENTER_ANIM, this.mPopEnterAnim);
        b.putInt(KEY_POP_EXIT_ANIM, this.mPopExitAnim);
        return b;
    }

    @NonNull
    private static NavOptions fromBundle(@NonNull Bundle b) {
        return new NavOptions(b.getBoolean(KEY_SINGLE_TOP, false), b.getInt(KEY_POP_UP_TO, 0), b.getBoolean(KEY_POP_UP_TO_INCLUSIVE, false), b.getInt(KEY_ENTER_ANIM, -1), b.getInt(KEY_EXIT_ANIM, -1), b.getInt(KEY_POP_ENTER_ANIM, -1), b.getInt(KEY_POP_EXIT_ANIM, -1));
    }

    public static final class Builder {
        boolean mSingleTop;
        @IdRes
        int mPopUpTo;
        boolean mPopUpToInclusive;
        @AnimRes
        @AnimatorRes
        int mEnterAnim = -1;
        @AnimRes
        @AnimatorRes
        int mExitAnim = -1;
        @AnimRes
        @AnimatorRes
        int mPopEnterAnim = -1;
        @AnimRes
        @AnimatorRes
        int mPopExitAnim = -1;

        @NonNull
        public Builder setLaunchSingleTop(boolean singleTop) {
            this.mSingleTop = singleTop;
            return this;
        }

        @NonNull
        public Builder setPopUpTo(@IdRes int destinationId, boolean inclusive) {
            this.mPopUpTo = destinationId;
            this.mPopUpToInclusive = inclusive;
            return this;
        }

        @NonNull
        public Builder setEnterAnim(@AnimRes @AnimatorRes int enterAnim) {
            this.mEnterAnim = enterAnim;
            return this;
        }

        @NonNull
        public Builder setExitAnim(@AnimRes @AnimatorRes int exitAnim) {
            this.mExitAnim = exitAnim;
            return this;
        }

        @NonNull
        public Builder setPopEnterAnim(@AnimRes @AnimatorRes int popEnterAnim) {
            this.mPopEnterAnim = popEnterAnim;
            return this;
        }

        @NonNull
        public Builder setPopExitAnim(@AnimRes @AnimatorRes int popExitAnim) {
            this.mPopExitAnim = popExitAnim;
            return this;
        }

        @NonNull
        public NavOptions build() {
            return new NavOptions(this.mSingleTop, this.mPopUpTo, this.mPopUpToInclusive, this.mEnterAnim, this.mExitAnim, this.mPopEnterAnim, this.mPopExitAnim);
        }
    }
}

