/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.safe.args.generator;

import androidx.navigation.safe.args.generator.BooleanValue;
import androidx.navigation.safe.args.generator.FloatValue;
import androidx.navigation.safe.args.generator.IntValue;
import androidx.navigation.safe.args.generator.NavParserKt;
import androidx.navigation.safe.args.generator.NavType;
import androidx.navigation.safe.args.generator.ReferenceValue;
import androidx.navigation.safe.args.generator.StringValue;
import androidx.navigation.safe.args.generator.WriteableValue;
import androidx.navigation.safe.args.generator.XmlPullParserExtKt;
import androidx.navigation.safe.args.generator.models.Action;
import androidx.navigation.safe.args.generator.models.Argument;
import androidx.navigation.safe.args.generator.models.Destination;
import androidx.navigation.safe.args.generator.models.ResReference;
import com.squareup.javapoet.ClassName;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u001a \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0001H\u0000\u001a \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u0001H\u0000\u001a\u001e\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0001\u001a\u001c\u0010'\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u0001H\u0000\u001a\u0018\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0001H\u0000\u001a\u0012\u0010*\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0001H\u0002\u001a\u0012\u0010+\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0019\u001a\u00020\u0001H\u0002\u001a\u0012\u0010,\u001a\u0004\u0018\u00010#2\u0006\u0010\u0019\u001a\u00020\u0001H\u0002\u001a\u001a\u0010-\u001a\u0004\u0018\u00010 2\u0006\u0010)\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"ATTRIBUTE_DEFAULT_VALUE", "", "ATTRIBUTE_DESTINATION", "ATTRIBUTE_ID", "ATTRIBUTE_NAME", "ATTRIBUTE_TYPE", "NAMESPACE_ANDROID", "NAMESPACE_RES_AUTO", "RESOURCE_REGEX", "Lkotlin/text/Regex;", "TAG_ACTION", "TAG_ARGUMENT", "TAG_NAVIGATION", "inferArgument", "Landroidx/navigation/safe/args/generator/models/Argument;", "name", "defaultValue", "rFilePackage", "parseAction", "Landroidx/navigation/safe/args/generator/models/Action;", "parser", "Lorg/xmlpull/v1/XmlPullParser;", "parseArgument", "parseBooleanValue", "Landroidx/navigation/safe/args/generator/BooleanValue;", "value", "parseDestination", "Landroidx/navigation/safe/args/generator/models/Destination;", "applicationId", "parseFloatValue", "Landroidx/navigation/safe/args/generator/FloatValue;", "parseId", "Landroidx/navigation/safe/args/generator/models/ResReference;", "xmlId", "parseIntValue", "Landroidx/navigation/safe/args/generator/IntValue;", "parseNavigationFile", "navigationXml", "Ljava/io/File;", "parseNullableId", "parseReference", "xmlValue", "tryToParseBoolean", "tryToParseFloatValue", "tryToParseIntValue", "tryToParseReference", "navigation-safe-args-generator"})
public final class NavParserKt {
    private static final String TAG_NAVIGATION = "navigation";
    private static final String TAG_ACTION = "action";
    private static final String TAG_ARGUMENT = "argument";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_DESTINATION = "destination";
    private static final String ATTRIBUTE_DEFAULT_VALUE = "defaultValue";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String NAMESPACE_RES_AUTO = "http://schemas.android.com/apk/res-auto";
    private static final String NAMESPACE_ANDROID = "http://schemas.android.com/apk/res/android";
    private static final Regex RESOURCE_REGEX = new Regex("^@[+]?(.+?:)?(.+?)/(.+)$");

    private static final Destination parseDestination(XmlPullParser parser, String rFilePackage, String applicationId) {
        Collection collection;
        String type = parser.getName();
        String string = XmlPullParserExtKt.attrValue(parser, NAMESPACE_ANDROID, ATTRIBUTE_NAME);
        if (string == null) {
            string = "";
        }
        String name = string;
        String idValue = XmlPullParserExtKt.attrValue(parser, NAMESPACE_ANDROID, ATTRIBUTE_ID);
        List args = new ArrayList();
        List actions = new ArrayList();
        List nested = new ArrayList();
        XmlPullParserExtKt.traverseInnerStartTags(parser, (Function1<? super XmlPullParser, Unit>)((Function1)new Function1<XmlPullParser, Unit>(parser, actions, rFilePackage, args, type, nested, applicationId){
            final /* synthetic */ XmlPullParser $parser;
            final /* synthetic */ List $actions;
            final /* synthetic */ String $rFilePackage;
            final /* synthetic */ List $args;
            final /* synthetic */ String $type;
            final /* synthetic */ List $nested;
            final /* synthetic */ String $applicationId;

            public final void invoke(@NotNull XmlPullParser it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (Intrinsics.areEqual((Object)this.$parser.getName(), (Object)"action")) {
                    this.$actions.add(NavParserKt.access$parseAction(this.$parser, this.$rFilePackage));
                } else if (Intrinsics.areEqual((Object)this.$parser.getName(), (Object)"argument")) {
                    this.$args.add(NavParserKt.access$parseArgument(this.$parser, this.$rFilePackage));
                } else if (Intrinsics.areEqual((Object)this.$type, (Object)"navigation")) {
                    this.$nested.add(NavParserKt.access$parseDestination(this.$parser, this.$rFilePackage, this.$applicationId));
                }
            }
            {
                this.$parser = xmlPullParser;
                this.$actions = list;
                this.$rFilePackage = string;
                this.$args = list2;
                this.$type = string2;
                this.$nested = list3;
                this.$applicationId = string3;
                super(1);
            }
        }));
        ResReference id = NavParserKt.parseNullableId(idValue, rFilePackage);
        ClassName className = Destination.Companion.createName(id, name, applicationId);
        if (className == null && (!(collection = (Collection)actions).isEmpty() || !(collection = (Collection)args).isEmpty())) {
            throw (Throwable)new IllegalArgumentException("Destination with arguments or action mush have either name either id attributes");
        }
        String string2 = type;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)ATTRIBUTE_TYPE);
        return new Destination(id, className, string2, args, actions, nested);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final Argument parseArgument(XmlPullParser parser, String rFilePackage) {
        block21: {
            block17: {
                block18: {
                    block19: {
                        block20: {
                            name = XmlPullParserExtKt.attrValueOrThrow(parser, "http://schemas.android.com/apk/res/android", "name");
                            defaultValue = XmlPullParserExtKt.attrValue(parser, "http://schemas.android.com/apk/res/android", "defaultValue");
                            typeString = XmlPullParserExtKt.attrValue(parser, "http://schemas.android.com/apk/res-auto", "type");
                            if (typeString == null && defaultValue != null) {
                                return NavParserKt.inferArgument(name, defaultValue, rFilePackage);
                            }
                            v0 = var8_5 = typeString;
                            if (v0 == null) break block17;
                            switch (v0.hashCode()) {
                                case -925155509: {
                                    if (!var8_5.equals("reference")) ** break;
                                    break block18;
                                }
                                case 64711720: {
                                    if (!var8_5.equals("boolean")) ** break;
                                    break block19;
                                }
                                case 1958052158: {
                                    if (!var8_5.equals("integer")) ** break;
                                    break;
                                }
                                case 97526364: {
                                    if (!var8_5.equals("float")) ** break;
                                    break block20;
                                }
                            }
                            v1 = NavType.INT;
                            v2 = defaultValue;
                            if (v2 != null) {
                                var9_6 = v2;
                                var12_7 = v1;
                                it = var9_6;
                                var13_9 /* !! */  = NavParserKt.parseIntValue(defaultValue);
                                v1 = var12_7;
                                v3 /* !! */  = var13_9 /* !! */ ;
                            } else {
                                v3 /* !! */  = null;
                            }
                            v4 = TuplesKt.to((Object)v1, v3 /* !! */ );
                            break block21;
                        }
                        v5 = NavType.FLOAT;
                        v6 = defaultValue;
                        if (v6 != null) {
                            var9_6 = v6;
                            var12_7 = v5;
                            it = var9_6;
                            var13_9 /* !! */  = NavParserKt.parseFloatValue(defaultValue);
                            v5 = var12_7;
                            v7 /* !! */  = var13_9 /* !! */ ;
                        } else {
                            v7 /* !! */  = null;
                        }
                        v4 = TuplesKt.to((Object)v5, v7 /* !! */ );
                        break block21;
                    }
                    v8 = NavType.BOOLEAN;
                    v9 = defaultValue;
                    if (v9 != null) {
                        var9_6 = v9;
                        var12_7 = v8;
                        it = var9_6;
                        var13_9 /* !! */  = NavParserKt.parseBooleanValue(defaultValue);
                        v8 = var12_7;
                        v10 /* !! */  = var13_9 /* !! */ ;
                    } else {
                        v10 /* !! */  = null;
                    }
                    v4 = TuplesKt.to((Object)v8, v10 /* !! */ );
                    break block21;
                }
                v11 = NavType.REFERENCE;
                v12 = defaultValue;
                if (v12 != null) {
                    var9_6 = v12;
                    var12_7 = v11;
                    it = var9_6;
                    var13_9 /* !! */  = new ReferenceValue(NavParserKt.parseReference(defaultValue, rFilePackage));
                    v11 = var12_7;
                    v13 /* !! */  = var13_9 /* !! */ ;
                } else {
                    v13 /* !! */  = null;
                }
                v4 = TuplesKt.to((Object)v11, v13 /* !! */ );
                break block21;
            }
            v14 = NavType.STRING;
            v15 = defaultValue;
            if (v15 != null) {
                var9_6 = v15;
                var12_7 = v14;
                it = var9_6;
                var13_9 /* !! */  = new StringValue(it);
                v14 = var12_7;
                v16 = var13_9 /* !! */ ;
            } else {
                v16 = null;
            }
            v4 = TuplesKt.to((Object)v14, v16);
        }
        var7_10 = v4;
        var5_11 = (NavType)var7_10.component1();
        defaultTypedValue = (WriteableValue)var7_10.component2();
        return new Argument(name, (NavType)type, defaultTypedValue);
    }

    @NotNull
    public static final Argument inferArgument(@NotNull String name, @NotNull String defaultValue, @NotNull String rFilePackage) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)ATTRIBUTE_NAME);
        Intrinsics.checkParameterIsNotNull((Object)defaultValue, (String)ATTRIBUTE_DEFAULT_VALUE);
        Intrinsics.checkParameterIsNotNull((Object)rFilePackage, (String)"rFilePackage");
        ResReference reference = NavParserKt.tryToParseReference(defaultValue, rFilePackage);
        if (reference != null) {
            return new Argument(name, NavType.REFERENCE, new ReferenceValue(reference));
        }
        IntValue intValue = NavParserKt.tryToParseIntValue(defaultValue);
        if (intValue != null) {
            return new Argument(name, NavType.INT, intValue);
        }
        FloatValue floatValue = NavParserKt.tryToParseFloatValue(defaultValue);
        if (floatValue != null) {
            return new Argument(name, NavType.FLOAT, floatValue);
        }
        BooleanValue boolValue = NavParserKt.tryToParseBoolean(defaultValue);
        if (boolValue != null) {
            return new Argument(name, NavType.BOOLEAN, boolValue);
        }
        return new Argument(name, NavType.STRING, new StringValue(defaultValue));
    }

    private static final Action parseAction(XmlPullParser parser, String rFilePackage) {
        String idValue = XmlPullParserExtKt.attrValueOrThrow(parser, NAMESPACE_ANDROID, ATTRIBUTE_ID);
        String destValue = XmlPullParserExtKt.attrValue(parser, NAMESPACE_RES_AUTO, ATTRIBUTE_DESTINATION);
        List args = new ArrayList();
        XmlPullParserExtKt.traverseInnerStartTags(parser, (Function1<? super XmlPullParser, Unit>)((Function1)new Function1<XmlPullParser, Unit>(parser, args, rFilePackage){
            final /* synthetic */ XmlPullParser $parser;
            final /* synthetic */ List $args;
            final /* synthetic */ String $rFilePackage;

            public final void invoke(@NotNull XmlPullParser it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (Intrinsics.areEqual((Object)this.$parser.getName(), (Object)"argument")) {
                    this.$args.add(NavParserKt.access$parseArgument(this.$parser, this.$rFilePackage));
                }
            }
            {
                this.$parser = xmlPullParser;
                this.$args = list;
                this.$rFilePackage = string;
                super(1);
            }
        }));
        return new Action(NavParserKt.parseId(idValue, rFilePackage), NavParserKt.parseNullableId(destValue, rFilePackage), args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Destination parseNavigationFile(@NotNull File navigationXml, @NotNull String rFilePackage, @NotNull String applicationId) {
        Intrinsics.checkParameterIsNotNull((Object)navigationXml, (String)"navigationXml");
        Intrinsics.checkParameterIsNotNull((Object)rFilePackage, (String)"rFilePackage");
        Intrinsics.checkParameterIsNotNull((Object)applicationId, (String)"applicationId");
        Closeable closeable = new FileReader(navigationXml);
        Throwable throwable = null;
        try {
            XmlPullParser parser;
            XmlPullParser xmlPullParser;
            FileReader reader = (FileReader)closeable;
            XmlPullParser $receiver = xmlPullParser = XmlPullParserFactory.newInstance().newPullParser();
            $receiver.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            $receiver.setInput((Reader)reader);
            XmlPullParser xmlPullParser2 = parser = xmlPullParser;
            Intrinsics.checkExpressionValueIsNotNull((Object)xmlPullParser2, (String)"parser");
            XmlPullParserExtKt.traverseStartTags(xmlPullParser2, (Function1<? super XmlPullParser, Boolean>)((Function1)parseNavigationFile.1.1.INSTANCE));
            Destination destination = NavParserKt.parseDestination(parser, rFilePackage, applicationId);
            return destination;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final ResReference parseReference(@NotNull String xmlValue, @NotNull String rFilePackage) {
        Intrinsics.checkParameterIsNotNull((Object)xmlValue, (String)"xmlValue");
        Intrinsics.checkParameterIsNotNull((Object)rFilePackage, (String)"rFilePackage");
        ResReference resReference = NavParserKt.tryToParseReference(xmlValue, rFilePackage);
        if (resReference == null) {
            throw (Throwable)new IllegalArgumentException("id should be in format: " + "@[+][package:]res_type/resource_name, but is: " + xmlValue);
        }
        return resReference;
    }

    @Nullable
    public static final ResReference tryToParseReference(@NotNull String xmlValue, @NotNull String rFilePackage) {
        Intrinsics.checkParameterIsNotNull((Object)xmlValue, (String)"xmlValue");
        Intrinsics.checkParameterIsNotNull((Object)rFilePackage, (String)"rFilePackage");
        MatchResult matchResult = RESOURCE_REGEX.matchEntire((CharSequence)xmlValue);
        if (matchResult == null) {
            return null;
        }
        MatchResult matchEntire = matchResult;
        List groups = matchEntire.getGroupValues();
        String resourceName = (String)CollectionsKt.last((List)groups);
        String resType = (String)groups.get(groups.size() - 2);
        CharSequence charSequence = (CharSequence)groups.get(1);
        String packageName = charSequence.length() > 0 ? StringsKt.removeSuffix((String)((String)groups.get(1)), (CharSequence)":") : rFilePackage;
        return new ResReference(packageName, resType, resourceName);
    }

    @NotNull
    public static final ResReference parseId(@NotNull String xmlId, @NotNull String rFilePackage) {
        Intrinsics.checkParameterIsNotNull((Object)xmlId, (String)"xmlId");
        Intrinsics.checkParameterIsNotNull((Object)rFilePackage, (String)"rFilePackage");
        ResReference ref = NavParserKt.parseReference(xmlId, rFilePackage);
        if (!ref.isId()) {
            throw (Throwable)new IllegalArgumentException("" + xmlId + " was passed as id, but is " + ref.getResType());
        }
        return ref;
    }

    @Nullable
    public static final ResReference parseNullableId(@Nullable String xmlId, @NotNull String rFilePackage) {
        ResReference resReference;
        Intrinsics.checkParameterIsNotNull((Object)rFilePackage, (String)"rFilePackage");
        String string = xmlId;
        if (string != null) {
            String string2;
            String it = string2 = string;
            resReference = NavParserKt.parseId(it, rFilePackage);
        } else {
            resReference = null;
        }
        return resReference;
    }

    private static final IntValue tryToParseIntValue(String value) {
        try {
            if (StringsKt.startsWith$default((String)value, (String)"0x", (boolean)false, (int)2, null)) {
                String string = value;
                int n = 2;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                Integer.parseUnsignedInt(string3, 16);
            } else {
                Integer.parseInt(value);
            }
        }
        catch (NumberFormatException ex) {
            return null;
        }
        return new IntValue(value);
    }

    @NotNull
    public static final IntValue parseIntValue(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        IntValue intValue = NavParserKt.tryToParseIntValue(value);
        if (intValue == null) {
            throw (Throwable)new IllegalArgumentException("Failed to parse " + value + " as int");
        }
        return intValue;
    }

    private static final FloatValue tryToParseFloatValue(String value) {
        FloatValue floatValue;
        Float f = StringsKt.toFloatOrNull((String)value);
        if (f != null) {
            Float f2 = f;
            float it = ((Number)f2).floatValue();
            floatValue = new FloatValue(value);
        } else {
            floatValue = null;
        }
        return floatValue;
    }

    @NotNull
    public static final FloatValue parseFloatValue(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        FloatValue floatValue = NavParserKt.tryToParseFloatValue(value);
        if (floatValue == null) {
            throw (Throwable)new IllegalArgumentException("Failed to parse " + value + " as float");
        }
        return floatValue;
    }

    private static final BooleanValue tryToParseBoolean(String value) {
        if (Intrinsics.areEqual((Object)value, (Object)"true") || Intrinsics.areEqual((Object)value, (Object)"false")) {
            return new BooleanValue(value);
        }
        return null;
    }

    @NotNull
    public static final BooleanValue parseBooleanValue(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        BooleanValue booleanValue = NavParserKt.tryToParseBoolean(value);
        if (booleanValue == null) {
            throw (Throwable)new IllegalArgumentException("Failed to parse " + value + " as boolean");
        }
        return booleanValue;
    }

    @NotNull
    public static final /* synthetic */ Action access$parseAction(@NotNull XmlPullParser parser, @NotNull String rFilePackage) {
        return NavParserKt.parseAction(parser, rFilePackage);
    }

    @NotNull
    public static final /* synthetic */ Argument access$parseArgument(@NotNull XmlPullParser parser, @NotNull String rFilePackage) {
        return NavParserKt.parseArgument(parser, rFilePackage);
    }

    @NotNull
    public static final /* synthetic */ Destination access$parseDestination(@NotNull XmlPullParser parser, @NotNull String rFilePackage, @NotNull String applicationId) {
        return NavParserKt.parseDestination(parser, rFilePackage, applicationId);
    }
}

