/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.ui;

import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.BottomNavigationView;
import android.support.design.widget.NavigationView;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.app.ActionBar;
import android.support.v7.app.ActionBarDrawerToggle;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.graphics.drawable.DrawerArrowDrawable;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewParent;
import androidx.navigation.NavController;
import androidx.navigation.NavDestination;
import androidx.navigation.NavOptions;
import androidx.navigation.ui.R;

public class NavigationUI {
    private NavigationUI() {
    }

    public static boolean onNavDestinationSelected(@NonNull MenuItem item, @NonNull NavController navController) {
        return NavigationUI.onNavDestinationSelected(item, navController, false);
    }

    private static boolean onNavDestinationSelected(@NonNull MenuItem item, @NonNull NavController navController, boolean popUp) {
        NavOptions.Builder builder = new NavOptions.Builder().setLaunchSingleTop(true).setEnterAnim(R.anim.nav_default_enter_anim).setExitAnim(R.anim.nav_default_exit_anim).setPopEnterAnim(R.anim.nav_default_pop_enter_anim).setPopExitAnim(R.anim.nav_default_pop_exit_anim);
        if (popUp) {
            builder.setPopUpTo(navController.getGraph().getStartDestination(), false);
        }
        NavOptions options = builder.build();
        try {
            navController.navigate(item.getItemId(), null, options);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean navigateUp(@Nullable DrawerLayout drawerLayout, @NonNull NavController navController) {
        if (drawerLayout != null && navController.getCurrentDestination().getId() == navController.getGraph().getStartDestination()) {
            drawerLayout.openDrawer(0x800003);
            return true;
        }
        return navController.navigateUp();
    }

    public static void setupActionBarWithNavController(@NonNull AppCompatActivity activity, @NonNull NavController navController) {
        NavigationUI.setupActionBarWithNavController(activity, navController, null);
    }

    public static void setupActionBarWithNavController(@NonNull AppCompatActivity activity, @NonNull NavController navController, @Nullable DrawerLayout drawerLayout) {
        navController.addOnNavigatedListener((NavController.OnNavigatedListener)new ActionBarOnNavigatedListener(activity, drawerLayout));
    }

    public static void setupWithNavController(final @NonNull NavigationView navigationView, final @NonNull NavController navController) {
        navigationView.setNavigationItemSelectedListener(new NavigationView.OnNavigationItemSelectedListener(){

            public boolean onNavigationItemSelected(@NonNull MenuItem item) {
                ViewParent parent;
                boolean handled = NavigationUI.onNavDestinationSelected(item, navController, true);
                if (handled && (parent = navigationView.getParent()) instanceof DrawerLayout) {
                    ((DrawerLayout)parent).closeDrawer((View)navigationView);
                }
                return handled;
            }
        });
        navController.addOnNavigatedListener(new NavController.OnNavigatedListener(){

            public void onNavigated(@NonNull NavController controller, @NonNull NavDestination destination) {
                int destinationId = destination.getId();
                Menu menu = navigationView.getMenu();
                int size = menu.size();
                for (int h = 0; h < size; ++h) {
                    MenuItem item;
                    item.setChecked((item = menu.getItem(h)).getItemId() == destinationId);
                }
            }
        });
    }

    public static void setupWithNavController(final @NonNull BottomNavigationView bottomNavigationView, final @NonNull NavController navController) {
        bottomNavigationView.setOnNavigationItemSelectedListener(new BottomNavigationView.OnNavigationItemSelectedListener(){

            public boolean onNavigationItemSelected(@NonNull MenuItem item) {
                return NavigationUI.onNavDestinationSelected(item, navController, true);
            }
        });
        navController.addOnNavigatedListener(new NavController.OnNavigatedListener(){

            public void onNavigated(@NonNull NavController controller, @NonNull NavDestination destination) {
                int destinationId = destination.getId();
                Menu menu = bottomNavigationView.getMenu();
                int size = menu.size();
                for (int h = 0; h < size; ++h) {
                    MenuItem item = menu.getItem(h);
                    if (item.getItemId() != destinationId) continue;
                    item.setChecked(true);
                }
            }
        });
    }

    private static class ActionBarOnNavigatedListener
    implements NavController.OnNavigatedListener {
        private final AppCompatActivity mActivity;
        @Nullable
        private final DrawerLayout mDrawerLayout;
        private DrawerArrowDrawable mArrowDrawable;
        private ValueAnimator mAnimator;

        ActionBarOnNavigatedListener(@NonNull AppCompatActivity activity, @Nullable DrawerLayout drawerLayout) {
            this.mActivity = activity;
            this.mDrawerLayout = drawerLayout;
        }

        public void onNavigated(@NonNull NavController controller, @NonNull NavDestination destination) {
            ActionBar actionBar = this.mActivity.getSupportActionBar();
            CharSequence title = destination.getLabel();
            if (!TextUtils.isEmpty((CharSequence)title)) {
                actionBar.setTitle(title);
            }
            boolean isStartDestination = controller.getGraph().getStartDestination() == destination.getId();
            actionBar.setDisplayHomeAsUpEnabled(this.mDrawerLayout != null || !isStartDestination);
            this.setActionBarUpIndicator(this.mDrawerLayout != null && isStartDestination);
        }

        void setActionBarUpIndicator(boolean showAsDrawerIndicator) {
            float endValue;
            ActionBarDrawerToggle.Delegate delegate = this.mActivity.getDrawerToggleDelegate();
            boolean animate = true;
            if (this.mArrowDrawable == null) {
                this.mArrowDrawable = new DrawerArrowDrawable(delegate.getActionBarThemedContext());
                delegate.setActionBarUpIndicator((Drawable)this.mArrowDrawable, 0);
                animate = false;
            }
            float f = endValue = showAsDrawerIndicator ? 0.0f : 1.0f;
            if (animate) {
                float startValue = this.mArrowDrawable.getProgress();
                if (this.mAnimator != null) {
                    this.mAnimator.cancel();
                }
                this.mAnimator = ObjectAnimator.ofFloat((Object)this.mArrowDrawable, (String)"progress", (float[])new float[]{startValue, endValue});
                this.mAnimator.start();
            } else {
                this.mArrowDrawable.setProgress(endValue);
            }
        }
    }
}

