/*
 * Decompiled with CFR 0.152.
 */
package android.arch.paging;

import android.arch.paging.PositionalDataSource;
import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;

class ListDataSource<T>
extends PositionalDataSource<T> {
    private final List<T> mList;

    public ListDataSource(List<T> list) {
        this.mList = new ArrayList<T>(list);
    }

    @Override
    public void loadInitial(@NonNull PositionalDataSource.LoadInitialParams params, @NonNull PositionalDataSource.LoadInitialCallback<T> callback) {
        int totalCount = this.mList.size();
        int position = ListDataSource.computeInitialLoadPosition(params, totalCount);
        int loadSize = ListDataSource.computeInitialLoadSize(params, position, totalCount);
        List<T> sublist = this.mList.subList(position, position + loadSize);
        callback.onResult(sublist, position, totalCount);
    }

    @Override
    public void loadRange(@NonNull PositionalDataSource.LoadRangeParams params, @NonNull PositionalDataSource.LoadRangeCallback<T> callback) {
        callback.onResult(this.mList.subList(params.startPosition, params.startPosition + params.loadSize));
    }
}

