/*
 * Decompiled with CFR 0.152.
 */
package android.arch.paging;

import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.List;

class PageResult<T> {
    private static final PageResult INVALID_RESULT = new PageResult(Collections.EMPTY_LIST, 0);
    static final int INIT = 0;
    static final int APPEND = 1;
    static final int PREPEND = 2;
    static final int TILE = 3;
    @NonNull
    public final List<T> page;
    public final int leadingNulls;
    public final int trailingNulls;
    public final int positionOffset;

    static <T> PageResult<T> getInvalidResult() {
        return INVALID_RESULT;
    }

    PageResult(@NonNull List<T> list, int leadingNulls, int trailingNulls, int positionOffset) {
        this.page = list;
        this.leadingNulls = leadingNulls;
        this.trailingNulls = trailingNulls;
        this.positionOffset = positionOffset;
    }

    PageResult(@NonNull List<T> list, int positionOffset) {
        this.page = list;
        this.leadingNulls = 0;
        this.trailingNulls = 0;
        this.positionOffset = positionOffset;
    }

    public String toString() {
        return "Result " + this.leadingNulls + ", " + this.page + ", " + this.trailingNulls + ", offset " + this.positionOffset;
    }

    public boolean isInvalid() {
        return this == INVALID_RESULT;
    }

    static abstract class Receiver<T> {
        Receiver() {
        }

        @MainThread
        public abstract void onPageResult(int var1, @NonNull PageResult<T> var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface ResultType {
    }
}

