/*
 * Decompiled with CFR 0.152.
 */
package android.arch.paging;

import android.arch.core.util.Function;
import android.arch.paging.ContiguousDataSource;
import android.arch.paging.DataSource;
import android.arch.paging.PageResult;
import android.arch.paging.WrapperPositionalDataSource;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;

public abstract class PositionalDataSource<T>
extends DataSource<Integer, T> {
    final void dispatchLoadInitial(boolean acceptCount, int requestedStartPosition, int requestedLoadSize, int pageSize, @NonNull Executor mainThreadExecutor, @NonNull PageResult.Receiver<T> receiver) {
        LoadInitialCallbackImpl<T> callback = new LoadInitialCallbackImpl<T>(this, acceptCount, pageSize, receiver);
        LoadInitialParams params = new LoadInitialParams(requestedStartPosition, requestedLoadSize, pageSize, acceptCount);
        this.loadInitial(params, callback);
        callback.mCallbackHelper.setPostExecutor(mainThreadExecutor);
    }

    final void dispatchLoadRange(int resultType, int startPosition, int count, @NonNull Executor mainThreadExecutor, @NonNull PageResult.Receiver<T> receiver) {
        LoadRangeCallbackImpl callback = new LoadRangeCallbackImpl(this, resultType, startPosition, mainThreadExecutor, receiver);
        if (count == 0) {
            ((LoadRangeCallback)callback).onResult(Collections.emptyList());
        } else {
            this.loadRange(new LoadRangeParams(startPosition, count), callback);
        }
    }

    @WorkerThread
    public abstract void loadInitial(@NonNull LoadInitialParams var1, @NonNull LoadInitialCallback<T> var2);

    @WorkerThread
    public abstract void loadRange(@NonNull LoadRangeParams var1, @NonNull LoadRangeCallback<T> var2);

    @Override
    boolean isContiguous() {
        return false;
    }

    @NonNull
    ContiguousDataSource<Integer, T> wrapAsContiguousWithoutPlaceholders() {
        return new ContiguousWithoutPlaceholdersWrapper(this);
    }

    public static int computeInitialLoadPosition(@NonNull LoadInitialParams params, int totalCount) {
        int position = params.requestedStartPosition;
        int initialLoadSize = params.requestedLoadSize;
        int pageSize = params.pageSize;
        int roundedPageStart = Math.round(position / pageSize) * pageSize;
        int maximumLoadPage = (totalCount - initialLoadSize + pageSize - 1) / pageSize * pageSize;
        roundedPageStart = Math.min(maximumLoadPage, roundedPageStart);
        roundedPageStart = Math.max(0, roundedPageStart);
        return roundedPageStart;
    }

    public static int computeInitialLoadSize(@NonNull LoadInitialParams params, int initialLoadPosition, int totalCount) {
        return Math.min(totalCount - initialLoadPosition, params.requestedLoadSize);
    }

    @NonNull
    public final <V> PositionalDataSource<V> mapByPage(@NonNull Function<List<T>, List<V>> function) {
        return new WrapperPositionalDataSource<T, V>(this, function);
    }

    @NonNull
    public final <V> PositionalDataSource<V> map(@NonNull Function<T, V> function) {
        return this.mapByPage((Function)PositionalDataSource.createListFunction(function));
    }

    static class ContiguousWithoutPlaceholdersWrapper<Value>
    extends ContiguousDataSource<Integer, Value> {
        @NonNull
        final PositionalDataSource<Value> mSource;

        ContiguousWithoutPlaceholdersWrapper(@NonNull PositionalDataSource<Value> source) {
            this.mSource = source;
        }

        @Override
        public void addInvalidatedCallback(@NonNull DataSource.InvalidatedCallback onInvalidatedCallback) {
            this.mSource.addInvalidatedCallback(onInvalidatedCallback);
        }

        @Override
        public void removeInvalidatedCallback(@NonNull DataSource.InvalidatedCallback onInvalidatedCallback) {
            this.mSource.removeInvalidatedCallback(onInvalidatedCallback);
        }

        @Override
        public void invalidate() {
            this.mSource.invalidate();
        }

        @Override
        public boolean isInvalid() {
            return this.mSource.isInvalid();
        }

        @Override
        @NonNull
        public <ToValue> DataSource<Integer, ToValue> mapByPage(@NonNull Function<List<Value>, List<ToValue>> function) {
            throw new UnsupportedOperationException("Inaccessible inner type doesn't support map op");
        }

        @Override
        @NonNull
        public <ToValue> DataSource<Integer, ToValue> map(@NonNull Function<Value, ToValue> function) {
            throw new UnsupportedOperationException("Inaccessible inner type doesn't support map op");
        }

        @Override
        void dispatchLoadInitial(@Nullable Integer position, int initialLoadSize, int pageSize, boolean enablePlaceholders, @NonNull Executor mainThreadExecutor, @NonNull PageResult.Receiver<Value> receiver) {
            int convertPosition = position == null ? 0 : position;
            this.mSource.dispatchLoadInitial(false, convertPosition, initialLoadSize, pageSize, mainThreadExecutor, receiver);
        }

        @Override
        void dispatchLoadAfter(int currentEndIndex, @NonNull Value currentEndItem, int pageSize, @NonNull Executor mainThreadExecutor, @NonNull PageResult.Receiver<Value> receiver) {
            int startIndex = currentEndIndex + 1;
            this.mSource.dispatchLoadRange(1, startIndex, pageSize, mainThreadExecutor, receiver);
        }

        @Override
        void dispatchLoadBefore(int currentBeginIndex, @NonNull Value currentBeginItem, int pageSize, @NonNull Executor mainThreadExecutor, @NonNull PageResult.Receiver<Value> receiver) {
            int startIndex = currentBeginIndex - 1;
            if (startIndex < 0) {
                this.mSource.dispatchLoadRange(2, startIndex, 0, mainThreadExecutor, receiver);
            } else {
                int loadSize = Math.min(pageSize, startIndex + 1);
                startIndex = startIndex - loadSize + 1;
                this.mSource.dispatchLoadRange(2, startIndex, loadSize, mainThreadExecutor, receiver);
            }
        }

        @Override
        Integer getKey(int position, Value item) {
            return position;
        }
    }

    static class LoadRangeCallbackImpl<T>
    extends LoadRangeCallback<T> {
        private DataSource.LoadCallbackHelper<T> mCallbackHelper;
        private final int mPositionOffset;

        LoadRangeCallbackImpl(@NonNull PositionalDataSource dataSource, int resultType, int positionOffset, Executor mainThreadExecutor, PageResult.Receiver<T> receiver) {
            this.mCallbackHelper = new DataSource.LoadCallbackHelper<T>(dataSource, resultType, mainThreadExecutor, receiver);
            this.mPositionOffset = positionOffset;
        }

        @Override
        public void onResult(@NonNull List<T> data) {
            if (!this.mCallbackHelper.dispatchInvalidResultIfInvalid()) {
                this.mCallbackHelper.dispatchResultToReceiver(new PageResult<T>(data, 0, 0, this.mPositionOffset));
            }
        }
    }

    static class LoadInitialCallbackImpl<T>
    extends LoadInitialCallback<T> {
        final DataSource.LoadCallbackHelper<T> mCallbackHelper;
        private final boolean mCountingEnabled;
        private final int mPageSize;

        LoadInitialCallbackImpl(@NonNull PositionalDataSource dataSource, boolean countingEnabled, int pageSize, PageResult.Receiver<T> receiver) {
            this.mCallbackHelper = new DataSource.LoadCallbackHelper<T>(dataSource, 0, null, receiver);
            this.mCountingEnabled = countingEnabled;
            this.mPageSize = pageSize;
            if (this.mPageSize < 1) {
                throw new IllegalArgumentException("Page size must be non-negative");
            }
        }

        @Override
        public void onResult(@NonNull List<T> data, int position, int totalCount) {
            if (!this.mCallbackHelper.dispatchInvalidResultIfInvalid()) {
                DataSource.LoadCallbackHelper.validateInitialLoadParams(data, position, totalCount);
                if (position + data.size() != totalCount && data.size() % this.mPageSize != 0) {
                    throw new IllegalArgumentException("PositionalDataSource requires initial load size to be a multiple of page size to support internal tiling. loadSize " + data.size() + ", position " + position + ", totalCount " + totalCount + ", pageSize " + this.mPageSize);
                }
                if (this.mCountingEnabled) {
                    int trailingUnloadedCount = totalCount - position - data.size();
                    this.mCallbackHelper.dispatchResultToReceiver(new PageResult<T>(data, position, trailingUnloadedCount, 0));
                } else {
                    this.mCallbackHelper.dispatchResultToReceiver(new PageResult<T>(data, position));
                }
            }
        }

        @Override
        public void onResult(@NonNull List<T> data, int position) {
            if (!this.mCallbackHelper.dispatchInvalidResultIfInvalid()) {
                if (position < 0) {
                    throw new IllegalArgumentException("Position must be non-negative");
                }
                if (data.isEmpty() && position != 0) {
                    throw new IllegalArgumentException("Initial result cannot be empty if items are present in data set.");
                }
                if (this.mCountingEnabled) {
                    throw new IllegalStateException("Placeholders requested, but totalCount not provided. Please call the three-parameter onResult method, or disable placeholders in the PagedList.Config");
                }
                this.mCallbackHelper.dispatchResultToReceiver(new PageResult<T>(data, position));
            }
        }
    }

    public static abstract class LoadRangeCallback<T> {
        public abstract void onResult(@NonNull List<T> var1);
    }

    public static abstract class LoadInitialCallback<T> {
        public abstract void onResult(@NonNull List<T> var1, int var2, int var3);

        public abstract void onResult(@NonNull List<T> var1, int var2);
    }

    public static class LoadRangeParams {
        public final int startPosition;
        public final int loadSize;

        public LoadRangeParams(int startPosition, int loadSize) {
            this.startPosition = startPosition;
            this.loadSize = loadSize;
        }
    }

    public static class LoadInitialParams {
        public final int requestedStartPosition;
        public final int requestedLoadSize;
        public final int pageSize;
        public final boolean placeholdersEnabled;

        public LoadInitialParams(int requestedStartPosition, int requestedLoadSize, int pageSize, boolean placeholdersEnabled) {
            this.requestedStartPosition = requestedStartPosition;
            this.requestedLoadSize = requestedLoadSize;
            this.pageSize = pageSize;
            this.placeholdersEnabled = placeholdersEnabled;
        }
    }
}

