/*
 * Decompiled with CFR 0.152.
 */
package android.arch.paging;

import android.arch.paging.DataSource;
import android.arch.paging.PagedList;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

class SnapshotPagedList<T>
extends PagedList<T> {
    private final boolean mContiguous;
    private final Object mLastKey;
    private final DataSource<?, T> mDataSource;

    SnapshotPagedList(@NonNull PagedList<T> pagedList) {
        super(pagedList.mStorage.snapshot(), pagedList.mMainThreadExecutor, pagedList.mBackgroundThreadExecutor, null, pagedList.mConfig);
        this.mDataSource = pagedList.getDataSource();
        this.mContiguous = pagedList.isContiguous();
        this.mLastKey = pagedList.getLastKey();
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public boolean isDetached() {
        return true;
    }

    @Override
    boolean isContiguous() {
        return this.mContiguous;
    }

    @Override
    @Nullable
    public Object getLastKey() {
        return this.mLastKey;
    }

    @Override
    @NonNull
    public DataSource<?, T> getDataSource() {
        return this.mDataSource;
    }

    @Override
    void dispatchUpdatesSinceSnapshot(@NonNull PagedList<T> storageSnapshot, @NonNull PagedList.Callback callback) {
    }

    @Override
    void loadAroundInternal(int index) {
    }
}

