/*
 * Decompiled with CFR 0.152.
 */
package android.arch.paging;

import android.arch.core.util.Function;
import android.arch.paging.DataSource;
import android.arch.paging.PageKeyedDataSource;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.List;

class WrapperPageKeyedDataSource<K, A, B>
extends PageKeyedDataSource<K, B> {
    private final PageKeyedDataSource<K, A> mSource;
    private final Function<List<A>, List<B>> mListFunction;

    WrapperPageKeyedDataSource(PageKeyedDataSource<K, A> source, Function<List<A>, List<B>> listFunction) {
        this.mSource = source;
        this.mListFunction = listFunction;
    }

    @Override
    public void addInvalidatedCallback(@NonNull DataSource.InvalidatedCallback onInvalidatedCallback) {
        this.mSource.addInvalidatedCallback(onInvalidatedCallback);
    }

    @Override
    public void removeInvalidatedCallback(@NonNull DataSource.InvalidatedCallback onInvalidatedCallback) {
        this.mSource.removeInvalidatedCallback(onInvalidatedCallback);
    }

    @Override
    public void invalidate() {
        this.mSource.invalidate();
    }

    @Override
    public boolean isInvalid() {
        return this.mSource.isInvalid();
    }

    @Override
    public void loadInitial(@NonNull PageKeyedDataSource.LoadInitialParams<K> params, final @NonNull PageKeyedDataSource.LoadInitialCallback<K, B> callback) {
        this.mSource.loadInitial(params, new PageKeyedDataSource.LoadInitialCallback<K, A>(){

            @Override
            public void onResult(@NonNull List<A> data, int position, int totalCount, @Nullable K previousPageKey, @Nullable K nextPageKey) {
                callback.onResult(DataSource.convert(WrapperPageKeyedDataSource.this.mListFunction, data), position, totalCount, previousPageKey, nextPageKey);
            }

            @Override
            public void onResult(@NonNull List<A> data, @Nullable K previousPageKey, @Nullable K nextPageKey) {
                callback.onResult(DataSource.convert(WrapperPageKeyedDataSource.this.mListFunction, data), previousPageKey, nextPageKey);
            }
        });
    }

    @Override
    public void loadBefore(@NonNull PageKeyedDataSource.LoadParams<K> params, final @NonNull PageKeyedDataSource.LoadCallback<K, B> callback) {
        this.mSource.loadBefore(params, new PageKeyedDataSource.LoadCallback<K, A>(){

            @Override
            public void onResult(@NonNull List<A> data, @Nullable K adjacentPageKey) {
                callback.onResult(DataSource.convert(WrapperPageKeyedDataSource.this.mListFunction, data), adjacentPageKey);
            }
        });
    }

    @Override
    public void loadAfter(@NonNull PageKeyedDataSource.LoadParams<K> params, final @NonNull PageKeyedDataSource.LoadCallback<K, B> callback) {
        this.mSource.loadAfter(params, new PageKeyedDataSource.LoadCallback<K, A>(){

            @Override
            public void onResult(@NonNull List<A> data, @Nullable K adjacentPageKey) {
                callback.onResult(DataSource.convert(WrapperPageKeyedDataSource.this.mListFunction, data), adjacentPageKey);
            }
        });
    }
}

