/*
 * Decompiled with CFR 0.152.
 */
package android.arch.paging;

import android.arch.core.executor.ArchTaskExecutor;
import android.arch.paging.PagedList;
import android.arch.paging.PagedStorageDiffHelper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.recyclerview.extensions.AsyncDifferConfig;
import android.support.v7.util.AdapterListUpdateCallback;
import android.support.v7.util.DiffUtil;
import android.support.v7.util.ListUpdateCallback;
import android.support.v7.widget.RecyclerView;
import java.util.concurrent.Executor;

public class AsyncPagedListDiffer<T> {
    private final ListUpdateCallback mUpdateCallback;
    private final AsyncDifferConfig<T> mConfig;
    Executor mMainThreadExecutor = ArchTaskExecutor.getMainThreadExecutor();
    @Nullable
    PagedListListener<T> mListener;
    private boolean mIsContiguous;
    private PagedList<T> mPagedList;
    private PagedList<T> mSnapshot;
    private int mMaxScheduledGeneration;
    private PagedList.Callback mPagedListCallback = new PagedList.Callback(){

        public void onInserted(int position, int count) {
            AsyncPagedListDiffer.this.mUpdateCallback.onInserted(position, count);
        }

        public void onRemoved(int position, int count) {
            AsyncPagedListDiffer.this.mUpdateCallback.onRemoved(position, count);
        }

        public void onChanged(int position, int count) {
            AsyncPagedListDiffer.this.mUpdateCallback.onChanged(position, count, null);
        }
    };

    public AsyncPagedListDiffer(@NonNull RecyclerView.Adapter adapter, @NonNull DiffUtil.ItemCallback<T> diffCallback) {
        this.mUpdateCallback = new AdapterListUpdateCallback(adapter);
        this.mConfig = new AsyncDifferConfig.Builder(diffCallback).build();
    }

    public AsyncPagedListDiffer(@NonNull ListUpdateCallback listUpdateCallback, @NonNull AsyncDifferConfig<T> config) {
        this.mUpdateCallback = listUpdateCallback;
        this.mConfig = config;
    }

    @Nullable
    public T getItem(int index) {
        if (this.mPagedList == null) {
            if (this.mSnapshot == null) {
                throw new IndexOutOfBoundsException("Item count is zero, getItem() call is invalid");
            }
            return (T)this.mSnapshot.get(index);
        }
        this.mPagedList.loadAround(index);
        return (T)this.mPagedList.get(index);
    }

    public int getItemCount() {
        if (this.mPagedList != null) {
            return this.mPagedList.size();
        }
        return this.mSnapshot == null ? 0 : this.mSnapshot.size();
    }

    public void submitList(final PagedList<T> pagedList) {
        if (pagedList != null) {
            if (this.mPagedList == null && this.mSnapshot == null) {
                this.mIsContiguous = pagedList.isContiguous();
            } else if (pagedList.isContiguous() != this.mIsContiguous) {
                throw new IllegalArgumentException("AsyncPagedListDiffer cannot handle both contiguous and non-contiguous lists.");
            }
        }
        if (pagedList == this.mPagedList) {
            return;
        }
        final int runGeneration = ++this.mMaxScheduledGeneration;
        if (pagedList == null) {
            int removedCount = this.getItemCount();
            if (this.mPagedList != null) {
                this.mPagedList.removeWeakCallback(this.mPagedListCallback);
                this.mPagedList = null;
            } else if (this.mSnapshot != null) {
                this.mSnapshot = null;
            }
            this.mUpdateCallback.onRemoved(0, removedCount);
            if (this.mListener != null) {
                this.mListener.onCurrentListChanged(null);
            }
            return;
        }
        if (this.mPagedList == null && this.mSnapshot == null) {
            this.mPagedList = pagedList;
            pagedList.addWeakCallback(null, this.mPagedListCallback);
            this.mUpdateCallback.onInserted(0, pagedList.size());
            if (this.mListener != null) {
                this.mListener.onCurrentListChanged(pagedList);
            }
            return;
        }
        if (this.mPagedList != null) {
            this.mPagedList.removeWeakCallback(this.mPagedListCallback);
            this.mSnapshot = (PagedList)this.mPagedList.snapshot();
            this.mPagedList = null;
        }
        if (this.mSnapshot == null || this.mPagedList != null) {
            throw new IllegalStateException("must be in snapshot state to diff");
        }
        final PagedList<T> oldSnapshot = this.mSnapshot;
        final PagedList newSnapshot = (PagedList)pagedList.snapshot();
        this.mConfig.getBackgroundThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                final DiffUtil.DiffResult result = PagedStorageDiffHelper.computeDiff(oldSnapshot.mStorage, newSnapshot.mStorage, AsyncPagedListDiffer.this.mConfig.getDiffCallback());
                AsyncPagedListDiffer.this.mMainThreadExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (AsyncPagedListDiffer.this.mMaxScheduledGeneration == runGeneration) {
                            AsyncPagedListDiffer.this.latchPagedList(pagedList, newSnapshot, result);
                        }
                    }
                });
            }
        });
    }

    private void latchPagedList(PagedList<T> newList, PagedList<T> diffSnapshot, DiffUtil.DiffResult diffResult) {
        if (this.mSnapshot == null || this.mPagedList != null) {
            throw new IllegalStateException("must be in snapshot state to apply diff");
        }
        PagedList<T> previousSnapshot = this.mSnapshot;
        this.mPagedList = newList;
        this.mSnapshot = null;
        PagedStorageDiffHelper.dispatchDiff(this.mUpdateCallback, previousSnapshot.mStorage, newList.mStorage, diffResult);
        newList.addWeakCallback(diffSnapshot, this.mPagedListCallback);
        if (this.mListener != null) {
            this.mListener.onCurrentListChanged(this.mPagedList);
        }
    }

    @Nullable
    public PagedList<T> getCurrentList() {
        if (this.mSnapshot != null) {
            return this.mSnapshot;
        }
        return this.mPagedList;
    }

    static interface PagedListListener<T> {
        public void onCurrentListChanged(@Nullable PagedList<T> var1);
    }
}

