/*
 * Decompiled with CFR 0.152.
 */
package android.arch.persistence.db;

import android.arch.persistence.db.SupportSQLiteDatabase;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.Log;
import android.util.Pair;
import java.io.File;
import java.io.IOException;
import java.util.List;

public interface SupportSQLiteOpenHelper {
    public String getDatabaseName();

    @RequiresApi(api=16)
    public void setWriteAheadLoggingEnabled(boolean var1);

    public SupportSQLiteDatabase getWritableDatabase();

    public SupportSQLiteDatabase getReadableDatabase();

    public void close();

    public static interface Factory {
        public SupportSQLiteOpenHelper create(Configuration var1);
    }

    public static class Configuration {
        @NonNull
        public final Context context;
        @Nullable
        public final String name;
        @NonNull
        public final Callback callback;

        Configuration(@NonNull Context context, @Nullable String name, @NonNull Callback callback) {
            this.context = context;
            this.name = name;
            this.callback = callback;
        }

        public static Builder builder(Context context) {
            return new Builder(context);
        }

        public static class Builder {
            Context mContext;
            String mName;
            Callback mCallback;

            public Configuration build() {
                if (this.mCallback == null) {
                    throw new IllegalArgumentException("Must set a callback to create the configuration.");
                }
                if (this.mContext == null) {
                    throw new IllegalArgumentException("Must set a non-null context to create the configuration.");
                }
                return new Configuration(this.mContext, this.mName, this.mCallback);
            }

            Builder(@NonNull Context context) {
                this.mContext = context;
            }

            public Builder name(@Nullable String name) {
                this.mName = name;
                return this;
            }

            public Builder callback(@NonNull Callback callback) {
                this.mCallback = callback;
                return this;
            }
        }
    }

    public static abstract class Callback {
        private static final String TAG = "SupportSQLite";
        public final int version;

        public Callback(int version) {
            this.version = version;
        }

        public void onConfigure(SupportSQLiteDatabase db) {
        }

        public abstract void onCreate(SupportSQLiteDatabase var1);

        public abstract void onUpgrade(SupportSQLiteDatabase var1, int var2, int var3);

        public void onDowngrade(SupportSQLiteDatabase db, int oldVersion, int newVersion) {
            throw new SQLiteException("Can't downgrade database from version " + oldVersion + " to " + newVersion);
        }

        public void onOpen(SupportSQLiteDatabase db) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCorruption(SupportSQLiteDatabase db) {
            block12: {
                block11: {
                    Log.e((String)TAG, (String)("Corruption reported by sqlite on database: " + db.getPath()));
                    if (!db.isOpen()) {
                        this.deleteDatabaseFile(db.getPath());
                        return;
                    }
                    List<Pair<String, String>> attachedDbs = null;
                    try {
                        try {
                            attachedDbs = db.getAttachedDbs();
                        }
                        catch (SQLiteException sQLiteException) {
                            // empty catch block
                        }
                        try {
                            db.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (attachedDbs == null) break block11;
                    }
                    catch (Throwable throwable) {
                        if (attachedDbs != null) {
                            for (Pair<String, String> p : attachedDbs) {
                                this.deleteDatabaseFile((String)p.second);
                            }
                        } else {
                            this.deleteDatabaseFile(db.getPath());
                        }
                        throw throwable;
                    }
                    for (Pair<String, String> p : attachedDbs) {
                        this.deleteDatabaseFile((String)p.second);
                    }
                    break block12;
                }
                this.deleteDatabaseFile(db.getPath());
            }
        }

        private void deleteDatabaseFile(String fileName) {
            block7: {
                if (fileName.equalsIgnoreCase(":memory:") || fileName.trim().length() == 0) {
                    return;
                }
                Log.w((String)TAG, (String)("deleting the database file: " + fileName));
                try {
                    if (Build.VERSION.SDK_INT >= 16) {
                        SQLiteDatabase.deleteDatabase((File)new File(fileName));
                        break block7;
                    }
                    try {
                        boolean deleted = new File(fileName).delete();
                        if (!deleted) {
                            Log.e((String)TAG, (String)("Could not delete the database file " + fileName));
                        }
                    }
                    catch (Exception error) {
                        Log.e((String)TAG, (String)"error while deleting corrupted database file", (Throwable)error);
                    }
                }
                catch (Exception e) {
                    Log.w((String)TAG, (String)"delete failed: ", (Throwable)e);
                }
            }
        }
    }
}

