/*
 * Decompiled with CFR 0.152.
 */
package android.arch.persistence.room.log;

import android.arch.persistence.room.vo.Warning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UnknownFormatConversionException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\r\u0018\u00002\u00020\u0001:\u0003 !\"B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ/\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0016\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0017J'\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0016\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0018J/\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0016\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0017J'\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0016\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0018J;\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00062\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0016\"\u00020\u0001\u00a2\u0006\u0002\u0010\u001cJ/\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0016\"\u00020\u0001\u00a2\u0006\u0002\u0010\u001dJ%\u0010\u001e\u001a\u00020\u0014*\u00020\u00142\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0016\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u001fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006#"}, d2={"Landroid/arch/persistence/room/log/RLog;", "", "messager", "Landroid/arch/persistence/room/log/RLog$Messager;", "suppressedWarnings", "", "Landroid/arch/persistence/room/vo/Warning;", "defaultElement", "Ljavax/lang/model/element/Element;", "(Landroid/arch/persistence/room/log/RLog$Messager;Ljava/util/Set;Ljavax/lang/model/element/Element;)V", "getDefaultElement", "()Ljavax/lang/model/element/Element;", "getMessager", "()Landroid/arch/persistence/room/log/RLog$Messager;", "getSuppressedWarnings", "()Ljava/util/Set;", "d", "", "element", "msg", "", "args", "", "(Ljavax/lang/model/element/Element;Ljava/lang/String;[Ljava/lang/Object;)V", "(Ljava/lang/String;[Ljava/lang/Object;)V", "e", "w", "warning", "(Landroid/arch/persistence/room/vo/Warning;Ljavax/lang/model/element/Element;Ljava/lang/String;[Ljava/lang/Object;)V", "(Landroid/arch/persistence/room/vo/Warning;Ljava/lang/String;[Ljava/lang/Object;)V", "safeFormat", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "CollectingMessager", "Messager", "ProcessingEnvMessager", "compiler_main"})
public final class RLog {
    @NotNull
    private final Messager messager;
    @NotNull
    private final Set<Warning> suppressedWarnings;
    @Nullable
    private final Element defaultElement;

    private final String safeFormat(@NotNull String $receiver, Object ... args2) {
        try {
            String string = $receiver;
            Object[] objectArray = new Object[]{args2};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
            return string2;
        }
        catch (UnknownFormatConversionException ex) {
            return $receiver;
        }
    }

    public final void d(@NotNull Element element, @NotNull String msg, Object ... args2) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        Intrinsics.checkParameterIsNotNull((Object)args2, (String)"args");
        this.messager.printMessage(Diagnostic.Kind.NOTE, this.safeFormat(msg, new Object[]{args2}), element);
    }

    public final void d(@NotNull String msg, Object ... args2) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        Intrinsics.checkParameterIsNotNull((Object)args2, (String)"args");
        Messager.DefaultImpls.printMessage$default(this.messager, Diagnostic.Kind.NOTE, this.safeFormat(msg, new Object[]{args2}), null, 4, null);
    }

    public final void e(@NotNull Element element, @NotNull String msg, Object ... args2) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        Intrinsics.checkParameterIsNotNull((Object)args2, (String)"args");
        this.messager.printMessage(Diagnostic.Kind.ERROR, this.safeFormat(msg, new Object[]{args2}), element);
    }

    public final void e(@NotNull String msg, Object ... args2) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        Intrinsics.checkParameterIsNotNull((Object)args2, (String)"args");
        this.messager.printMessage(Diagnostic.Kind.ERROR, this.safeFormat(msg, new Object[]{args2}), this.defaultElement);
    }

    public final void w(@NotNull Warning warning, @Nullable Element element, @NotNull String msg, Object ... args2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)warning), (String)"warning");
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        Intrinsics.checkParameterIsNotNull((Object)args2, (String)"args");
        if (this.suppressedWarnings.contains((Object)warning)) {
            return;
        }
        String string = this.safeFormat(msg, new Object[]{args2});
        Element element2 = element;
        if (element2 == null) {
            element2 = this.defaultElement;
        }
        this.messager.printMessage(Diagnostic.Kind.WARNING, string, element2);
    }

    public static /* bridge */ /* synthetic */ void w$default(RLog rLog, Warning warning, Element element, String string, Object[] objectArray, int n, Object object) {
        if ((n & 2) != 0) {
            element = null;
        }
        rLog.w(warning, element, string, objectArray);
    }

    public final void w(@NotNull Warning warning, @NotNull String msg, Object ... args2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)warning), (String)"warning");
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        Intrinsics.checkParameterIsNotNull((Object)args2, (String)"args");
        if (this.suppressedWarnings.contains((Object)warning)) {
            return;
        }
        this.messager.printMessage(Diagnostic.Kind.WARNING, this.safeFormat(msg, new Object[]{args2}), this.defaultElement);
    }

    @NotNull
    public final Messager getMessager() {
        return this.messager;
    }

    @NotNull
    public final Set<Warning> getSuppressedWarnings() {
        return this.suppressedWarnings;
    }

    @Nullable
    public final Element getDefaultElement() {
        return this.defaultElement;
    }

    public RLog(@NotNull Messager messager, @NotNull Set<? extends Warning> suppressedWarnings, @Nullable Element defaultElement) {
        Intrinsics.checkParameterIsNotNull((Object)messager, (String)"messager");
        Intrinsics.checkParameterIsNotNull(suppressedWarnings, (String)"suppressedWarnings");
        this.messager = messager;
        this.suppressedWarnings = suppressedWarnings;
        this.defaultElement = defaultElement;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a8\u0006\n"}, d2={"Landroid/arch/persistence/room/log/RLog$Messager;", "", "printMessage", "", "kind", "Ljavax/tools/Diagnostic$Kind;", "msg", "", "element", "Ljavax/lang/model/element/Element;", "compiler_main"})
    public static interface Messager {
        public void printMessage(@NotNull Diagnostic.Kind var1, @NotNull String var2, @Nullable Element var3);

        @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=3)
        public static final class DefaultImpls {
            public static /* bridge */ /* synthetic */ void printMessage$default(Messager messager, Diagnostic.Kind kind, String string, Element element, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: printMessage");
                }
                if ((n & 4) != 0) {
                    element = null;
                }
                messager.printMessage(kind, string, element);
            }
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Landroid/arch/persistence/room/log/RLog$ProcessingEnvMessager;", "Landroid/arch/persistence/room/log/RLog$Messager;", "processingEnv", "Ljavax/annotation/processing/ProcessingEnvironment;", "(Ljavax/annotation/processing/ProcessingEnvironment;)V", "getProcessingEnv", "()Ljavax/annotation/processing/ProcessingEnvironment;", "printMessage", "", "kind", "Ljavax/tools/Diagnostic$Kind;", "msg", "", "element", "Ljavax/lang/model/element/Element;", "compiler_main"})
    public static final class ProcessingEnvMessager
    implements Messager {
        @NotNull
        private final ProcessingEnvironment processingEnv;

        @Override
        public void printMessage(@NotNull Diagnostic.Kind kind, @NotNull String msg, @Nullable Element element) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)kind), (String)"kind");
            Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
            this.processingEnv.getMessager().printMessage(kind, msg, element);
        }

        @NotNull
        public final ProcessingEnvironment getProcessingEnv() {
            return this.processingEnv;
        }

        public ProcessingEnvMessager(@NotNull ProcessingEnvironment processingEnv) {
            Intrinsics.checkParameterIsNotNull((Object)processingEnv, (String)"processingEnv");
            this.processingEnv = processingEnv;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0016J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013R.\u0010\u0003\u001a\"\u0012\u0004\u0012\u00020\u0005\u0012\u0018\u0012\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Landroid/arch/persistence/room/log/RLog$CollectingMessager;", "Landroid/arch/persistence/room/log/RLog$Messager;", "()V", "messages", "", "Ljavax/tools/Diagnostic$Kind;", "", "Lkotlin/Pair;", "", "Ljavax/lang/model/element/Element;", "hasErrors", "", "printMessage", "", "kind", "msg", "element", "writeTo", "env", "Ljavax/annotation/processing/ProcessingEnvironment;", "compiler_main"})
    public static final class CollectingMessager
    implements Messager {
        private final Map<Diagnostic.Kind, List<Pair<String, Element>>> messages;

        @Override
        public void printMessage(@NotNull Diagnostic.Kind kind, @NotNull String msg, @Nullable Element element) {
            List<Pair<String, Element>> list;
            Intrinsics.checkParameterIsNotNull((Object)((Object)kind), (String)"kind");
            Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
            Map<Diagnostic.Kind, List<Pair<String, Element>>> $receiver$iv = this.messages;
            List<Pair<String, Element>> value$iv = $receiver$iv.get((Object)kind);
            if (value$iv == null) {
                ArrayList<Pair<String, Element>> answer$iv = new ArrayList<Pair<String, Element>>();
                $receiver$iv.put(kind, answer$iv);
                list = answer$iv;
            } else {
                list = value$iv;
            }
            list.add((Pair<String, Element>)new Pair((Object)msg, (Object)element));
        }

        public final boolean hasErrors() {
            return this.messages.containsKey((Object)Diagnostic.Kind.ERROR);
        }

        public final void writeTo(@NotNull ProcessingEnvironment env) {
            Map<Diagnostic.Kind, List<Pair<String, Element>>> $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
            Map<Diagnostic.Kind, List<Pair<String, Element>>> map2 = $receiver$iv = this.messages;
            Iterator<Map.Entry<Diagnostic.Kind, List<Pair<String, Element>>>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Diagnostic.Kind, List<Pair<String, Element>>> element$iv;
                Map.Entry<Diagnostic.Kind, List<Pair<String, Element>>> pair = element$iv = iterator.next();
                Diagnostic.Kind kind = pair.getKey();
                Iterable $receiver$iv2 = pair.getValue();
                for (Object element$iv2 : $receiver$iv2) {
                    Pair it = (Pair)element$iv2;
                    env.getMessager().printMessage(kind, (CharSequence)it.getFirst(), (Element)it.getSecond());
                }
            }
        }

        public CollectingMessager() {
            Map map2;
            CollectingMessager collectingMessager = this;
            collectingMessager.messages = map2 = (Map)new LinkedHashMap();
        }
    }
}

