/*
 * Decompiled with CFR 0.152.
 */
package android.arch.persistence.room.processor;

import android.arch.persistence.room.log.RLog;
import android.arch.persistence.room.preconditions.Checks;
import android.arch.persistence.room.processor.Context;
import android.arch.persistence.room.processor.CustomConverterProcessor;
import android.arch.persistence.room.processor.SuppressWarningProcessor;
import android.arch.persistence.room.processor.cache.Cache;
import android.arch.persistence.room.solver.TypeAdapterStore;
import android.arch.persistence.room.verifier.DatabaseVerifier;
import android.arch.persistence.room.vo.Warning;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 62\u00020\u0001:\u0003567B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B1\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ,\u0010,\u001a\u000e\u0012\u0004\u0012\u0002H.\u0012\u0004\u0012\u00020/0-\"\u0004\b\u0000\u0010.2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H.01J\u000e\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u000204R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001d\u0010\"\u001a\u0004\u0018\u00010#8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b$\u0010%R\u001b\u0010(\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010'\u001a\u0004\b)\u0010*R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Landroid/arch/persistence/room/processor/Context;", "", "processingEnv", "Ljavax/annotation/processing/ProcessingEnvironment;", "(Ljavax/annotation/processing/ProcessingEnvironment;)V", "logger", "Landroid/arch/persistence/room/log/RLog;", "typeConverters", "Landroid/arch/persistence/room/processor/CustomConverterProcessor$ProcessResult;", "inheritedAdapterStore", "Landroid/arch/persistence/room/solver/TypeAdapterStore;", "cache", "Landroid/arch/persistence/room/processor/cache/Cache;", "(Ljavax/annotation/processing/ProcessingEnvironment;Landroid/arch/persistence/room/log/RLog;Landroid/arch/persistence/room/processor/CustomConverterProcessor$ProcessResult;Landroid/arch/persistence/room/solver/TypeAdapterStore;Landroid/arch/persistence/room/processor/cache/Cache;)V", "COMMON_TYPES", "Landroid/arch/persistence/room/processor/Context$CommonTypes;", "getCOMMON_TYPES", "()Landroid/arch/persistence/room/processor/Context$CommonTypes;", "getCache", "()Landroid/arch/persistence/room/processor/cache/Cache;", "checker", "Landroid/arch/persistence/room/preconditions/Checks;", "getChecker", "()Landroid/arch/persistence/room/preconditions/Checks;", "databaseVerifier", "Landroid/arch/persistence/room/verifier/DatabaseVerifier;", "getDatabaseVerifier", "()Landroid/arch/persistence/room/verifier/DatabaseVerifier;", "setDatabaseVerifier", "(Landroid/arch/persistence/room/verifier/DatabaseVerifier;)V", "getLogger", "()Landroid/arch/persistence/room/log/RLog;", "getProcessingEnv", "()Ljavax/annotation/processing/ProcessingEnvironment;", "schemaOutFolder", "Ljava/io/File;", "getSchemaOutFolder", "()Ljava/io/File;", "schemaOutFolder$delegate", "Lkotlin/Lazy;", "typeAdapterStore", "getTypeAdapterStore", "()Landroid/arch/persistence/room/solver/TypeAdapterStore;", "typeAdapterStore$delegate", "collectLogs", "Lkotlin/Pair;", "T", "Landroid/arch/persistence/room/log/RLog$CollectingMessager;", "handler", "Lkotlin/Function1;", "fork", "element", "Ljavax/lang/model/element/Element;", "CommonTypes", "Companion", "ProcessorOptions", "compiler_main"})
public final class Context {
    @NotNull
    private final Checks checker;
    @NotNull
    private final CommonTypes COMMON_TYPES;
    @NotNull
    private final Lazy typeAdapterStore$delegate;
    @Nullable
    private DatabaseVerifier databaseVerifier;
    @Nullable
    private final Lazy schemaOutFolder$delegate;
    @NotNull
    private final ProcessingEnvironment processingEnv;
    @NotNull
    private final RLog logger;
    private final CustomConverterProcessor.ProcessResult typeConverters;
    private final TypeAdapterStore inheritedAdapterStore;
    @NotNull
    private final Cache cache;
    @NotNull
    private static final Lazy ARG_OPTIONS$delegate;
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    public static final Companion Companion;

    @NotNull
    public final Checks getChecker() {
        return this.checker;
    }

    @NotNull
    public final CommonTypes getCOMMON_TYPES() {
        return this.COMMON_TYPES;
    }

    @NotNull
    public final TypeAdapterStore getTypeAdapterStore() {
        Lazy lazy = this.typeAdapterStore$delegate;
        Context context = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (TypeAdapterStore)lazy.getValue();
    }

    @Nullable
    public final DatabaseVerifier getDatabaseVerifier() {
        return this.databaseVerifier;
    }

    public final void setDatabaseVerifier(@Nullable DatabaseVerifier databaseVerifier) {
        this.databaseVerifier = databaseVerifier;
    }

    @Nullable
    public final File getSchemaOutFolder() {
        Lazy lazy = this.schemaOutFolder$delegate;
        Context context = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (File)lazy.getValue();
    }

    @NotNull
    public final <T> Pair<T, RLog.CollectingMessager> collectLogs(@NotNull Function1<? super Context, ? extends T> handler) {
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        RLog.CollectingMessager collector = new RLog.CollectingMessager();
        Context subContext = new Context(this.processingEnv, new RLog(collector, this.logger.getSuppressedWarnings(), this.logger.getDefaultElement()), this.typeConverters, this.getTypeAdapterStore(), this.cache);
        subContext.databaseVerifier = this.databaseVerifier;
        Object result = handler.invoke((Object)subContext);
        return new Pair(result, (Object)collector);
    }

    @NotNull
    public final Context fork(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Set<Warning> suppressedWarnings = SuppressWarningProcessor.INSTANCE.getSuppressedWarnings(element);
        CustomConverterProcessor.ProcessResult processConvertersResult = CustomConverterProcessor.Companion.findConverters(this, element);
        boolean canReUseAdapterStore = processConvertersResult.getClasses().isEmpty();
        CustomConverterProcessor.ProcessResult subTypeConverters = canReUseAdapterStore ? this.typeConverters : processConvertersResult.plus(this.typeConverters);
        Set subSuppressedWarnings = SetsKt.plus(suppressedWarnings, (Iterable)this.logger.getSuppressedWarnings());
        Cache subCache = new Cache(this.cache, subTypeConverters.getClasses(), subSuppressedWarnings);
        Context subContext = new Context(this.processingEnv, new RLog(this.logger.getMessager(), subSuppressedWarnings, element), subTypeConverters, canReUseAdapterStore ? this.getTypeAdapterStore() : null, subCache);
        subContext.databaseVerifier = this.databaseVerifier;
        return subContext;
    }

    @NotNull
    public final ProcessingEnvironment getProcessingEnv() {
        return this.processingEnv;
    }

    @NotNull
    public final RLog getLogger() {
        return this.logger;
    }

    @NotNull
    public final Cache getCache() {
        return this.cache;
    }

    private Context(ProcessingEnvironment processingEnv, RLog logger, CustomConverterProcessor.ProcessResult typeConverters, TypeAdapterStore inheritedAdapterStore, Cache cache) {
        this.processingEnv = processingEnv;
        this.logger = logger;
        this.typeConverters = typeConverters;
        this.inheritedAdapterStore = inheritedAdapterStore;
        this.cache = cache;
        this.checker = new Checks(this.logger);
        this.COMMON_TYPES = new CommonTypes(this.processingEnv);
        this.typeAdapterStore$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TypeAdapterStore>(this){
            final /* synthetic */ Context this$0;

            @NotNull
            public final TypeAdapterStore invoke() {
                return Context.access$getInheritedAdapterStore$p(this.this$0) != null ? TypeAdapterStore.Companion.copy(this.this$0, Context.access$getInheritedAdapterStore$p(this.this$0)) : TypeAdapterStore.Companion.create(this.this$0, Context.access$getTypeConverters$p(this.this$0).getConverters());
            }
            {
                this.this$0 = context;
                super(0);
            }
        }));
        this.schemaOutFolder$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ Context this$0;

            @Nullable
            public final File invoke() {
                CharSequence charSequence;
                String arg;
                String string = arg = this.this$0.getProcessingEnv().getOptions().get(ProcessorOptions.OPTION_SCHEMA_FOLDER.getArgName());
                return (string != null ? (charSequence = (CharSequence)string).length() > 0 : false) ? new File(arg) : null;
            }
            {
                this.this$0 = context;
                super(0);
            }
        }));
    }

    public Context(@NotNull ProcessingEnvironment processingEnv) {
        Intrinsics.checkParameterIsNotNull((Object)processingEnv, (String)"processingEnv");
        this(processingEnv, new RLog(new RLog.ProcessingEnvMessager(processingEnv), SetsKt.emptySet(), null), CustomConverterProcessor.ProcessResult.EMPTY.INSTANCE, null, new Cache(null, new LinkedHashSet<TypeMirror>(), SetsKt.emptySet()));
    }

    static {
        Companion = new Companion(null);
        ARG_OPTIONS$delegate = LazyKt.lazy((Function0)Companion.ARG_OPTIONS.2.INSTANCE);
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Context.class), "typeAdapterStore", "getTypeAdapterStore()Landroid/arch/persistence/room/solver/TypeAdapterStore;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Context.class), "schemaOutFolder", "getSchemaOutFolder()Ljava/io/File;"))};
    }

    @Nullable
    public static final /* synthetic */ TypeAdapterStore access$getInheritedAdapterStore$p(Context $this) {
        return $this.inheritedAdapterStore;
    }

    @NotNull
    public static final /* synthetic */ CustomConverterProcessor.ProcessResult access$getTypeConverters$p(Context $this) {
        return $this.typeConverters;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Landroid/arch/persistence/room/processor/Context$CommonTypes;", "", "processingEnv", "Ljavax/annotation/processing/ProcessingEnvironment;", "(Ljavax/annotation/processing/ProcessingEnvironment;)V", "STRING", "Ljavax/lang/model/type/TypeMirror;", "getSTRING", "()Ljavax/lang/model/type/TypeMirror;", "STRING$delegate", "Lkotlin/Lazy;", "getProcessingEnv", "()Ljavax/annotation/processing/ProcessingEnvironment;", "compiler_main"})
    public static final class CommonTypes {
        @NotNull
        private final Lazy STRING$delegate;
        @NotNull
        private final ProcessingEnvironment processingEnv;
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        @NotNull
        public final TypeMirror getSTRING() {
            Lazy lazy = this.STRING$delegate;
            CommonTypes commonTypes = this;
            KProperty kProperty = $$delegatedProperties[0];
            return (TypeMirror)lazy.getValue();
        }

        @NotNull
        public final ProcessingEnvironment getProcessingEnv() {
            return this.processingEnv;
        }

        public CommonTypes(@NotNull ProcessingEnvironment processingEnv) {
            Intrinsics.checkParameterIsNotNull((Object)processingEnv, (String)"processingEnv");
            this.processingEnv = processingEnv;
            this.STRING$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TypeMirror>(this){
                final /* synthetic */ CommonTypes this$0;

                public final TypeMirror invoke() {
                    return this.this$0.getProcessingEnv().getElementUtils().getTypeElement("java.lang.String").asType();
                }
                {
                    this.this$0 = commonTypes;
                    super(0);
                }
            }));
        }

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(CommonTypes.class), "STRING", "getSTRING()Ljavax/lang/model/type/TypeMirror;"))};
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Landroid/arch/persistence/room/processor/Context$ProcessorOptions;", "", "argName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getArgName", "()Ljava/lang/String;", "OPTION_SCHEMA_FOLDER", "compiler_main"})
    public static final class ProcessorOptions
    extends Enum<ProcessorOptions> {
        public static final /* enum */ ProcessorOptions OPTION_SCHEMA_FOLDER;
        private static final /* synthetic */ ProcessorOptions[] $VALUES;
        @NotNull
        private final String argName;

        static {
            ProcessorOptions[] processorOptionsArray = new ProcessorOptions[1];
            ProcessorOptions[] processorOptionsArray2 = processorOptionsArray;
            processorOptionsArray[0] = OPTION_SCHEMA_FOLDER = new ProcessorOptions("room.schemaLocation");
            $VALUES = processorOptionsArray;
        }

        @NotNull
        public final String getArgName() {
            return this.argName;
        }

        protected ProcessorOptions(String argName) {
            Intrinsics.checkParameterIsNotNull((Object)argName, (String)"argName");
            this.argName = argName;
        }

        public static ProcessorOptions[] values() {
            return (ProcessorOptions[])$VALUES.clone();
        }

        public static ProcessorOptions valueOf(String string) {
            return Enum.valueOf(ProcessorOptions.class, string);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Landroid/arch/persistence/room/processor/Context$Companion;", "", "()V", "ARG_OPTIONS", "", "", "getARG_OPTIONS", "()Ljava/util/List;", "ARG_OPTIONS$delegate", "Lkotlin/Lazy;", "compiler_main"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        @NotNull
        public final List<String> getARG_OPTIONS() {
            Lazy lazy = ARG_OPTIONS$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[0];
            return (List)lazy.getValue();
        }

        private Companion() {
        }

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "ARG_OPTIONS", "getARG_OPTIONS()Ljava/util/List;"))};
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

