/*
 * Decompiled with CFR 0.152.
 */
package android.arch.persistence.room.processor;

import android.arch.persistence.room.Entity;
import android.arch.persistence.room.RawQuery;
import android.arch.persistence.room.Transaction;
import android.arch.persistence.room.ext.Element_extKt;
import android.arch.persistence.room.ext.Javapoet_extKt;
import android.arch.persistence.room.ext.SupportDbTypeNames;
import android.arch.persistence.room.log.RLog;
import android.arch.persistence.room.parser.ParsedQuery;
import android.arch.persistence.room.parser.SqlParser;
import android.arch.persistence.room.preconditions.Checks;
import android.arch.persistence.room.processor.Context;
import android.arch.persistence.room.processor.EntityProcessor;
import android.arch.persistence.room.processor.FieldProcessor;
import android.arch.persistence.room.processor.PojoProcessor;
import android.arch.persistence.room.processor.ProcessorErrors;
import android.arch.persistence.room.solver.TypeAdapterStore;
import android.arch.persistence.room.solver.query.result.QueryResultBinder;
import android.arch.persistence.room.vo.Pojo;
import android.arch.persistence.room.vo.RawQueryMethod;
import com.google.auto.common.AnnotationMirrors;
import com.google.auto.common.MoreElements;
import com.google.auto.common.MoreTypes;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Landroid/arch/persistence/room/processor/RawQueryMethodProcessor;", "", "baseContext", "Landroid/arch/persistence/room/processor/Context;", "containing", "Ljavax/lang/model/type/DeclaredType;", "executableElement", "Ljavax/lang/model/element/ExecutableElement;", "(Landroid/arch/persistence/room/processor/Context;Ljavax/lang/model/type/DeclaredType;Ljavax/lang/model/element/ExecutableElement;)V", "getContaining", "()Ljavax/lang/model/type/DeclaredType;", "context", "getContext", "()Landroid/arch/persistence/room/processor/Context;", "getExecutableElement", "()Ljavax/lang/model/element/ExecutableElement;", "findRuntimeQueryParameter", "Landroid/arch/persistence/room/vo/RawQueryMethod$RuntimeQueryParameter;", "process", "Landroid/arch/persistence/room/vo/RawQueryMethod;", "processObservedTables", "", "", "compiler"})
public final class RawQueryMethodProcessor {
    @NotNull
    private final Context context;
    @NotNull
    private final DeclaredType containing;
    @NotNull
    private final ExecutableElement executableElement;

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final RawQueryMethod process() {
        Types types = this.context.getProcessingEnv().getTypeUtils();
        TypeMirror asMember = types.asMemberOf(this.containing, this.executableElement);
        ExecutableType executableType = MoreTypes.asExecutable((TypeMirror)asMember);
        AnnotationMirror annotation = (AnnotationMirror)MoreElements.getAnnotationMirror((Element)this.executableElement, RawQuery.class).orNull();
        this.context.getChecker().check(annotation != null, this.executableElement, ProcessorErrors.INSTANCE.getMISSING_RAWQUERY_ANNOTATION(), new Object[0]);
        ExecutableType executableType2 = executableType;
        Intrinsics.checkExpressionValueIsNotNull((Object)executableType2, (String)"executableType");
        TypeName returnTypeName = TypeName.get((TypeMirror)executableType2.getReturnType());
        Checks checks = this.context.getChecker();
        TypeName typeName2 = returnTypeName;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeName2, (String)"returnTypeName");
        checks.notUnbound(typeName2, this.executableElement, ProcessorErrors.INSTANCE.getCANNOT_USE_UNBOUND_GENERICS_IN_QUERY_METHODS(), new Object[0]);
        Set<String> observedTableNames = this.processObservedTables();
        ParsedQuery query2 = SqlParser.Companion.rawQueryForTables(observedTableNames);
        TypeAdapterStore typeAdapterStore2 = this.context.getTypeAdapterStore();
        TypeMirror typeMirror = executableType.getReturnType();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror, (String)"executableType.returnType");
        QueryResultBinder resultBinder = typeAdapterStore2.findQueryResultBinder(typeMirror, query2);
        RawQueryMethod.RuntimeQueryParameter runtimeQueryParam = this.findRuntimeQueryParameter();
        boolean inTransaction = Element_extKt.hasAnnotation(this.executableElement, (KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(Transaction.class));
        String string = this.executableElement.getSimpleName().toString();
        TypeMirror typeMirror2 = executableType.getReturnType();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror2, (String)"executableType.returnType");
        QueryResultBinder queryResultBinder = resultBinder;
        boolean bl = inTransaction;
        RawQueryMethod.RuntimeQueryParameter runtimeQueryParameter = runtimeQueryParam;
        TypeMirror typeMirror3 = typeMirror2;
        Set<String> set = observedTableNames;
        RawQueryMethod rawQueryMethod = new RawQueryMethod(this.executableElement, string, typeMirror3, bl, set, runtimeQueryParameter, queryResultBinder);
        this.context.getChecker().check(rawQueryMethod.getReturnsValue(), this.executableElement, ProcessorErrors.INSTANCE.getRAW_QUERY_BAD_RETURN_TYPE(), new Object[0]);
        return rawQueryMethod;
    }

    private final Set<String> processObservedTables() {
        TypeElement it;
        Iterable $receiver$iv$iv;
        AnnotationValue entityList;
        AnnotationMirror annotationMirror = (AnnotationMirror)MoreElements.getAnnotationMirror((Element)this.executableElement, RawQuery.class).orNull();
        if (annotationMirror == null) {
            return SetsKt.emptySet();
        }
        AnnotationMirror annotation = annotationMirror;
        AnnotationValue annotationValue = entityList = AnnotationMirrors.getAnnotationValue((AnnotationMirror)annotation, (String)"observedEntities");
        Intrinsics.checkExpressionValueIsNotNull((Object)annotationValue, (String)"entityList");
        Iterable $receiver$iv = Element_extKt.toListOfClassTypes(annotationValue);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            TypeMirror typeMirror = (TypeMirror)item$iv$iv;
            Collection collection = destination$iv$iv;
            TypeElement typeElement = MoreTypes.asTypeElement((TypeMirror)((Object)it));
            collection.add(typeElement);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            List<String> list;
            TypeElement typeElement = it = (TypeElement)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeElement, (String)"it");
            if (Element_extKt.hasAnnotation(typeElement, (KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(Entity.class))) {
                android.arch.persistence.room.vo.Entity entity = new EntityProcessor(this.context, it, null, 4, null).process();
                list = CollectionsKt.arrayListOf((Object[])new String[]{entity.getTableName()});
            } else {
                Pojo pojo = new PojoProcessor(this.context, it, FieldProcessor.BindingScope.READ_FROM_CURSOR, null, null, 16, null).process();
                List<String> tableNames2 = pojo.accessedTableNames();
                if (tableNames2.isEmpty()) {
                    RLog rLog = this.context.getLogger();
                    Element element = this.executableElement;
                    TypeMirror typeMirror = it.asType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror, (String)"it.asType()");
                    TypeName typeName2 = Javapoet_extKt.typeName(typeMirror);
                    Intrinsics.checkExpressionValueIsNotNull((Object)typeName2, (String)"it.asType().typeName()");
                    rLog.e(element, ProcessorErrors.INSTANCE.rawQueryBadEntity(typeName2), new Object[0]);
                }
                list = tableNames2;
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final RawQueryMethod.RuntimeQueryParameter findRuntimeQueryParameter() {
        Types types = this.context.getProcessingEnv().getTypeUtils();
        if (this.executableElement.getParameters().size() == 1 && !this.executableElement.isVarArgs()) {
            Elements elementUtils;
            TypeMirror supportQueryType;
            TypeMirror param = MoreTypes.asMemberOf((Types)types, (DeclaredType)this.containing, (VariableElement)this.executableElement.getParameters().get(0));
            boolean isSupportSql = types.isAssignable(param, supportQueryType = (elementUtils = this.context.getProcessingEnv().getElementUtils()).getTypeElement(SupportDbTypeNames.INSTANCE.getQUERY().toString()).asType());
            if (isSupportSql) {
                VariableElement variableElement = this.executableElement.getParameters().get(0);
                Intrinsics.checkExpressionValueIsNotNull((Object)variableElement, (String)"executableElement.parameters[0]");
                String string = variableElement.getSimpleName().toString();
                TypeMirror typeMirror = supportQueryType;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror, (String)"supportQueryType");
                TypeName typeName2 = Javapoet_extKt.typeName(typeMirror);
                Intrinsics.checkExpressionValueIsNotNull((Object)typeName2, (String)"supportQueryType.typeName()");
                return new RawQueryMethod.RuntimeQueryParameter(string, typeName2);
            }
            TypeMirror stringType = elementUtils.getTypeElement("java.lang.String").asType();
            boolean isString = types.isAssignable(param, stringType);
            if (isString) {
                this.context.getLogger().e(this.executableElement, ProcessorErrors.INSTANCE.getRAW_QUERY_STRING_PARAMETER_REMOVED(), new Object[0]);
                return null;
            }
        }
        this.context.getLogger().e(this.executableElement, ProcessorErrors.INSTANCE.getRAW_QUERY_BAD_PARAMS(), new Object[0]);
        return null;
    }

    @NotNull
    public final DeclaredType getContaining() {
        return this.containing;
    }

    @NotNull
    public final ExecutableElement getExecutableElement() {
        return this.executableElement;
    }

    public RawQueryMethodProcessor(@NotNull Context baseContext, @NotNull DeclaredType containing, @NotNull ExecutableElement executableElement) {
        Intrinsics.checkParameterIsNotNull((Object)baseContext, (String)"baseContext");
        Intrinsics.checkParameterIsNotNull((Object)containing, (String)"containing");
        Intrinsics.checkParameterIsNotNull((Object)executableElement, (String)"executableElement");
        this.containing = containing;
        this.executableElement = executableElement;
        this.context = baseContext.fork(this.executableElement);
    }
}

