/*
 * Decompiled with CFR 0.152.
 */
package android.arch.persistence.room.guava;

import android.arch.core.executor.ArchTaskExecutor;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.support.annotation.RestrictTo;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class GuavaRoom {
    private GuavaRoom() {
    }

    public static <T> ListenableFuture<T> createListenableFuture(Callable<T> callable, final RoomSQLiteQuery query, boolean releaseQuery) {
        ListenableFutureTask listenableFutureTask = ListenableFutureTask.create(callable);
        ArchTaskExecutor.getInstance().executeOnDiskIO((Runnable)listenableFutureTask);
        if (releaseQuery) {
            Futures.addCallback((ListenableFuture)listenableFutureTask, (FutureCallback)new FutureCallback<T>(){

                public void onSuccess(T t) {
                    query.release();
                }

                public void onFailure(Throwable throwable) {
                    query.release();
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
        return listenableFutureTask;
    }
}

