/*
 * Decompiled with CFR 0.152.
 */
package android.arch.persistence.room.migration.bundle;

import android.arch.persistence.room.migration.bundle.EntityBundle;
import android.support.annotation.RestrictTo;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class DatabaseBundle {
    @SerializedName(value="version")
    private int mVersion;
    @SerializedName(value="identityHash")
    private String mIdentityHash;
    @SerializedName(value="entities")
    private List<EntityBundle> mEntities;
    @SerializedName(value="setupQueries")
    private List<String> mSetupQueries;
    private transient Map<String, EntityBundle> mEntitiesByTableName;

    public DatabaseBundle(int version, String identityHash, List<EntityBundle> entities, List<String> setupQueries) {
        this.mVersion = version;
        this.mIdentityHash = identityHash;
        this.mEntities = entities;
        this.mSetupQueries = setupQueries;
    }

    public String getIdentityHash() {
        return this.mIdentityHash;
    }

    public int getVersion() {
        return this.mVersion;
    }

    public List<EntityBundle> getEntities() {
        return this.mEntities;
    }

    public Map<String, EntityBundle> getEntitiesByTableName() {
        if (this.mEntitiesByTableName == null) {
            this.mEntitiesByTableName = new HashMap<String, EntityBundle>();
            for (EntityBundle bundle : this.mEntities) {
                this.mEntitiesByTableName.put(bundle.getTableName(), bundle);
            }
        }
        return this.mEntitiesByTableName;
    }

    public List<String> buildCreateQueries() {
        ArrayList<String> result = new ArrayList<String>();
        for (EntityBundle entityBundle : this.mEntities) {
            result.addAll(entityBundle.buildCreateQueries());
        }
        result.addAll(this.mSetupQueries);
        return result;
    }
}

