/*
 * Decompiled with CFR 0.152.
 */
package android.arch.persistence.room.util;

import android.arch.persistence.db.SupportSQLiteDatabase;
import android.database.Cursor;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class TableInfo {
    public final String name;
    public final Map<String, Column> columns;
    public final Set<ForeignKey> foreignKeys;

    public TableInfo(String name, Map<String, Column> columns, Set<ForeignKey> foreignKeys) {
        this.name = name;
        this.columns = Collections.unmodifiableMap(columns);
        this.foreignKeys = Collections.unmodifiableSet(foreignKeys);
    }

    public static TableInfo read(SupportSQLiteDatabase database, String tableName) {
        Map<String, Column> columns = TableInfo.readColumns(database, tableName);
        Set<ForeignKey> foreignKeys = TableInfo.readForeignKeys(database, tableName);
        return new TableInfo(tableName, columns, foreignKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<ForeignKey> readForeignKeys(SupportSQLiteDatabase database, String tableName) {
        HashSet<ForeignKey> foreignKeys = new HashSet<ForeignKey>();
        try (Cursor cursor = database.query("PRAGMA foreign_key_list(`" + tableName + "`)");){
            int idColumnIndex = cursor.getColumnIndex("id");
            int seqColumnIndex = cursor.getColumnIndex("seq");
            int tableColumnIndex = cursor.getColumnIndex("table");
            int onDeleteColumnIndex = cursor.getColumnIndex("on_delete");
            int onUpdateColumnIndex = cursor.getColumnIndex("on_update");
            List<ForeignKeyWithSequence> ordered = TableInfo.readForeignKeyFieldMappings(cursor);
            int count = cursor.getCount();
            for (int position = 0; position < count; ++position) {
                cursor.moveToPosition(position);
                int seq = cursor.getInt(seqColumnIndex);
                if (seq != 0) continue;
                int id = cursor.getInt(idColumnIndex);
                ArrayList<String> myColumns = new ArrayList<String>();
                ArrayList<String> refColumns = new ArrayList<String>();
                for (ForeignKeyWithSequence key : ordered) {
                    if (key.mId != id) continue;
                    myColumns.add(key.mFrom);
                    refColumns.add(key.mTo);
                }
                foreignKeys.add(new ForeignKey(cursor.getString(tableColumnIndex), cursor.getString(onDeleteColumnIndex), cursor.getString(onUpdateColumnIndex), myColumns, refColumns));
            }
        }
        return foreignKeys;
    }

    private static List<ForeignKeyWithSequence> readForeignKeyFieldMappings(Cursor cursor) {
        int idColumnIndex = cursor.getColumnIndex("id");
        int seqColumnIndex = cursor.getColumnIndex("seq");
        int fromColumnIndex = cursor.getColumnIndex("from");
        int toColumnIndex = cursor.getColumnIndex("to");
        int count = cursor.getCount();
        ArrayList<ForeignKeyWithSequence> result = new ArrayList<ForeignKeyWithSequence>();
        for (int i = 0; i < count; ++i) {
            cursor.moveToPosition(i);
            result.add(new ForeignKeyWithSequence(cursor.getInt(idColumnIndex), cursor.getInt(seqColumnIndex), cursor.getString(fromColumnIndex), cursor.getString(toColumnIndex)));
        }
        Collections.sort(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Column> readColumns(SupportSQLiteDatabase database, String tableName) {
        HashMap<String, Column> columns = new HashMap<String, Column>();
        try (Cursor cursor = database.query("PRAGMA table_info(`" + tableName + "`)");){
            if (cursor.getColumnCount() > 0) {
                int nameIndex = cursor.getColumnIndex("name");
                int typeIndex = cursor.getColumnIndex("type");
                int pkIndex = cursor.getColumnIndex("pk");
                while (cursor.moveToNext()) {
                    String name = cursor.getString(nameIndex);
                    String type = cursor.getString(typeIndex);
                    int primaryKeyPosition = cursor.getInt(pkIndex);
                    columns.put(name, new Column(name, type, primaryKeyPosition));
                }
            }
        }
        return columns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableInfo tableInfo = (TableInfo)o;
        if (!this.name.equals(tableInfo.name)) {
            return false;
        }
        if (!this.columns.equals(tableInfo.columns)) {
            return false;
        }
        return this.foreignKeys.equals(tableInfo.foreignKeys);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.columns.hashCode();
        result = 31 * result + this.foreignKeys.hashCode();
        return result;
    }

    public String toString() {
        return "TableInfo{name='" + this.name + '\'' + ", columns=" + this.columns + ", foreignKeys=" + this.foreignKeys + '}';
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    static class ForeignKeyWithSequence
    implements Comparable<ForeignKeyWithSequence> {
        final int mId;
        final int mSequence;
        final String mFrom;
        final String mTo;

        ForeignKeyWithSequence(int id, int sequence, String from, String to) {
            this.mId = id;
            this.mSequence = sequence;
            this.mFrom = from;
            this.mTo = to;
        }

        @Override
        public int compareTo(ForeignKeyWithSequence o) {
            int idCmp = this.mId - o.mId;
            if (idCmp == 0) {
                return this.mSequence - o.mSequence;
            }
            return idCmp;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static class ForeignKey {
        @NonNull
        public final String referenceTable;
        @NonNull
        public final String onDelete;
        @NonNull
        public final String onUpdate;
        @NonNull
        public final List<String> columnNames;
        @NonNull
        public final List<String> referenceColumnNames;

        public ForeignKey(@NonNull String referenceTable, @NonNull String onDelete, @NonNull String onUpdate, @NonNull List<String> columnNames, @NonNull List<String> referenceColumnNames) {
            this.referenceTable = referenceTable;
            this.onDelete = onDelete;
            this.onUpdate = onUpdate;
            this.columnNames = Collections.unmodifiableList(columnNames);
            this.referenceColumnNames = Collections.unmodifiableList(referenceColumnNames);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ForeignKey that = (ForeignKey)o;
            if (!this.referenceTable.equals(that.referenceTable)) {
                return false;
            }
            if (!this.onDelete.equals(that.onDelete)) {
                return false;
            }
            if (!this.onUpdate.equals(that.onUpdate)) {
                return false;
            }
            if (!this.columnNames.equals(that.columnNames)) {
                return false;
            }
            return this.referenceColumnNames.equals(that.referenceColumnNames);
        }

        public int hashCode() {
            int result = this.referenceTable.hashCode();
            result = 31 * result + this.onDelete.hashCode();
            result = 31 * result + this.onUpdate.hashCode();
            result = 31 * result + this.columnNames.hashCode();
            result = 31 * result + this.referenceColumnNames.hashCode();
            return result;
        }

        public String toString() {
            return "ForeignKey{referenceTable='" + this.referenceTable + '\'' + ", onDelete='" + this.onDelete + '\'' + ", onUpdate='" + this.onUpdate + '\'' + ", columnNames=" + this.columnNames + ", referenceColumnNames=" + this.referenceColumnNames + '}';
        }
    }

    public static class Column {
        public final String name;
        public final String type;
        public final int primaryKeyPosition;

        public Column(String name, String type, int primaryKeyPosition) {
            this.name = name;
            this.type = type;
            this.primaryKeyPosition = primaryKeyPosition;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Column column = (Column)o;
            if (Build.VERSION.SDK_INT >= 20 ? this.primaryKeyPosition != column.primaryKeyPosition : this.isPrimaryKey() != column.isPrimaryKey()) {
                return false;
            }
            if (!this.name.equals(column.name)) {
                return false;
            }
            return this.type != null ? this.type.equalsIgnoreCase(column.type) : column.type == null;
        }

        public boolean isPrimaryKey() {
            return this.primaryKeyPosition > 0;
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + this.primaryKeyPosition;
            return result;
        }

        public String toString() {
            return "Column{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", primaryKeyPosition=" + this.primaryKeyPosition + '}';
        }
    }
}

