/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.constraints.trackers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import android.support.v4.net.ConnectivityManagerCompat;
import androidx.work.Logger;
import androidx.work.impl.constraints.NetworkState;
import androidx.work.impl.constraints.trackers.ConstraintTracker;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class NetworkStateTracker
extends ConstraintTracker<NetworkState> {
    static final String TAG = Logger.tagWithPrefix("NetworkStateTracker");
    private final ConnectivityManager mConnectivityManager;
    @RequiresApi(value=24)
    private NetworkStateCallback mNetworkCallback;
    private NetworkStateBroadcastReceiver mBroadcastReceiver;

    public NetworkStateTracker(Context context) {
        super(context);
        this.mConnectivityManager = (ConnectivityManager)this.mAppContext.getSystemService("connectivity");
        if (NetworkStateTracker.isNetworkCallbackSupported()) {
            this.mNetworkCallback = new NetworkStateCallback();
        } else {
            this.mBroadcastReceiver = new NetworkStateBroadcastReceiver();
        }
    }

    @Override
    public NetworkState getInitialState() {
        return this.getActiveNetworkState();
    }

    @Override
    public void startTracking() {
        if (NetworkStateTracker.isNetworkCallbackSupported()) {
            Logger.get().debug(TAG, "Registering network callback", new Throwable[0]);
            this.mConnectivityManager.registerDefaultNetworkCallback((ConnectivityManager.NetworkCallback)this.mNetworkCallback);
        } else {
            Logger.get().debug(TAG, "Registering broadcast receiver", new Throwable[0]);
            this.mAppContext.registerReceiver((BroadcastReceiver)this.mBroadcastReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    @Override
    public void stopTracking() {
        if (NetworkStateTracker.isNetworkCallbackSupported()) {
            try {
                Logger.get().debug(TAG, "Unregistering network callback", new Throwable[0]);
                this.mConnectivityManager.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this.mNetworkCallback);
            }
            catch (IllegalArgumentException e) {
                Logger.get().error(TAG, "Received exception while unregistering network callback", e);
            }
        } else {
            Logger.get().debug(TAG, "Unregistering broadcast receiver", new Throwable[0]);
            this.mAppContext.unregisterReceiver((BroadcastReceiver)this.mBroadcastReceiver);
        }
    }

    private static boolean isNetworkCallbackSupported() {
        return Build.VERSION.SDK_INT >= 24;
    }

    NetworkState getActiveNetworkState() {
        NetworkInfo info = this.mConnectivityManager.getActiveNetworkInfo();
        boolean isConnected = info != null && info.isConnected();
        boolean isValidated = this.isActiveNetworkValidated();
        boolean isMetered = ConnectivityManagerCompat.isActiveNetworkMetered((ConnectivityManager)this.mConnectivityManager);
        boolean isNotRoaming = info != null && !info.isRoaming();
        return new NetworkState(isConnected, isValidated, isMetered, isNotRoaming);
    }

    private boolean isActiveNetworkValidated() {
        if (Build.VERSION.SDK_INT < 23) {
            return false;
        }
        Network network = this.mConnectivityManager.getActiveNetwork();
        NetworkCapabilities capabilities = this.mConnectivityManager.getNetworkCapabilities(network);
        return capabilities != null && capabilities.hasCapability(16);
    }

    private class NetworkStateBroadcastReceiver
    extends BroadcastReceiver {
        NetworkStateBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent == null || intent.getAction() == null) {
                return;
            }
            if (intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                Logger.get().debug(TAG, "Network broadcast received", new Throwable[0]);
                NetworkStateTracker.this.setState(NetworkStateTracker.this.getActiveNetworkState());
            }
        }
    }

    @RequiresApi(value=24)
    private class NetworkStateCallback
    extends ConnectivityManager.NetworkCallback {
        NetworkStateCallback() {
        }

        public void onCapabilitiesChanged(Network network, NetworkCapabilities capabilities) {
            Logger.get().debug(TAG, String.format("Network capabilities changed: %s", capabilities), new Throwable[0]);
            NetworkStateTracker.this.setState(NetworkStateTracker.this.getActiveNetworkState());
        }

        public void onLost(Network network) {
            Logger.get().debug(TAG, "Network connection lost", new Throwable[0]);
            NetworkStateTracker.this.setState(NetworkStateTracker.this.getActiveNetworkState());
        }
    }
}

