/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.os;

import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.util.Size;
import android.util.SizeF;
import androidx.core.os.BundleApi18ImplKt;
import androidx.core.os.BundleApi21ImplKt;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a;\u0010\u0000\u001a\u00020\u00012.\u0010\u0002\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00040\u0003\"\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"bundleOf", "Landroid/os/Bundle;", "pairs", "", "Lkotlin/Pair;", "", "", "([Lkotlin/Pair;)Landroid/os/Bundle;", "core-ktx_release"})
public final class BundleKt {
    @NotNull
    public static final Bundle bundleOf(Pair<String, ? extends Object> ... pairs) {
        Bundle bundle;
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        Bundle $this$bundleOf_u24lambda_u240 = bundle = new Bundle(pairs.length);
        boolean bl = false;
        for (Pair<String, ? extends Object> pair : pairs) {
            String key = (String)pair.component1();
            Object value = pair.component2();
            Object object = value;
            if (object == null) {
                $this$bundleOf_u24lambda_u240.putString(key, null);
                continue;
            }
            if (object instanceof Boolean) {
                $this$bundleOf_u24lambda_u240.putBoolean(key, ((Boolean)value).booleanValue());
                continue;
            }
            if (object instanceof Byte) {
                $this$bundleOf_u24lambda_u240.putByte(key, ((Number)value).byteValue());
                continue;
            }
            if (object instanceof Character) {
                $this$bundleOf_u24lambda_u240.putChar(key, ((Character)value).charValue());
                continue;
            }
            if (object instanceof Double) {
                $this$bundleOf_u24lambda_u240.putDouble(key, ((Number)value).doubleValue());
                continue;
            }
            if (object instanceof Float) {
                $this$bundleOf_u24lambda_u240.putFloat(key, ((Number)value).floatValue());
                continue;
            }
            if (object instanceof Integer) {
                $this$bundleOf_u24lambda_u240.putInt(key, ((Number)value).intValue());
                continue;
            }
            if (object instanceof Long) {
                $this$bundleOf_u24lambda_u240.putLong(key, ((Number)value).longValue());
                continue;
            }
            if (object instanceof Short) {
                $this$bundleOf_u24lambda_u240.putShort(key, ((Number)value).shortValue());
                continue;
            }
            if (object instanceof Bundle) {
                $this$bundleOf_u24lambda_u240.putBundle(key, (Bundle)value);
                continue;
            }
            if (object instanceof CharSequence) {
                $this$bundleOf_u24lambda_u240.putCharSequence(key, (CharSequence)value);
                continue;
            }
            if (object instanceof Parcelable) {
                $this$bundleOf_u24lambda_u240.putParcelable(key, (Parcelable)value);
                continue;
            }
            if (object instanceof boolean[]) {
                $this$bundleOf_u24lambda_u240.putBooleanArray(key, (boolean[])value);
                continue;
            }
            if (object instanceof byte[]) {
                $this$bundleOf_u24lambda_u240.putByteArray(key, (byte[])value);
                continue;
            }
            if (object instanceof char[]) {
                $this$bundleOf_u24lambda_u240.putCharArray(key, (char[])value);
                continue;
            }
            if (object instanceof double[]) {
                $this$bundleOf_u24lambda_u240.putDoubleArray(key, (double[])value);
                continue;
            }
            if (object instanceof float[]) {
                $this$bundleOf_u24lambda_u240.putFloatArray(key, (float[])value);
                continue;
            }
            if (object instanceof int[]) {
                $this$bundleOf_u24lambda_u240.putIntArray(key, (int[])value);
                continue;
            }
            if (object instanceof long[]) {
                $this$bundleOf_u24lambda_u240.putLongArray(key, (long[])value);
                continue;
            }
            if (object instanceof short[]) {
                $this$bundleOf_u24lambda_u240.putShortArray(key, (short[])value);
                continue;
            }
            if (object instanceof Object[]) {
                Class<?> componentType;
                Intrinsics.checkNotNull(value.getClass().getComponentType());
                if (Parcelable.class.isAssignableFrom(componentType)) {
                    Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Array<android.os.Parcelable>");
                    $this$bundleOf_u24lambda_u240.putParcelableArray(key, (Parcelable[])value);
                    continue;
                }
                if (String.class.isAssignableFrom(componentType)) {
                    Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.String>");
                    $this$bundleOf_u24lambda_u240.putStringArray(key, (String[])value);
                    continue;
                }
                if (CharSequence.class.isAssignableFrom(componentType)) {
                    Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.CharSequence>");
                    $this$bundleOf_u24lambda_u240.putCharSequenceArray(key, (CharSequence[])value);
                    continue;
                }
                if (Serializable.class.isAssignableFrom(componentType)) {
                    $this$bundleOf_u24lambda_u240.putSerializable(key, (Serializable)value);
                    continue;
                }
                String valueType = componentType.getCanonicalName();
                throw new IllegalArgumentException("Illegal value array type " + valueType + " for key \"" + key + '\"');
            }
            if (object instanceof Serializable) {
                $this$bundleOf_u24lambda_u240.putSerializable(key, (Serializable)value);
                continue;
            }
            if (Build.VERSION.SDK_INT >= 18 && value instanceof IBinder) {
                BundleApi18ImplKt.putBinder($this$bundleOf_u24lambda_u240, key, (IBinder)value);
                continue;
            }
            if (Build.VERSION.SDK_INT >= 21 && value instanceof Size) {
                BundleApi21ImplKt.putSize($this$bundleOf_u24lambda_u240, key, (Size)value);
                continue;
            }
            if (Build.VERSION.SDK_INT >= 21 && value instanceof SizeF) {
                BundleApi21ImplKt.putSizeF($this$bundleOf_u24lambda_u240, key, (SizeF)value);
                continue;
            }
            String valueType = value.getClass().getCanonicalName();
            throw new IllegalArgumentException("Illegal value type " + valueType + " for key \"" + key + '\"');
        }
        return bundle;
    }

    @NotNull
    public static final Bundle bundleOf() {
        return new Bundle(0);
    }
}

