/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.os;

import android.os.Build;
import android.os.PersistableBundle;
import androidx.annotation.RequiresApi;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\u001a=\u0010\u0000\u001a\u00020\u00012.\u0010\u0002\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00040\u0003\"\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0007\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"persistableBundleOf", "Landroid/os/PersistableBundle;", "pairs", "", "Lkotlin/Pair;", "", "", "([Lkotlin/Pair;)Landroid/os/PersistableBundle;", "core-ktx_release"})
public final class PersistableBundleKt {
    @RequiresApi(value=21)
    @NotNull
    public static final PersistableBundle persistableBundleOf(Pair<String, ? extends Object> ... pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        PersistableBundle persistableBundle = new PersistableBundle(pairs.length);
        boolean bl = false;
        boolean bl2 = false;
        PersistableBundle $this$persistableBundleOf_u24lambda_u2d0 = persistableBundle;
        boolean bl3 = false;
        for (Pair<String, ? extends Object> pair : pairs) {
            String key = (String)pair.component1();
            Object value = pair.component2();
            Object object = value;
            if (object == null) {
                $this$persistableBundleOf_u24lambda_u2d0.putString(key, null);
                continue;
            }
            if (object instanceof Boolean) {
                if (Build.VERSION.SDK_INT >= 22) {
                    $this$persistableBundleOf_u24lambda_u2d0.putBoolean(key, ((Boolean)value).booleanValue());
                    continue;
                }
                throw new IllegalArgumentException("Illegal value type boolean for key \"" + key + '\"');
            }
            if (object instanceof Double) {
                $this$persistableBundleOf_u24lambda_u2d0.putDouble(key, ((Number)value).doubleValue());
                continue;
            }
            if (object instanceof Integer) {
                $this$persistableBundleOf_u24lambda_u2d0.putInt(key, ((Number)value).intValue());
                continue;
            }
            if (object instanceof Long) {
                $this$persistableBundleOf_u24lambda_u2d0.putLong(key, ((Number)value).longValue());
                continue;
            }
            if (object instanceof String) {
                $this$persistableBundleOf_u24lambda_u2d0.putString(key, (String)value);
                continue;
            }
            if (object instanceof boolean[]) {
                if (Build.VERSION.SDK_INT >= 22) {
                    $this$persistableBundleOf_u24lambda_u2d0.putBooleanArray(key, (boolean[])value);
                    continue;
                }
                throw new IllegalArgumentException("Illegal value type boolean[] for key \"" + key + '\"');
            }
            if (object instanceof double[]) {
                $this$persistableBundleOf_u24lambda_u2d0.putDoubleArray(key, (double[])value);
                continue;
            }
            if (object instanceof int[]) {
                $this$persistableBundleOf_u24lambda_u2d0.putIntArray(key, (int[])value);
                continue;
            }
            if (object instanceof long[]) {
                $this$persistableBundleOf_u24lambda_u2d0.putLongArray(key, (long[])value);
                continue;
            }
            if (object instanceof Object[]) {
                Class<?> clazz = value.getClass().getComponentType();
                Intrinsics.checkNotNull(clazz);
                Class<?> componentType = clazz;
                if (String.class.isAssignableFrom(componentType)) {
                    if (value == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<kotlin.String>");
                    }
                    $this$persistableBundleOf_u24lambda_u2d0.putStringArray(key, (String[])value);
                    continue;
                }
                String valueType = componentType.getCanonicalName();
                throw new IllegalArgumentException("Illegal value array type " + valueType + " for key \"" + key + '\"');
            }
            String valueType = value.getClass().getCanonicalName();
            throw new IllegalArgumentException("Illegal value type " + valueType + " for key \"" + key + '\"');
        }
        return persistableBundle;
    }
}

