/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.ext;

import ca.wengsoft.snmp.Core.AsnInteger;
import ca.wengsoft.snmp.Core.AsnNameValuePair;
import ca.wengsoft.snmp.Core.AsnOID;
import ca.wengsoft.snmp.Core.AsnObject;
import ca.wengsoft.snmp.Core.AsnOctets;
import ca.wengsoft.snmp.Core.SnmpClient;
import ca.wengsoft.snmp.Core.SnmpGetSetPdu;
import ca.wengsoft.snmp.Core.SnmpMessage;
import ca.wengsoft.snmp.Core.SnmpPdu;
import org.apache.log4j.ext.SnmpTrapSenderFacade;
import org.apache.log4j.helpers.LogLog;

public class WengsoftSNMPTrapSender
implements SnmpTrapSenderFacade {
    private String managementHost = "127.0.0.1";
    private int managementHostTrapListenPort = 162;
    private String enterpriseOID = "1.3.6.1.2.1.1.2.0";
    private long sysUpTime = 0L;
    private boolean isInitialized = false;
    private SnmpMessage snmpMessage;
    private SnmpGetSetPdu trapPdu;
    private static final String SYSTEM_UPTIME_KEY = "1.3.6.1.2.1.1.3";
    private static final String TRAP_OID_KEY = "1.3.6.1.6.3.1.1.4.1";
    private static final String ENTERPRISE_OID_KEY = "1.3.6.1.6.3.1.1.4.3";

    public void initialize(String managementHostValue, int managementHostTrapListenPortValue, String enterpriseOIDValue, String localIPAddressValue, int localTrapSendPortValue, int genericTrapTypeValue, int specificTrapTypeValue, String communityStringValue, long sysUpTimeValue) {
        this.managementHost = managementHostValue;
        this.managementHostTrapListenPort = managementHostTrapListenPortValue;
        this.enterpriseOID = enterpriseOIDValue;
        this.sysUpTime = sysUpTimeValue;
        this.snmpMessage = new SnmpMessage();
        this.trapPdu = new SnmpGetSetPdu();
        this.isInitialized = true;
    }

    public void addTrapMessageVariable(String applicationTrapOIDValue, String value) {
        if (!this.isInitialized) {
            LogLog.error((String)"The initialize() method must be called before calling addTrapMessageVariable()");
            return;
        }
        this.trapPdu.addNameValuePair(new AsnNameValuePair(TRAP_OID_KEY, (AsnObject)new AsnOID(applicationTrapOIDValue)));
        this.trapPdu.addNameValuePair(new AsnNameValuePair(applicationTrapOIDValue, (AsnObject)new AsnOctets(value)));
    }

    public void sendTrap() {
        if (!this.isInitialized) {
            LogLog.error((String)"The initialize() method must be called before calling sendTrap()");
            return;
        }
        this.trapPdu.setMsgType((byte)-89);
        this.trapPdu.setReqId(1L);
        this.trapPdu.addNameValuePair(new AsnNameValuePair(ENTERPRISE_OID_KEY, (AsnObject)new AsnOID(this.enterpriseOID)));
        this.trapPdu.addNameValuePair(new AsnNameValuePair(SYSTEM_UPTIME_KEY, (AsnObject)new AsnInteger(this.sysUpTime)));
        this.snmpMessage.setPdu((SnmpPdu)this.trapPdu);
        this.snmpMessage.setSnmpVersion(2L);
        SnmpClient client = new SnmpClient();
        try {
            client.sendSnmpMessage(this.managementHost, this.managementHostTrapListenPort, this.snmpMessage);
        }
        catch (Exception ex) {
            LogLog.error((String)"There was an unexpected error while sending the trap.", (Throwable)ex);
        }
    }
}

