/*
 * Decompiled with CFR 0.152.
 */
package au.com.anthonybruno;

import au.com.anthonybruno.creator.CsvFactory;
import au.com.anthonybruno.creator.FileFactory;
import au.com.anthonybruno.creator.FixedWidthFactory;
import au.com.anthonybruno.definition.FieldData;
import au.com.anthonybruno.definition.FieldDefinition;
import au.com.anthonybruno.definition.FileTypeDefinition;
import au.com.anthonybruno.definition.RecordDefinition;
import au.com.anthonybruno.definition.ResultDefinition;
import au.com.anthonybruno.definition.StartDefinition;
import au.com.anthonybruno.generator.Generator;
import au.com.anthonybruno.record.factory.ClassRecordFactory;
import au.com.anthonybruno.record.factory.FieldsRecordFactory;
import au.com.anthonybruno.record.factory.RecordFactory;
import au.com.anthonybruno.settings.CsvSettings;
import au.com.anthonybruno.settings.FixedWidthSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class Gen
implements FileTypeDefinition,
ResultDefinition,
StartDefinition,
RecordDefinition,
FieldDefinition {
    private int numToGenerate;
    private FileFactory fileFactory;
    private Class<?> useClass;
    private List<FieldData> fields = new ArrayList<FieldData>();

    public static StartDefinition start() {
        return new Gen();
    }

    private Gen() {
    }

    @Override
    public RecordDefinition use(Class<?> c) {
        this.useClass = c;
        return this;
    }

    @Override
    public FieldDefinition addField(String name, Generator generator) {
        this.fields.add(new FieldData(name, generator));
        return this;
    }

    @Override
    public ResultDefinition asCsv() {
        return this.asCsv(new CsvSettings.Builder().build());
    }

    @Override
    public ResultDefinition asCsv(CsvSettings csvSettings) {
        this.fileFactory = new CsvFactory(csvSettings, this.createRecordFactory());
        return this;
    }

    @Override
    public ResultDefinition asFixedWidth(FixedWidthSettings fixedWidthSettings) {
        this.fileFactory = new FixedWidthFactory(fixedWidthSettings, this.createRecordFactory());
        return this;
    }

    @Override
    public File toFile(File file) {
        return this.fileFactory.createFile(file, this.numToGenerate);
    }

    @Override
    public File toFile(String path) {
        return this.toFile(new File(path));
    }

    @Override
    public String toStringForm() {
        this.checkSetup();
        return this.fileFactory.createString(this.numToGenerate);
    }

    @Override
    public FileTypeDefinition generate(int num) {
        this.numToGenerate = num;
        return this;
    }

    private RecordFactory createRecordFactory() {
        if (this.useClass != null) {
            return new ClassRecordFactory(this.useClass);
        }
        if (!this.fields.isEmpty()) {
            return new FieldsRecordFactory(this.fields);
        }
        throw new IllegalStateException("No fields or class added to generator");
    }

    private void checkSetup() {
        if (this.useClass == null && this.fields.isEmpty()) {
            throw new IllegalStateException("No generation fields or class specified! Please utilise the #use or #addField methods!");
        }
        if (this.fileFactory == null) {
            throw new IllegalStateException("No file type specified! Use one of the 'as' methods such as #asCsv()");
        }
        if (this.numToGenerate <= 0) {
            throw new IllegalStateException("Need to specify a positive non-zero number of records to generate!");
        }
    }
}

