/*
 * Decompiled with CFR 0.152.
 */
package au.com.anthonybruno.record.factory;

import au.com.anthonybruno.annotation.Generation;
import au.com.anthonybruno.annotation.Index;
import au.com.anthonybruno.annotation.Range;
import au.com.anthonybruno.generator.DefaultGenerators;
import au.com.anthonybruno.generator.Generator;
import au.com.anthonybruno.generator.RangedGenerator;
import au.com.anthonybruno.record.DefaultRecords;
import au.com.anthonybruno.record.Record;
import au.com.anthonybruno.record.Records;
import au.com.anthonybruno.record.RowRecord;
import au.com.anthonybruno.record.factory.RecordFactory;
import au.com.anthonybruno.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClassRecordFactory
implements RecordFactory {
    private final Class<?> classToUse;
    private final Map<Field, Generator> fieldGeneratorMap = new HashMap<Field, Generator>();

    public ClassRecordFactory(Class<?> classToUse) {
        this.classToUse = classToUse;
    }

    @Override
    public Records generateRecords(int numToGenerate) {
        Field[] fields = this.getFields();
        List<String> fieldNames = this.getFieldNames(fields);
        ArrayList<Record> records = new ArrayList<Record>();
        for (int i = 0; i < numToGenerate; ++i) {
            records.add(this.generateRecord(fields));
        }
        return new DefaultRecords(fieldNames, records);
    }

    private List<String> getFieldNames(Field[] fields) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Field field : fields) {
            Generation generation = field.getAnnotation(Generation.class);
            if (generation != null && !generation.name().equals("${default}")) {
                fieldNames.add(generation.name());
                continue;
            }
            fieldNames.add(field.getName());
        }
        return fieldNames;
    }

    private Field[] getFields() {
        Field[] fields = this.classToUse.getDeclaredFields();
        Field[] orderedFields = new Field[fields.length];
        ArrayList<Field> leftoverFields = new ArrayList<Field>();
        for (Field field : fields) {
            Index index = field.getAnnotation(Index.class);
            if (index != null) {
                int indexNum = index.value();
                if (indexNum >= orderedFields.length) {
                    throw new RuntimeException("Index number of field: " + field.getName() + " is larger than the number of fields " + orderedFields.length);
                }
                if (orderedFields[indexNum] != null) {
                    throw new RuntimeException("'" + orderedFields[indexNum].getName() + "' and '" + field.getName() + "' has same index number of: " + indexNum);
                }
                orderedFields[indexNum] = field;
                continue;
            }
            leftoverFields.add(field);
        }
        if (leftoverFields.size() == fields.length) {
            return fields;
        }
        block1: for (Field field : leftoverFields) {
            for (int i = 0; i < orderedFields.length; ++i) {
                if (orderedFields[i] != null) continue;
                orderedFields[i] = field;
                continue block1;
            }
        }
        return orderedFields;
    }

    private Record generateRecord(Field[] fields) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Field field : fields) {
            list.add(this.generateValue(field));
        }
        return new RowRecord(list);
    }

    private Object generateValue(Field field) {
        Generator generator = this.fieldGeneratorMap.get(field);
        if (generator == null) {
            Generator candidateGenerator = this.getGenerator(field);
            Range range = field.getAnnotation(Range.class);
            generator = range != null && candidateGenerator instanceof RangedGenerator ? (Generator)ReflectionUtils.buildWithConstructor(candidateGenerator.getClass(), range.min(), range.max()) : candidateGenerator;
            this.fieldGeneratorMap.put(field, generator);
        }
        return generator.generate();
    }

    private Generator<?> getGenerator(Field field) {
        Generation generatorAnnotation = field.getAnnotation(Generation.class);
        Generator generator = generatorAnnotation != null ? ReflectionUtils.buildWithNoArgConstructor(generatorAnnotation.value()) : DefaultGenerators.get(field.getType());
        return generator;
    }
}

