/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit.loader;

import au.com.dius.pact.core.model.BrokerUrlSource;
import au.com.dius.pact.core.model.Consumer;
import au.com.dius.pact.core.model.DefaultPactReader;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.PactBrokerSource;
import au.com.dius.pact.core.model.PactReader;
import au.com.dius.pact.core.model.PactSource;
import au.com.dius.pact.core.pactbroker.PactBrokerClient;
import au.com.dius.pact.core.pactbroker.PactBrokerConsumer;
import au.com.dius.pact.core.support.KotlinLanguageSupportKt;
import au.com.dius.pact.core.support.expressions.ExpressionParser;
import au.com.dius.pact.core.support.expressions.SystemPropertyResolver;
import au.com.dius.pact.core.support.expressions.ValueResolver;
import au.com.dius.pact.provider.ConsumerInfo;
import au.com.dius.pact.provider.junit.loader.NoPactsFoundException;
import au.com.dius.pact.provider.junit.loader.OverrideablePactLoader;
import au.com.dius.pact.provider.junit.loader.PactBroker;
import au.com.dius.pact.provider.junit.loader.PactBrokerAuth;
import au.com.dius.pact.provider.junit.loader.PactBrokerLoader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 S2\u00020\u0001:\u0001SB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004Bs\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\n\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u0010\u0010\u0010\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0012\u0018\u00010\u0011\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0014J\u0010\u00107\u001a\u0002082\u0006\u00102\u001a\u00020\u0012H\u0002J\b\u00109\u001a\u00020\u0006H\u0016J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u0002010;2\u0006\u00102\u001a\u00020\u0012H\u0002J\n\u0010<\u001a\u0004\u0018\u00010=H\u0016J \u0010>\u001a\u00020\u00062\u0006\u0010?\u001a\u00020\u00062\u0006\u0010@\u001a\u00020\u00062\u0006\u0010A\u001a\u00020BH\u0002J\u001c\u0010C\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u000201000\n2\u0006\u0010?\u001a\u00020\u0006H\u0016J*\u0010D\u001a\b\u0012\u0004\u0012\u000201002\u0006\u0010E\u001a\u00020F2\u0012\u0010G\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020I0HH\u0016J.\u0010J\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u000201000\n2\u0006\u0010?\u001a\u00020\u00062\b\u0010@\u001a\u0004\u0018\u00010\u00062\u0006\u00102\u001a\u00020\u0012H\u0002J\u0018\u0010K\u001a\u00020B2\u0006\u0010L\u001a\u00020M2\u0006\u00102\u001a\u00020\u0012H\u0016J\u0018\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020\u00062\u0006\u0010E\u001a\u00020\u0006H\u0016J\u0010\u0010Q\u001a\u00020O2\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010R\u001a\u00020\u0012H\u0002R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\"R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\"R\u0019\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010 R\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R&\u0010,\u001a\u001a\u0012\u0004\u0012\u00020.\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u000201000/0-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0012\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106\u00a8\u0006T"}, d2={"Lau/com/dius/pact/provider/junit/loader/PactBrokerLoader;", "Lau/com/dius/pact/provider/junit/loader/OverrideablePactLoader;", "pactBroker", "Lau/com/dius/pact/provider/junit/loader/PactBroker;", "(Lau/com/dius/pact/provider/junit/loader/PactBroker;)V", "pactBrokerHost", "", "pactBrokerPort", "pactBrokerScheme", "pactBrokerTags", "", "pactBrokerConsumers", "failIfNoPactsFound", "", "authentication", "Lau/com/dius/pact/provider/junit/loader/PactBrokerAuth;", "valueResolverClass", "Lkotlin/reflect/KClass;", "Lau/com/dius/pact/core/support/expressions/ValueResolver;", "valueResolver", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;ZLau/com/dius/pact/provider/junit/loader/PactBrokerAuth;Lkotlin/reflect/KClass;Lau/com/dius/pact/core/support/expressions/ValueResolver;)V", "getAuthentication", "()Lau/com/dius/pact/provider/junit/loader/PactBrokerAuth;", "setAuthentication", "(Lau/com/dius/pact/provider/junit/loader/PactBrokerAuth;)V", "getFailIfNoPactsFound", "()Z", "setFailIfNoPactsFound", "(Z)V", "overriddenConsumer", "overriddenPactUrl", "getPactBrokerConsumers", "()Ljava/util/List;", "getPactBrokerHost", "()Ljava/lang/String;", "getPactBrokerPort", "getPactBrokerScheme", "getPactBrokerTags", "pactReader", "Lau/com/dius/pact/core/model/PactReader;", "getPactReader", "()Lau/com/dius/pact/core/model/PactReader;", "setPactReader", "(Lau/com/dius/pact/core/model/PactReader;)V", "pacts", "", "Lau/com/dius/pact/core/model/Consumer;", "", "Lau/com/dius/pact/core/model/Pact;", "Lau/com/dius/pact/core/model/Interaction;", "resolver", "getValueResolverClass", "()Lkotlin/reflect/KClass;", "setValueResolverClass", "(Lkotlin/reflect/KClass;)V", "brokerUrl", "Lorg/apache/http/client/utils/URIBuilder;", "description", "getPactBrokerSource", "Lau/com/dius/pact/core/model/PactBrokerSource;", "getPactSource", "Lau/com/dius/pact/core/model/PactSource;", "getUrlForProvider", "providerName", "tag", "pactBrokerClient", "Lau/com/dius/pact/core/pactbroker/PactBrokerClient;", "load", "loadPact", "consumer", "Lau/com/dius/pact/provider/ConsumerInfo;", "options", "", "", "loadPactsForProvider", "newPactBrokerClient", "url", "Ljava/net/URI;", "overridePactUrl", "", "pactUrl", "setValueResolver", "setupValueResolver", "Companion", "pact-jvm-provider"})
public class PactBrokerLoader
implements OverrideablePactLoader {
    private Map<Consumer, List<Pact<Interaction>>> pacts;
    private ValueResolver resolver;
    private String overriddenPactUrl;
    private String overriddenConsumer;
    @NotNull
    private PactReader pactReader;
    @NotNull
    private final String pactBrokerHost;
    @Nullable
    private final String pactBrokerPort;
    @NotNull
    private final String pactBrokerScheme;
    @Nullable
    private final List<String> pactBrokerTags;
    @NotNull
    private final List<String> pactBrokerConsumers;
    private boolean failIfNoPactsFound;
    @Nullable
    private PactBrokerAuth authentication;
    @Nullable
    private KClass<? extends ValueResolver> valueResolverClass;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final PactReader getPactReader() {
        return this.pactReader;
    }

    public final void setPactReader(@NotNull PactReader pactReader) {
        Intrinsics.checkParameterIsNotNull((Object)pactReader, (String)"<set-?>");
        this.pactReader = pactReader;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String description() {
        void $this$filterTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        List list;
        Iterable destination$iv$iv;
        ValueResolver resolver = this.setupValueResolver();
        List<String> list2 = this.pactBrokerTags;
        if (list2 != null) {
            void $this$filterTo$iv$iv2;
            String it;
            Iterable $this$flatMapTo$iv$iv2;
            Iterable $this$flatMap$iv = list2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                it = (String)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = ExpressionParser.parseListExpression((String)it, (ValueResolver)resolver);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$flatMapTo$iv$iv2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (String)element$iv$iv;
                boolean bl = false;
                if (!KotlinLanguageSupportKt.isNotEmpty((String)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List tags = list;
        Iterable $this$flatMap$iv = this.pactBrokerConsumers;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ExpressionParser.parseListExpression((String)it, (ValueResolver)resolver);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!KotlinLanguageSupportKt.isNotEmpty((String)it)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List consumers = (List)destination$iv$iv2;
        String source = this.getPactBrokerSource(resolver).description();
        if (tags != null) {
            Collection collection = tags;
            boolean bl = false;
            if (!collection.isEmpty()) {
                source = source + " tags=" + tags;
            }
        }
        Collection collection = consumers;
        boolean bl = false;
        if (!collection.isEmpty()) {
            source = source + " consumers=" + consumers;
        }
        return source;
    }

    @Override
    public void overridePactUrl(@NotNull String pactUrl, @NotNull String consumer) {
        Intrinsics.checkParameterIsNotNull((Object)pactUrl, (String)"pactUrl");
        Intrinsics.checkParameterIsNotNull((Object)consumer, (String)"consumer");
        this.overriddenPactUrl = pactUrl;
        this.overriddenConsumer = consumer;
    }

    @NotNull
    public List<Pact<Interaction>> load(@NotNull String providerName) {
        List list;
        Object brokerUri;
        Intrinsics.checkParameterIsNotNull((Object)providerName, (String)"providerName");
        ValueResolver resolver = this.setupValueResolver();
        if (KotlinLanguageSupportKt.isNotEmpty((String)this.overriddenPactUrl)) {
            Object object = brokerUri = this.brokerUrl(resolver).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"brokerUri");
            PactBrokerClient pactBrokerClient = this.newPactBrokerClient((URI)object, resolver);
            String string = this.overriddenPactUrl;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String string2 = ((URI)brokerUri).toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"brokerUri.toString()");
            BrokerUrlSource pactSource2 = new BrokerUrlSource(string, string2, null, null, null, 28, null);
            pactSource2.setEncodePath(false);
            String string3 = this.overriddenConsumer;
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            list = CollectionsKt.listOf(this.loadPact(new ConsumerInfo(string3, null, false, null, null, pactSource2, null, null, 222, null), pactBrokerClient.getOptions()));
        } else {
            brokerUri = this.pactBrokerTags;
            boolean pactBrokerClient = false;
            boolean pactSource2 = false;
            if (brokerUri == null || brokerUri.isEmpty()) {
                list = this.loadPactsForProvider(providerName, null, resolver);
            } else {
                String it;
                Iterable $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv = this.pactBrokerTags;
                boolean $i$f$flatMap = false;
                Iterable pactSource2 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (String)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = ExpressionParser.parseListExpression((String)it, (ValueResolver)resolver);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv;
                $i$f$flatMap = false;
                $this$flatMapTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    List<Pact<Interaction>> list2;
                    it = (String)element$iv$iv;
                    boolean bl = false;
                    try {
                        list2 = this.loadPactsForProvider(providerName, it, resolver);
                    }
                    catch (NoPactsFoundException e) {
                        list2 = CollectionsKt.emptyList();
                    }
                    Iterable list$iv$iv = list2;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list = (List)destination$iv$iv;
            }
        }
        List pacts = list;
        return pacts;
    }

    private final ValueResolver setupValueResolver() {
        ValueResolver valueResolver = (ValueResolver)new SystemPropertyResolver();
        if (this.resolver != null) {
            ValueResolver valueResolver2 = this.resolver;
            if (valueResolver2 == null) {
                Intrinsics.throwNpe();
            }
            valueResolver = valueResolver2;
        } else if (this.valueResolverClass != null) {
            try {
                KClass<? extends ValueResolver> kClass = this.valueResolverClass;
                if (kClass == null) {
                    Intrinsics.throwNpe();
                }
                Object t = JvmClassMappingKt.getJavaClass(kClass).newInstance();
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"valueResolverClass!!.java.newInstance()");
                valueResolver = (ValueResolver)t;
            }
            catch (InstantiationException e) {
                Companion.getLogger().warn((Throwable)e, (Function0)setupValueResolver.1.INSTANCE);
            }
            catch (IllegalAccessException e) {
                Companion.getLogger().warn((Throwable)e, (Function0)setupValueResolver.2.INSTANCE);
            }
        }
        return valueResolver;
    }

    @Override
    @Nullable
    public PactSource getPactSource() {
        ValueResolver resolver = this.setupValueResolver();
        return (PactSource)this.getPactBrokerSource(resolver);
    }

    @Override
    public void setValueResolver(@NotNull ValueResolver valueResolver) {
        Intrinsics.checkParameterIsNotNull((Object)valueResolver, (String)"valueResolver");
        this.resolver = valueResolver;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pact<Interaction>> loadPactsForProvider(String providerName, String tag, ValueResolver resolver) throws IOException, IllegalArgumentException {
        Companion.getLogger().debug((Function0)new Function0<String>(providerName, tag){
            final /* synthetic */ String $providerName;
            final /* synthetic */ String $tag;

            @NotNull
            public final String invoke() {
                return "Loading pacts from pact broker for provider " + this.$providerName + " and tag " + this.$tag;
            }
            {
                this.$providerName = string;
                this.$tag = string2;
                super(0);
            }
        });
        URIBuilder uriBuilder = this.brokerUrl(resolver);
        try {
            void $this$mapTo$iv$iv;
            List list;
            Pact<Interaction> pact2;
            PactBrokerConsumer it;
            Collection collection;
            Iterable $this$mapTo$iv$iv2;
            boolean $i$f$mapTo;
            Iterable destination$iv$iv;
            boolean $i$f$map;
            Object $this$map$iv;
            List consumers = null;
            URI uRI = uriBuilder.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"uriBuilder.build()");
            PactBrokerClient pactBrokerClient = this.newPactBrokerClient(uRI, resolver);
            CharSequence charSequence = tag;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || charSequence.length() == 0 || Intrinsics.areEqual((Object)tag, (Object)"latest")) {
                $this$map$iv = pactBrokerClient.fetchConsumers(providerName);
                $i$f$map = false;
                Iterable iterable = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    PactBrokerConsumer pactBrokerConsumer = (PactBrokerConsumer)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    pact2 = ConsumerInfo.Companion.from(it);
                    collection.add(pact2);
                }
                list = (List)destination$iv$iv;
            } else {
                $this$map$iv = pactBrokerClient.fetchConsumersWithTag(providerName, tag);
                $i$f$map = false;
                $this$mapTo$iv$iv2 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    it = (PactBrokerConsumer)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl4 = false;
                    pact2 = ConsumerInfo.Companion.from(it);
                    collection.add(pact2);
                }
                list = consumers = (List)destination$iv$iv;
            }
            if (this.failIfNoPactsFound && consumers.isEmpty()) {
                $this$map$iv = tag;
                String string = providerName;
                PactBrokerLoader pactBrokerLoader = this;
                StringBuilder stringBuilder = new StringBuilder().append("No consumer pacts were found for provider '").append(providerName).append("' and tag '").append(tag).append("'. (URL ");
                $i$f$map = false;
                Object object = $this$map$iv;
                if (object == null) {
                    object = "";
                }
                Object object2 = object;
                String string2 = stringBuilder.append(pactBrokerLoader.getUrlForProvider(string, (String)object2, pactBrokerClient)).append(")").toString();
                throw (Throwable)new NoPactsFoundException(string2);
            }
            $this$map$iv = this.pactBrokerConsumers;
            $i$f$map = false;
            if (!$this$map$iv.isEmpty()) {
                void $this$filterTo$iv$iv;
                Iterable $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv = this.pactBrokerConsumers;
                boolean $i$f$flatMap = false;
                destination$iv$iv = $this$flatMap$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    String it2 = (String)element$iv$iv;
                    boolean bl5 = false;
                    Iterable list$iv$iv = ExpressionParser.parseListExpression((String)it2, (ValueResolver)resolver);
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                List consumerInclusions = (List)destination$iv$iv2;
                Iterable $this$filter$iv = consumers;
                boolean $i$f$filter = false;
                $this$flatMapTo$iv$iv = $this$filter$iv;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    ConsumerInfo it3 = (ConsumerInfo)element$iv$iv;
                    boolean bl6 = false;
                    if (!(consumerInclusions.isEmpty() || consumerInclusions.contains(it3.getName()))) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                consumers = (List)destination$iv$iv2;
            }
            $this$map$iv = consumers;
            $i$f$map = false;
            Iterable $i$f$filter = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Object element$iv$iv;
                element$iv$iv = (ConsumerInfo)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl7 = false;
                pact2 = this.loadPact((ConsumerInfo)it, pactBrokerClient.getOptions());
                collection.add(pact2);
            }
            return (List)destination$iv$iv;
        }
        catch (URISyntaxException e) {
            throw (Throwable)new IOException("Was not able load pacts from broker as the broker URL was invalid", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final URIBuilder brokerUrl(ValueResolver resolver) {
        void port;
        void host;
        PactBrokerSource<Interaction> pactBrokerSource = this.getPactBrokerSource(resolver);
        String string = pactBrokerSource.component1();
        String string2 = pactBrokerSource.component2();
        String scheme = pactBrokerSource.component3();
        URIBuilder uriBuilder = new URIBuilder().setScheme(scheme).setHost((String)host);
        if (KotlinLanguageSupportKt.isNotEmpty((String)port)) {
            URIBuilder uRIBuilder = uriBuilder;
            Intrinsics.checkExpressionValueIsNotNull((Object)uRIBuilder, (String)"uriBuilder");
            uRIBuilder.setPort(Integer.parseInt((String)port));
        }
        URIBuilder uRIBuilder = uriBuilder;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRIBuilder, (String)"uriBuilder");
        return uRIBuilder;
    }

    private final PactBrokerSource<Interaction> getPactBrokerSource(ValueResolver resolver) {
        String scheme = ExpressionParser.parseExpression((String)this.pactBrokerScheme, (ValueResolver)resolver);
        String host = ExpressionParser.parseExpression((String)this.pactBrokerHost, (ValueResolver)resolver);
        String port = ExpressionParser.parseExpression((String)this.pactBrokerPort, (ValueResolver)resolver);
        CharSequence charSequence = host;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            String string;
            charSequence = StringCompanionObject.INSTANCE;
            String string2 = "Invalid pact broker host specified ('%s'). Please provide a valid host or specify the system property 'pactbroker.host'.";
            Object[] objectArray = new Object[]{this.pactBrokerHost};
            boolean bl3 = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            String string4 = string = string3;
            throw (Throwable)new IllegalArgumentException(string4);
        }
        if (KotlinLanguageSupportKt.isNotEmpty((String)port)) {
            String string = port;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            charSequence = string;
            Object object = new Regex("^[0-9]+");
            bl2 = false;
            if (!object.matches(charSequence)) {
                String string5;
                charSequence = StringCompanionObject.INSTANCE;
                object = "Invalid pact broker port specified ('%s'). Please provide a valid port number or specify the system property 'pactbroker.port'.";
                Object[] objectArray = new Object[]{this.pactBrokerPort};
                boolean bl4 = false;
                String string6 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"java.lang.String.format(format, *args)");
                String string7 = string5 = string6;
                throw (Throwable)new IllegalArgumentException(string7);
            }
        }
        return scheme == null ? new PactBrokerSource(host, port, null, this.pacts, 4, null) : new PactBrokerSource(host, port, scheme, this.pacts);
    }

    private final String getUrlForProvider(String providerName, String tag, PactBrokerClient pactBrokerClient) {
        String string;
        try {
            String string2 = pactBrokerClient.getUrlForProvider(providerName, tag);
            if (string2 == null) {
                string2 = "Unknown";
            }
            string = string2;
        }
        catch (Exception e) {
            Companion.getLogger().debug((Throwable)e, (Function0)getUrlForProvider.1.INSTANCE);
            string = "Unknown";
        }
        return string;
    }

    @NotNull
    public Pact<Interaction> loadPact(@NotNull ConsumerInfo consumer, @NotNull Map<String, ? extends Object> options) {
        Consumer pactConsumer;
        Intrinsics.checkParameterIsNotNull((Object)consumer, (String)"consumer");
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        Object object = consumer.getPactSource();
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Pact pact2 = this.pactReader.loadPact(object, options);
        if (pact2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type au.com.dius.pact.core.model.Pact<au.com.dius.pact.core.model.Interaction>");
        }
        Pact pact3 = pact2;
        Consumer consumer2 = pactConsumer = consumer.toPactConsumer();
        Map<Consumer, List<Pact<Interaction>>> map = this.pacts;
        boolean bl = false;
        List list = new ArrayList();
        List<Pact<Interaction>> pactList = map.getOrDefault(consumer2, list);
        pactList.add((Pact<Interaction>)pact3);
        this.pacts.put(pactConsumer, pactList);
        return pact3;
    }

    @NotNull
    public PactBrokerClient newPactBrokerClient(@NotNull URI url, @NotNull ValueResolver resolver) {
        String token;
        String username;
        String scheme;
        block14: {
            block13: {
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
                if (this.authentication == null) break block13;
                PactBrokerAuth pactBrokerAuth = this.authentication;
                if (pactBrokerAuth == null) {
                    Intrinsics.throwNpe();
                }
                if (!StringsKt.equals((String)pactBrokerAuth.scheme(), (String)"none", (boolean)true)) break block14;
            }
            Companion.getLogger().debug((Function0)newPactBrokerClient.1.INSTANCE);
            String string = url.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toString()");
            return new PactBrokerClient(string, MapsKt.emptyMap());
        }
        PactBrokerAuth pactBrokerAuth = this.authentication;
        if (pactBrokerAuth == null) {
            Intrinsics.throwNpe();
        }
        if (KotlinLanguageSupportKt.isNotEmpty((String)(scheme = ExpressionParser.parseExpression((String)pactBrokerAuth.scheme(), (ValueResolver)resolver)))) {
            String schemeToUse = StringsKt.equals$default((String)scheme, (String)"legacy", (boolean)false, (int)2, null) ? "basic" : scheme;
            Companion.getLogger().debug((Function0)new Function0<String>(schemeToUse){
                final /* synthetic */ String $schemeToUse;

                @NotNull
                public final String invoke() {
                    return "Authentication: " + this.$schemeToUse;
                }
                {
                    this.$schemeToUse = string;
                    super(0);
                }
            });
            Object[] objectArray = new String[3];
            objectArray[0] = schemeToUse;
            PactBrokerAuth pactBrokerAuth2 = this.authentication;
            if (pactBrokerAuth2 == null) {
                Intrinsics.throwNpe();
            }
            objectArray[1] = ExpressionParser.parseExpression((String)pactBrokerAuth2.username(), (ValueResolver)resolver);
            PactBrokerAuth pactBrokerAuth3 = this.authentication;
            if (pactBrokerAuth3 == null) {
                Intrinsics.throwNpe();
            }
            objectArray[2] = ExpressionParser.parseExpression((String)pactBrokerAuth3.password(), (ValueResolver)resolver);
            Map options = MapsKt.mapOf((Pair)TuplesKt.to((Object)"authentication", (Object)CollectionsKt.listOf((Object[])objectArray)));
            String string = url.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toString()");
            return new PactBrokerClient(string, options);
        }
        PactBrokerAuth pactBrokerAuth4 = this.authentication;
        if (pactBrokerAuth4 == null) {
            Intrinsics.throwNpe();
        }
        if (KotlinLanguageSupportKt.isNotEmpty((String)(username = ExpressionParser.parseExpression((String)pactBrokerAuth4.username(), (ValueResolver)resolver)))) {
            Companion.getLogger().debug((Function0)newPactBrokerClient.3.INSTANCE);
            Object[] objectArray = new String[3];
            objectArray[0] = "basic";
            objectArray[1] = username;
            PactBrokerAuth pactBrokerAuth5 = this.authentication;
            if (pactBrokerAuth5 == null) {
                Intrinsics.throwNpe();
            }
            objectArray[2] = ExpressionParser.parseExpression((String)pactBrokerAuth5.password(), (ValueResolver)resolver);
            Map options = MapsKt.mapOf((Pair)TuplesKt.to((Object)"authentication", (Object)CollectionsKt.listOf((Object[])objectArray)));
            String string = url.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toString()");
            return new PactBrokerClient(string, options);
        }
        PactBrokerAuth pactBrokerAuth6 = this.authentication;
        if (pactBrokerAuth6 == null) {
            Intrinsics.throwNpe();
        }
        if (KotlinLanguageSupportKt.isNotEmpty((String)(token = ExpressionParser.parseExpression((String)pactBrokerAuth6.token(), (ValueResolver)resolver)))) {
            Companion.getLogger().debug((Function0)newPactBrokerClient.4.INSTANCE);
            Map options = MapsKt.mapOf((Pair)TuplesKt.to((Object)"authentication", (Object)CollectionsKt.listOf((Object[])new String[]{"bearer", token})));
            String string = url.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toString()");
            return new PactBrokerClient(string, options);
        }
        throw (Throwable)new IllegalArgumentException("Invalid pact authentication specified. Either username or token must be set.");
    }

    @NotNull
    public final String getPactBrokerHost() {
        return this.pactBrokerHost;
    }

    @Nullable
    public final String getPactBrokerPort() {
        return this.pactBrokerPort;
    }

    @NotNull
    public final String getPactBrokerScheme() {
        return this.pactBrokerScheme;
    }

    @Nullable
    public final List<String> getPactBrokerTags() {
        return this.pactBrokerTags;
    }

    @NotNull
    public final List<String> getPactBrokerConsumers() {
        return this.pactBrokerConsumers;
    }

    public final boolean getFailIfNoPactsFound() {
        return this.failIfNoPactsFound;
    }

    public final void setFailIfNoPactsFound(boolean bl) {
        this.failIfNoPactsFound = bl;
    }

    @Nullable
    public final PactBrokerAuth getAuthentication() {
        return this.authentication;
    }

    public final void setAuthentication(@Nullable PactBrokerAuth pactBrokerAuth) {
        this.authentication = pactBrokerAuth;
    }

    @Nullable
    public final KClass<? extends ValueResolver> getValueResolverClass() {
        return this.valueResolverClass;
    }

    public final void setValueResolverClass(@Nullable KClass<? extends ValueResolver> kClass) {
        this.valueResolverClass = kClass;
    }

    public PactBrokerLoader(@NotNull String pactBrokerHost, @Nullable String pactBrokerPort, @NotNull String pactBrokerScheme, @Nullable List<String> pactBrokerTags, @NotNull List<String> pactBrokerConsumers, boolean failIfNoPactsFound, @Nullable PactBrokerAuth authentication, @Nullable KClass<? extends ValueResolver> valueResolverClass, @Nullable ValueResolver valueResolver) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)pactBrokerHost, (String)"pactBrokerHost");
        Intrinsics.checkParameterIsNotNull((Object)pactBrokerScheme, (String)"pactBrokerScheme");
        Intrinsics.checkParameterIsNotNull(pactBrokerConsumers, (String)"pactBrokerConsumers");
        this.pactBrokerHost = pactBrokerHost;
        this.pactBrokerPort = pactBrokerPort;
        this.pactBrokerScheme = pactBrokerScheme;
        this.pactBrokerTags = pactBrokerTags;
        this.pactBrokerConsumers = pactBrokerConsumers;
        this.failIfNoPactsFound = failIfNoPactsFound;
        this.authentication = authentication;
        this.valueResolverClass = valueResolverClass;
        PactBrokerLoader pactBrokerLoader = this;
        boolean bl = false;
        pactBrokerLoader.pacts = map = (Map)new LinkedHashMap();
        this.resolver = valueResolver;
        this.pactReader = (PactReader)DefaultPactReader.INSTANCE;
    }

    public /* synthetic */ PactBrokerLoader(String string, String string2, String string3, List list, List list2, boolean bl, PactBrokerAuth pactBrokerAuth, KClass kClass, ValueResolver valueResolver, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            list = CollectionsKt.listOf((Object)"latest");
        }
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            bl = true;
        }
        if ((n & 0x100) != 0) {
            valueResolver = null;
        }
        this(string, string2, string3, list, list2, bl, pactBrokerAuth, (KClass<? extends ValueResolver>)kClass, valueResolver);
    }

    public PactBrokerLoader(@NotNull PactBroker pactBroker) {
        Intrinsics.checkParameterIsNotNull((Object)pactBroker, (String)"pactBroker");
        this(pactBroker.host(), pactBroker.port(), pactBroker.scheme(), ArraysKt.toList((Object[])pactBroker.tags()), ArraysKt.toList((Object[])pactBroker.consumers()), true, pactBroker.authentication(), Reflection.getOrCreateKotlinClass(pactBroker.valueResolver()), null, 256, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lau/com/dius/pact/provider/junit/loader/PactBrokerLoader$Companion;", "Lmu/KLogging;", "()V", "pact-jvm-provider"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

