/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.matchers;

import au.com.dius.pact.core.matchers.BodyItemMatchResult;
import au.com.dius.pact.core.matchers.BodyMatchResult;
import au.com.dius.pact.core.matchers.BodyMismatch;
import au.com.dius.pact.core.matchers.ContentMatcher;
import au.com.dius.pact.core.matchers.MatchingContext;
import au.com.dius.pact.core.matchers.MultipartMessageContentMatcher;
import au.com.dius.pact.core.model.ContentType;
import au.com.dius.pact.core.model.OptionalBody;
import au.com.dius.pact.core.support.Result;
import io.pact.plugins.jvm.core.InteractionContents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J0\u0010\u0015\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0004\u0012\u0004\u0012\u00020\u00130\u00162\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0019H\u0016\u00a8\u0006\u001c"}, d2={"Lau/com/dius/pact/core/matchers/MultipartMessageContentMatcher;", "Lau/com/dius/pact/core/matchers/ContentMatcher;", "()V", "compareContents", "", "Lau/com/dius/pact/core/matchers/BodyItemMatchResult;", "expectedMultipart", "Ljavax/mail/BodyPart;", "actualMultipart", "context", "Lau/com/dius/pact/core/matchers/MatchingContext;", "compareHeaders", "matchBody", "Lau/com/dius/pact/core/matchers/BodyMatchResult;", "expected", "Lau/com/dius/pact/core/model/OptionalBody;", "actual", "parseMultipart", "body", "", "contentType", "setupBodyFromConfig", "Lau/com/dius/pact/core/support/Result;", "Lio/pact/plugins/jvm/core/InteractionContents;", "bodyConfig", "", "", "Companion", "matchers"})
public final class MultipartMessageContentMatcher
implements ContentMatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public BodyMatchResult matchBody(@NotNull OptionalBody expected, @NotNull OptionalBody actual, @NotNull MatchingContext context) {
        BodyMatchResult bodyMatchResult;
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (expected.isMissing()) {
            bodyMatchResult = new BodyMatchResult(null, CollectionsKt.emptyList());
        } else if (expected.isPresent() && actual.isNotPresent()) {
            bodyMatchResult = new BodyMatchResult(null, CollectionsKt.listOf((Object)new BodyItemMatchResult("$", CollectionsKt.listOf((Object)new BodyMismatch(expected.orEmpty(), null, "Expected a multipart body but was missing", null, null, 24, null)))));
        } else if (expected.isEmpty() && actual.isEmpty()) {
            bodyMatchResult = new BodyMatchResult(null, CollectionsKt.emptyList());
        } else {
            BodyPart expectedMultipart = this.parseMultipart(expected.valueAsString(), expected.getContentType().toString());
            BodyPart actualMultipart = this.parseMultipart(actual.valueAsString(), actual.getContentType().toString());
            bodyMatchResult = new BodyMatchResult(null, CollectionsKt.plus((Collection)this.compareHeaders(expectedMultipart, actualMultipart, context), (Iterable)this.compareContents(expectedMultipart, actualMultipart, context)));
        }
        return bodyMatchResult;
    }

    @Override
    @NotNull
    public Result<List<InteractionContents>, String> setupBodyFromConfig(@NotNull Map<String, ? extends Object> bodyConfig) {
        Intrinsics.checkNotNullParameter(bodyConfig, (String)"bodyConfig");
        String string = String.valueOf(bodyConfig.get("body"));
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return (Result)new Result.Ok((Object)CollectionsKt.listOf((Object)new InteractionContents("", OptionalBody.Companion.body(byArray, new ContentType("multipart/form-data")), null, null, null, null, null, null, null, 508, null)));
    }

    private final List<BodyItemMatchResult> compareContents(BodyPart expectedMultipart, BodyPart actualMultipart, MatchingContext context) {
        List list;
        String expectedContents = ((Object)StringsKt.trim((CharSequence)expectedMultipart.getContent().toString())).toString();
        String actualContents = ((Object)StringsKt.trim((CharSequence)actualMultipart.getContent().toString())).toString();
        if (((CharSequence)expectedContents).length() == 0 && ((CharSequence)actualContents).length() == 0) {
            list = CollectionsKt.emptyList();
        } else if (((CharSequence)expectedContents).length() > 0 && ((CharSequence)actualContents).length() > 0) {
            list = CollectionsKt.emptyList();
        } else if (((CharSequence)expectedContents).length() == 0 && ((CharSequence)actualContents).length() > 0) {
            String string = actualContents;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            list = CollectionsKt.listOf((Object)new BodyItemMatchResult("$", CollectionsKt.listOf((Object)new BodyMismatch(expectedContents, actualContents, "Expected no contents, but received " + byArray.length + " bytes of content", null, null, 24, null))));
        } else {
            list = CollectionsKt.listOf((Object)new BodyItemMatchResult("$", CollectionsKt.listOf((Object)new BodyMismatch(expectedContents, actualContents, "Expected content with the multipart, but received no bytes of content", null, null, 24, null))));
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<BodyItemMatchResult> compareHeaders(BodyPart expectedMultipart, BodyPart actualMultipart, MatchingContext context) {
        void $this$forEach$iv;
        List mismatches2 = new ArrayList();
        Enumeration enumeration = expectedMultipart.getAllHeaders();
        Intrinsics.checkNotNull((Object)enumeration, (String)"null cannot be cast to non-null type java.util.Enumeration<javax.mail.Header>");
        Sequence sequence = SequencesKt.asSequence((Iterator)CollectionsKt.iterator((Enumeration)enumeration));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Header it = (Header)element$iv;
            boolean bl = false;
            Object[] header = actualMultipart.getHeader(it.getName());
            if (header != null) {
                String actualValue = ArraysKt.joinToString$default((Object[])header, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                if (Intrinsics.areEqual((Object)actualValue, (Object)it.getValue())) continue;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                mismatches2.add(new BodyItemMatchResult(string, CollectionsKt.listOf((Object)new BodyMismatch(it.toString(), null, "Expected a multipart header '" + it.getName() + "' with value '" + it.getValue() + "', but was '" + actualValue + "'", null, null, 24, null))));
                continue;
            }
            if (StringsKt.equals((String)it.getName(), (String)"Content-Type", (boolean)true)) {
                Companion.getLogger().debug((Function0)compareHeaders.1.1.INSTANCE);
                continue;
            }
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
            mismatches2.add(new BodyItemMatchResult(string, CollectionsKt.listOf((Object)new BodyMismatch(it.toString(), null, "Expected a multipart header '" + it.getName() + "', but was missing", null, null, 24, null))));
        }
        return mismatches2;
    }

    private final BodyPart parseMultipart(String body, String contentType) {
        MimeMultipart multipart = new MimeMultipart((DataSource)new ByteArrayDataSource(body, contentType));
        BodyPart bodyPart = multipart.getBodyPart(0);
        Intrinsics.checkNotNullExpressionValue((Object)bodyPart, (String)"multipart.getBodyPart(0)");
        return bodyPart;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lau/com/dius/pact/core/matchers/MultipartMessageContentMatcher$Companion;", "Lmu/KLogging;", "()V", "matchers"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

