/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.model;

import au.com.dius.pact.core.model.DefaultPactReader;
import au.com.dius.pact.core.model.DefaultPactWriter;
import au.com.dius.pact.core.model.FileSource;
import au.com.dius.pact.core.model.InvalidPactException;
import au.com.dius.pact.core.model.MergeResult;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.PactMerge;
import au.com.dius.pact.core.model.PactSpecVersion;
import au.com.dius.pact.core.model.PactWriteMode;
import au.com.dius.pact.core.model.PactWriter;
import au.com.dius.pact.core.model.V4Pact;
import au.com.dius.pact.core.support.Json;
import au.com.dius.pact.core.support.Result;
import au.com.dius.pact.core.support.json.JsonParser;
import au.com.dius.pact.core.support.json.JsonValue;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J$\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J,\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J,\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0016"}, d2={"Lau/com/dius/pact/core/model/DefaultPactWriter;", "Lau/com/dius/pact/core/model/PactWriter;", "Lmu/KLogging;", "()V", "pactWriteMode", "Lau/com/dius/pact/core/model/PactWriteMode;", "readFileUtf8", "", "file", "Ljava/io/RandomAccessFile;", "writePact", "Lau/com/dius/pact/core/support/Result;", "", "", "pact", "Lau/com/dius/pact/core/model/Pact;", "writer", "Ljava/io/PrintWriter;", "pactSpecVersion", "Lau/com/dius/pact/core/model/PactSpecVersion;", "pactFile", "Ljava/io/File;", "model"})
public final class DefaultPactWriter
extends KLogging
implements PactWriter {
    @NotNull
    public static final DefaultPactWriter INSTANCE = new DefaultPactWriter();

    private DefaultPactWriter() {
    }

    @Override
    @NotNull
    public Result<Integer, Throwable> writePact(@NotNull Pact pact, @NotNull PrintWriter writer, @NotNull PactSpecVersion pactSpecVersion) {
        Intrinsics.checkNotNullParameter((Object)pact, (String)"pact");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)((Object)pactSpecVersion), (String)"pactSpecVersion");
        String json2 = pactSpecVersion.compareTo((Enum)PactSpecVersion.V4) >= 0 ? Json.INSTANCE.prettyPrint(((V4Pact)pact.sortInteractions().asV4Pact().expect((Function0)writePact.json.1.INSTANCE)).toMap(pactSpecVersion)) : Json.INSTANCE.prettyPrint(pact.sortInteractions().toMap(pactSpecVersion));
        writer.println(json2);
        String string = json2;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return (Result)new Result.Ok((Object)byArray.length);
    }

    @Override
    @NotNull
    public Result<Integer, Throwable> writePact(@NotNull Pact pact, @NotNull PrintWriter writer) {
        Intrinsics.checkNotNullParameter((Object)pact, (String)"pact");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        return this.writePact(pact, writer, PactSpecVersion.V3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public synchronized Result<Integer, Throwable> writePact(@NotNull File pactFile, @NotNull Pact pact, @NotNull PactSpecVersion pactSpecVersion) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)pactFile, (String)"pactFile");
        Intrinsics.checkNotNullParameter((Object)pact, (String)"pact");
        Intrinsics.checkNotNullParameter((Object)((Object)pactSpecVersion), (String)"pactSpecVersion");
        if (this.pactWriteMode() == PactWriteMode.MERGE && pactFile.exists() && pactFile.length() > 0L) {
            FileSource source;
            RandomAccessFile raf = new RandomAccessFile(pactFile, "rw");
            FileLock lock = raf.getChannel().lock();
            try {
                source = new FileSource(pactFile, null, 2, null);
                JsonValue this_$iv = JsonParser.parseString((String)this.readFileUtf8(raf));
                boolean $i$f$downcast = false;
                if (!(this_$iv instanceof JsonValue.Object)) {
                    throw new UnsupportedOperationException("Can not downcast " + this_$iv.getName() + " to type " + Reflection.getOrCreateKotlinClass(JsonValue.Object.class));
                }
                JsonValue.Object json2 = (JsonValue.Object)this_$iv;
                Pact existingPact = DefaultPactReader.INSTANCE.pactFromJson(json2, source);
                MergeResult result2 = PactMerge.merge(pact, existingPact);
                if (!result2.getOk()) {
                    throw new InvalidPactException(result2.getMessage());
                }
                raf.seek(0L);
                StringWriter swriter = new StringWriter();
                PrintWriter writer = new PrintWriter(swriter);
                Pact pact2 = result2.getResult();
                Intrinsics.checkNotNull((Object)pact2);
                this.writePact(pact2, writer, pactSpecVersion);
                String string = swriter.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"swriter.toString()");
                String string2 = string;
                byte[] byArray = string2.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                byte[] bytes = byArray;
                raf.setLength(bytes.length);
                raf.write(bytes);
                source = new Result.Ok((Object)bytes.length);
            }
            finally {
                lock.release();
                raf.close();
            }
            result = (Result)source;
        } else {
            pactFile.getParentFile().mkdirs();
            Object object = pactFile;
            Object object2 = Charsets.UTF_8;
            File source = object;
            int json2 = 8192;
            Object object3 = source;
            object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
            object = new PrintWriter(object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, json2));
            object2 = null;
            try {
                PrintWriter it = (PrintWriter)object;
                boolean bl = false;
                Result result3 = INSTANCE.writePact(pact, it, pactSpecVersion);
                result = result3;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
        return result;
    }

    private final PactWriteMode pactWriteMode() {
        return Intrinsics.areEqual((Object)System.getProperty("pact.writer.overwrite"), (Object)"true") ? PactWriteMode.OVERWRITE : PactWriteMode.MERGE;
    }

    private final String readFileUtf8(RandomAccessFile file) {
        byte[] buffer = new byte[128];
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        file.seek(0L);
        int count = file.read(buffer);
        while (count > 0) {
            data.write(buffer, 0, count);
            count = file.read(buffer);
        }
        byte[] byArray = data.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"data.toByteArray()");
        byte[] byArray2 = byArray;
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(\"UTF-8\")");
        Charset charset2 = charset;
        return new String(byArray2, charset2);
    }
}

