/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.model;

import au.com.dius.pact.core.model.BaseRequest;
import au.com.dius.pact.core.model.ContentType;
import au.com.dius.pact.core.model.IHttpPart;
import au.com.dius.pact.core.model.IRequest;
import au.com.dius.pact.core.model.OptionalBody;
import au.com.dius.pact.core.model.PactReaderKt;
import au.com.dius.pact.core.model.PactSpecVersion;
import au.com.dius.pact.core.model.Request;
import au.com.dius.pact.core.model.V4HttpPartsKt;
import au.com.dius.pact.core.model.V4PactKt;
import au.com.dius.pact.core.model.generators.Category;
import au.com.dius.pact.core.model.generators.Generator;
import au.com.dius.pact.core.model.generators.GeneratorTestMode;
import au.com.dius.pact.core.model.generators.Generators;
import au.com.dius.pact.core.model.matchingrules.MatchingRules;
import au.com.dius.pact.core.model.matchingrules.MatchingRulesImpl;
import au.com.dius.pact.core.support.Json;
import au.com.dius.pact.core.support.json.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.apache.commons.beanutils.BeanUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 M2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001MBq\b\u0007\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u001a\b\u0002\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\t0\b\u0012\u001a\b\u0002\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\t0\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u0010&\u001a\u00020'H\u0016J\t\u0010(\u001a\u00020\u0005H\u00c6\u0003J\t\u0010)\u001a\u00020\u0005H\u00c6\u0003J\u001b\u0010*\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\t0\bH\u00c6\u0003J\u001b\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\t0\bH\u00c6\u0003J\t\u0010,\u001a\u00020\fH\u00c6\u0003J\t\u0010-\u001a\u00020\u000eH\u00c6\u0003J\t\u0010.\u001a\u00020\u0010H\u00c6\u0003J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u0016J\b\u00100\u001a\u00020\u0001H\u0016Js\u00100\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\u001a\b\u0002\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\t0\b2\u001a\b\u0002\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\t0\b2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u00c6\u0001J\u0013\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u000104H\u00d6\u0003J$\u00105\u001a\u00020\u00012\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002040\b2\u0006\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u0002022\u0006\u0010:\u001a\u00020\u0005H\u0016J\t\u0010;\u001a\u00020<H\u00d6\u0001J\u001a\u0010=\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\t0>H\u0016J\b\u0010?\u001a\u000202H\u0016J0\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020A0>2\u0006\u0010B\u001a\u00020C2\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002040>H\u0016J\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002040>J\t\u0010E\u001a\u00020\u0005H\u00d6\u0001J\u0006\u0010F\u001a\u00020'J\u001c\u0010G\u001a\u00020H2\u0014\u0010I\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u0001040>J\u0014\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010K\u001a\u00020LR\u001a\u0010\u000b\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R,\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\t0\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\u0006\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001f\"\u0004\b#\u0010!R,\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\t0\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0019\"\u0004\b%\u0010\u001b\u00a8\u0006N"}, d2={"Lau/com/dius/pact/core/model/HttpRequest;", "Lau/com/dius/pact/core/model/IRequest;", "Lau/com/dius/pact/core/model/IHttpPart;", "Lmu/KLogging;", "method", "", "path", "query", "", "", "headers", "body", "Lau/com/dius/pact/core/model/OptionalBody;", "matchingRules", "Lau/com/dius/pact/core/model/matchingrules/MatchingRules;", "generators", "Lau/com/dius/pact/core/model/generators/Generators;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;Lau/com/dius/pact/core/model/OptionalBody;Lau/com/dius/pact/core/model/matchingrules/MatchingRules;Lau/com/dius/pact/core/model/generators/Generators;)V", "getBody", "()Lau/com/dius/pact/core/model/OptionalBody;", "setBody", "(Lau/com/dius/pact/core/model/OptionalBody;)V", "getGenerators", "()Lau/com/dius/pact/core/model/generators/Generators;", "getHeaders", "()Ljava/util/Map;", "setHeaders", "(Ljava/util/Map;)V", "getMatchingRules", "()Lau/com/dius/pact/core/model/matchingrules/MatchingRules;", "getMethod", "()Ljava/lang/String;", "setMethod", "(Ljava/lang/String;)V", "getPath", "setPath", "getQuery", "setQuery", "asHttpPart", "Lau/com/dius/pact/core/model/Request;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "cookies", "copy", "equals", "", "other", "", "generatedRequest", "context", "mode", "Lau/com/dius/pact/core/model/generators/GeneratorTestMode;", "hasHeader", "name", "hashCode", "", "headersWithoutCookie", "", "isMultipartFileUpload", "setupGenerators", "Lau/com/dius/pact/core/model/generators/Generator;", "category", "Lau/com/dius/pact/core/model/generators/Category;", "toMap", "toString", "toV3Request", "updateProperties", "", "values", "validateForVersion", "pactVersion", "Lau/com/dius/pact/core/model/PactSpecVersion;", "Companion", "model"})
public final class HttpRequest
extends KLogging
implements IRequest,
IHttpPart {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String method;
    @NotNull
    private String path;
    @NotNull
    private Map<String, List<String>> query;
    @NotNull
    private Map<String, List<String>> headers;
    @NotNull
    private OptionalBody body;
    @NotNull
    private final MatchingRules matchingRules;
    @NotNull
    private final Generators generators;

    @JvmOverloads
    public HttpRequest(@NotNull String method, @NotNull String path, @NotNull Map<String, List<String>> query, @NotNull Map<String, List<String>> headers, @NotNull OptionalBody body, @NotNull MatchingRules matchingRules, @NotNull Generators generators) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)matchingRules, (String)"matchingRules");
        Intrinsics.checkNotNullParameter((Object)generators, (String)"generators");
        this.method = method;
        this.path = path;
        this.query = query;
        this.headers = headers;
        this.body = body;
        this.matchingRules = matchingRules;
        this.generators = generators;
    }

    public /* synthetic */ HttpRequest(String string, String string2, Map map, Map map2, OptionalBody optionalBody, MatchingRules matchingRules, Generators generators, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "GET";
        }
        if ((n & 2) != 0) {
            string2 = "/";
        }
        if ((n & 4) != 0) {
            map = new LinkedHashMap();
        }
        if ((n & 8) != 0) {
            map2 = new LinkedHashMap();
        }
        if ((n & 0x10) != 0) {
            optionalBody = OptionalBody.Companion.missing();
        }
        if ((n & 0x20) != 0) {
            matchingRules = new MatchingRulesImpl();
        }
        if ((n & 0x40) != 0) {
            generators = new Generators(null, 1, null);
        }
        this(string, string2, map, map2, optionalBody, matchingRules, generators);
    }

    @Override
    @NotNull
    public String getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.method = string;
    }

    @Override
    @NotNull
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.path = string;
    }

    @Override
    @NotNull
    public Map<String, List<String>> getQuery() {
        return this.query;
    }

    public void setQuery(@NotNull Map<String, List<String>> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.query = map;
    }

    @Override
    @NotNull
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void setHeaders(@NotNull Map<String, List<String>> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.headers = map;
    }

    @Override
    @NotNull
    public OptionalBody getBody() {
        return this.body;
    }

    @Override
    public void setBody(@NotNull OptionalBody optionalBody) {
        Intrinsics.checkNotNullParameter((Object)optionalBody, (String)"<set-?>");
        this.body = optionalBody;
    }

    @Override
    @NotNull
    public MatchingRules getMatchingRules() {
        return this.matchingRules;
    }

    @Override
    @NotNull
    public Generators getGenerators() {
        return this.generators;
    }

    @NotNull
    public final List<String> validateForVersion(@NotNull PactSpecVersion pactVersion) {
        Intrinsics.checkNotNullParameter((Object)((Object)pactVersion), (String)"pactVersion");
        List errors = new ArrayList();
        errors.addAll((Collection)this.getMatchingRules().validateForVersion(pactVersion));
        errors.addAll((Collection)this.getGenerators().validateForVersion(pactVersion));
        return errors;
    }

    @NotNull
    public final Request toV3Request() {
        return new Request(this.getMethod(), this.getPath(), MapsKt.toMutableMap(this.getQuery()), MapsKt.toMutableMap(this.getHeaders()), this.getBody(), this.getMatchingRules(), this.getGenerators());
    }

    @NotNull
    public final Map<String, Object> toMap() {
        Pair[] pairArray = new Pair[2];
        String string = this.getMethod().toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase()");
        pairArray[0] = TuplesKt.to((Object)"method", (Object)string);
        pairArray[1] = TuplesKt.to((Object)"path", (Object)this.getPath());
        Map map = MapsKt.mutableMapOf((Pair[])pairArray);
        if (!this.getHeaders().isEmpty()) {
            map.put("headers", this.getHeaders());
        }
        if (!this.getQuery().isEmpty()) {
            map.put("query", this.getQuery());
        }
        if (this.getBody().isPresent() || this.getBody().isEmpty()) {
            map.put("body", this.getBody().toV4Format());
        }
        if (this.getMatchingRules().isNotEmpty()) {
            map.put("matchingRules", this.getMatchingRules().toMap(PactSpecVersion.V4));
        }
        if (this.getGenerators().isNotEmpty()) {
            map.put("generators", this.getGenerators().toMap(PactSpecVersion.V4));
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> cookies() {
        List list;
        Object v1;
        block5: {
            Iterable iterable = this.getHeaders().entrySet();
            for (Object t : iterable) {
                Map.Entry entry = (Map.Entry)t;
                boolean bl = false;
                String k = (String)entry.getKey();
                String string = k.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
                if (!Intrinsics.areEqual((Object)string, (Object)"cookie")) continue;
                v1 = t;
                break block5;
            }
            v1 = null;
        }
        Map.Entry cookieEntry = v1;
        if (cookieEntry != null) {
            void $this$mapTo$iv$iv;
            Object list$iv$iv;
            String it;
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = (Iterable)cookieEntry.getValue();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                char[] cArray = new char[]{';'};
                list$iv$iv = StringsKt.split$default((CharSequence)it, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                list$iv$iv = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public Request asHttpPart() {
        return this.toV3Request();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, List<String>> headersWithoutCookie() {
        void $this$filterTo$iv$iv;
        Map<String, List<String>> $this$filter$iv = this.getHeaders();
        boolean $i$f$filter = false;
        Map<String, List<String>> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            String k = (String)entry.getKey();
            String string = k.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
            if (!(!Intrinsics.areEqual((Object)string, (Object)"cookie"))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    @Override
    @NotNull
    public IRequest generatedRequest(@NotNull Map<String, Object> context, @NotNull GeneratorTestMode mode) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        return this.toV3Request().generatedRequest(context, mode);
    }

    @Override
    public boolean isMultipartFileUpload() {
        return this.asHttpPart().isMultipartFileUpload();
    }

    @Override
    @NotNull
    public IRequest copy() {
        return HttpRequest.copy$default(this, null, null, null, null, OptionalBody.copy$default(this.getBody(), null, null, null, null, 15, null), this.getMatchingRules().copy(), Generators.copy$default(this.getGenerators(), null, 1, null), 15, null);
    }

    @Override
    public boolean hasHeader(@NotNull String name) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Map<String, List<String>> $this$any$iv = this.getHeaders();
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<String, List<String>>> iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, List<String>> element$iv;
                    Map.Entry<String, List<String>> entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    String key = entry.getKey();
                    String string = key.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    if (!Intrinsics.areEqual((Object)string, (Object)name)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Map<String, Generator> setupGenerators(@NotNull Category category, @NotNull Map<String, ? extends Object> context) {
        Intrinsics.checkNotNullParameter((Object)((Object)category), (String)"category");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Map map = this.getGenerators().getCategories().get((Object)category);
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map generators = map;
        MatchingRules matchingRules = this.getMatchingRules();
        String string = category.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        Map<String, Generator> matchingRuleGenerators = matchingRules.rulesForCategory(string).generators(context);
        return MapsKt.plus((Map)generators, matchingRuleGenerators);
    }

    /*
     * WARNING - void declaration
     */
    public final void updateProperties(@NotNull Map<String, ? extends Object> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.getLogger().debug((Function0)new Function0<Object>(values){
            final /* synthetic */ Map<String, Object> $values;
            {
                this.$values = $values;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "updateProperties(values=" + this.$values + ")";
            }
        });
        Map<String, ? extends Object> $this$forEach$iv = values;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends Object>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object destination$iv$iv;
            Object object;
            Iterator iterator2;
            Map.Entry<String, ? extends Object> element$iv;
            Map.Entry<String, ? extends Object> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            Object value = entry.getValue();
            String string = key;
            if (Intrinsics.areEqual((Object)string, (Object)"headers")) {
                if (value instanceof Map) {
                    void $this$mapValuesTo$iv$iv;
                    void $this$mapValues$iv;
                    Object object2;
                    Object it;
                    Map map;
                    void $this$mapKeysTo$iv$iv;
                    Map $this$mapKeys$iv;
                    Map map2 = (Map)value;
                    HttpRequest httpRequest = this;
                    boolean $i$f$mapKeys = false;
                    iterator2 = $this$mapKeys$iv;
                    Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
                    boolean $i$f$mapKeysTo = false;
                    Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
                    boolean $i$f$associateByTo = false;
                    for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                        void it$iv$iv;
                        object = (Map.Entry)element$iv$iv$iv;
                        map = destination$iv$iv2;
                        boolean bl2 = false;
                        Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                        object2 = String.valueOf(it.getKey());
                        Map map3 = map;
                        boolean bl3 = false;
                        it = it$iv$iv.getValue();
                        map3.put(object2, it);
                    }
                    $this$mapKeys$iv = destination$iv$iv2;
                    boolean $i$f$mapValues = false;
                    $this$mapKeysTo$iv$iv = $this$mapValues$iv;
                    destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                    boolean $i$f$mapValuesTo = false;
                    $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                    $i$f$associateByTo = false;
                    for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                        List list;
                        void it$iv$iv;
                        it = (Map.Entry)element$iv$iv$iv;
                        Map bl2 = destination$iv$iv2;
                        boolean bl4 = false;
                        object2 = (Map.Entry)element$iv$iv$iv;
                        Object k = it$iv$iv.getKey();
                        map = bl2;
                        boolean bl5 = false;
                        Object headerValue = object2.getValue();
                        if (headerValue instanceof List) {
                            void $this$mapTo$iv$iv;
                            Iterable $this$map$iv = (Iterable)headerValue;
                            boolean $i$f$map = false;
                            Iterable iterable = $this$map$iv;
                            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            Iterator iterator3 = $this$mapTo$iv$iv.iterator();
                            while (iterator3.hasNext()) {
                                void it2;
                                Object item$iv$iv;
                                Object t = item$iv$iv = iterator3.next();
                                Object object3 = destination$iv$iv;
                                boolean bl6 = false;
                                object3.add((String)String.valueOf(it2));
                            }
                            list = (List)destination$iv$iv;
                        } else {
                            list = CollectionsKt.listOf((Object)String.valueOf(headerValue));
                        }
                        List list2 = list;
                        map.put(k, list2);
                    }
                    httpRequest.setHeaders(MapsKt.toMutableMap((Map)destination$iv$iv2));
                    continue;
                }
                throw new IllegalArgumentException(value + " is not a valid value for headers");
            }
            if (Intrinsics.areEqual((Object)string, (Object)"query")) {
                Object object4 = value;
                if (object4 instanceof Map) {
                    Map $this$forEach$iv2 = (Map)value;
                    boolean $i$f$forEach2 = false;
                    iterator2 = $this$forEach$iv2.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry element$iv2;
                        Map.Entry entry3 = element$iv2 = iterator2.next();
                        boolean bl7 = false;
                        Object name = entry3.getKey();
                        Object queryValue = entry3.getValue();
                        String queryName = String.valueOf(name);
                        if (!this.getQuery().containsKey(queryName)) {
                            this.getQuery().put(queryName, new ArrayList());
                        }
                        if (queryValue instanceof List) {
                            void $this$mapTo$iv$iv;
                            void $this$map$iv;
                            object = this.getQuery();
                            List<String> list = this.getQuery().get(queryName);
                            Intrinsics.checkNotNull(list);
                            Iterable bl2 = (Iterable)queryValue;
                            Collection collection = list;
                            boolean $i$f$map = false;
                            void bl5 = $this$map$iv;
                            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                destination$iv$iv = item$iv$iv;
                                Collection collection2 = destination$iv$iv3;
                                boolean bl8 = false;
                                collection2.add(String.valueOf(it));
                            }
                            List list3 = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv3));
                            object.put(queryName, list3);
                            continue;
                        }
                        Map<String, List<String>> map = this.getQuery();
                        List<String> list = this.getQuery().get(queryName);
                        Intrinsics.checkNotNull(list);
                        map.put(queryName, CollectionsKt.plus((Collection)list, (Object)String.valueOf(queryValue)));
                    }
                    continue;
                }
                if (object4 instanceof String) {
                    this.getQuery().putAll(PactReaderKt.queryStringToMap$default(((String)value).toString(), false, 2, null));
                    continue;
                }
                throw new IllegalArgumentException(value + " is not a valid value for query parameters");
            }
            BeanUtils.setProperty((Object)this, (String)key, (Object)value);
        }
    }

    @Override
    @NotNull
    public ContentType determineContentType() {
        return IRequest.DefaultImpls.determineContentType(this);
    }

    @Override
    @Nullable
    public String contentTypeHeader() {
        return IRequest.DefaultImpls.contentTypeHeader(this);
    }

    @NotNull
    public final String component1() {
        return this.getMethod();
    }

    @NotNull
    public final String component2() {
        return this.getPath();
    }

    @NotNull
    public final Map<String, List<String>> component3() {
        return this.getQuery();
    }

    @NotNull
    public final Map<String, List<String>> component4() {
        return this.getHeaders();
    }

    @NotNull
    public final OptionalBody component5() {
        return this.getBody();
    }

    @NotNull
    public final MatchingRules component6() {
        return this.getMatchingRules();
    }

    @NotNull
    public final Generators component7() {
        return this.getGenerators();
    }

    @NotNull
    public final HttpRequest copy(@NotNull String method, @NotNull String path, @NotNull Map<String, List<String>> query, @NotNull Map<String, List<String>> headers, @NotNull OptionalBody body, @NotNull MatchingRules matchingRules, @NotNull Generators generators) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)matchingRules, (String)"matchingRules");
        Intrinsics.checkNotNullParameter((Object)generators, (String)"generators");
        return new HttpRequest(method, path, query, headers, body, matchingRules, generators);
    }

    public static /* synthetic */ HttpRequest copy$default(HttpRequest httpRequest, String string, String string2, Map map, Map map2, OptionalBody optionalBody, MatchingRules matchingRules, Generators generators, int n, Object object) {
        if ((n & 1) != 0) {
            string = httpRequest.getMethod();
        }
        if ((n & 2) != 0) {
            string2 = httpRequest.getPath();
        }
        if ((n & 4) != 0) {
            map = httpRequest.getQuery();
        }
        if ((n & 8) != 0) {
            map2 = httpRequest.getHeaders();
        }
        if ((n & 0x10) != 0) {
            optionalBody = httpRequest.getBody();
        }
        if ((n & 0x20) != 0) {
            matchingRules = httpRequest.getMatchingRules();
        }
        if ((n & 0x40) != 0) {
            generators = httpRequest.getGenerators();
        }
        return httpRequest.copy(string, string2, map, map2, optionalBody, matchingRules, generators);
    }

    @NotNull
    public String toString() {
        return "HttpRequest(method=" + this.getMethod() + ", path=" + this.getPath() + ", query=" + this.getQuery() + ", headers=" + this.getHeaders() + ", body=" + this.getBody() + ", matchingRules=" + this.getMatchingRules() + ", generators=" + this.getGenerators() + ")";
    }

    public int hashCode() {
        int result = this.getMethod().hashCode();
        result = result * 31 + this.getPath().hashCode();
        result = result * 31 + ((Object)this.getQuery()).hashCode();
        result = result * 31 + ((Object)this.getHeaders()).hashCode();
        result = result * 31 + this.getBody().hashCode();
        result = result * 31 + this.getMatchingRules().hashCode();
        result = result * 31 + this.getGenerators().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpRequest)) {
            return false;
        }
        HttpRequest httpRequest = (HttpRequest)other;
        if (!Intrinsics.areEqual((Object)this.getMethod(), (Object)httpRequest.getMethod())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getPath(), (Object)httpRequest.getPath())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getQuery(), httpRequest.getQuery())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getHeaders(), httpRequest.getHeaders())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getBody(), (Object)httpRequest.getBody())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getMatchingRules(), (Object)httpRequest.getMatchingRules())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getGenerators(), (Object)httpRequest.getGenerators());
    }

    @JvmOverloads
    public HttpRequest(@NotNull String method, @NotNull String path, @NotNull Map<String, List<String>> query, @NotNull Map<String, List<String>> headers, @NotNull OptionalBody body, @NotNull MatchingRules matchingRules) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)matchingRules, (String)"matchingRules");
        this(method, path, query, headers, body, matchingRules, null, 64, null);
    }

    @JvmOverloads
    public HttpRequest(@NotNull String method, @NotNull String path, @NotNull Map<String, List<String>> query, @NotNull Map<String, List<String>> headers, @NotNull OptionalBody body) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        this(method, path, query, headers, body, null, null, 96, null);
    }

    @JvmOverloads
    public HttpRequest(@NotNull String method, @NotNull String path, @NotNull Map<String, List<String>> query, @NotNull Map<String, List<String>> headers) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        this(method, path, query, headers, null, null, null, 112, null);
    }

    @JvmOverloads
    public HttpRequest(@NotNull String method, @NotNull String path, @NotNull Map<String, List<String>> query) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        this(method, path, query, null, null, null, null, 120, null);
    }

    @JvmOverloads
    public HttpRequest(@NotNull String method, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this(method, path, null, null, null, null, null, 124, null);
    }

    @JvmOverloads
    public HttpRequest(@NotNull String method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        this(method, null, null, null, null, null, null, 126, null);
    }

    @JvmOverloads
    public HttpRequest() {
        this(null, null, null, null, null, null, null, 127, null);
    }

    @JvmStatic
    @NotNull
    public static final HttpRequest fromJson(@NotNull JsonValue json2) {
        return Companion.fromJson(json2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lau/com/dius/pact/core/model/HttpRequest$Companion;", "", "()V", "fromJson", "Lau/com/dius/pact/core/model/HttpRequest;", "json", "Lau/com/dius/pact/core/support/json/JsonValue;", "model"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final HttpRequest fromJson(@NotNull JsonValue json2) {
            String string;
            Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
            if (json2.has("method")) {
                String string2 = Json.INSTANCE.toString(json2.get((Object)"method")).toUpperCase();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase()");
            } else {
                string = "GET";
            }
            String method = string;
            String path = json2.has("path") ? Json.INSTANCE.toString(json2.get((Object)"path")) : "/";
            Map<String, List<String>> query = BaseRequest.Companion.parseQueryParametersToMap(json2.get((Object)"query"));
            Map headers = V4HttpPartsKt.access$headersFromJson(json2);
            OptionalBody body = V4PactKt.bodyFromJson("body", json2, headers);
            MatchingRules matchingRules = json2.has("matchingRules") && json2.get((Object)"matchingRules") instanceof JsonValue.Object ? MatchingRulesImpl.Companion.fromJson(json2.get((Object)"matchingRules")) : (MatchingRules)new MatchingRulesImpl();
            Generators generators = json2.has("generators") && json2.get((Object)"generators") instanceof JsonValue.Object ? Generators.Companion.fromJson(json2.get((Object)"generators")) : new Generators(null, 1, null);
            return new HttpRequest(method, path, MapsKt.toMutableMap(query), MapsKt.toMutableMap((Map)headers), body, matchingRules, generators);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

