/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.model;

import au.com.dius.pact.core.model.ContentType;
import au.com.dius.pact.core.model.ContentTypeHint;
import au.com.dius.pact.core.model.OptionalBody;
import au.com.dius.pact.core.model.UnwrapMissingBodyException;
import au.com.dius.pact.core.support.json.JsonParser;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import mu.KLogging;
import org.apache.commons.codec.binary.Hex;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.mime.MediaType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\b\u0086\b\u0018\u0000 42\u00020\u0001:\u000245B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c6\u0003J3\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\b\u0010\u001c\u001a\u0004\u0018\u00010\u0007J\b\u0010\u001d\u001a\u0004\u0018\u00010\u0007J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010!\u001a\u00020\"H\u0016J\u0006\u0010#\u001a\u00020\u001fJ\u0006\u0010$\u001a\u00020\u001fJ\u0006\u0010%\u001a\u00020\u001fJ\u0006\u0010&\u001a\u00020\u001fJ\u0006\u0010'\u001a\u00020\u001fJ\u000e\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0005J\u0006\u0010*\u001a\u00020\u0005J\u000e\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\"J\b\u0010-\u001a\u00020.H\u0016J\u0014\u0010/\u001a\u0010\u0012\u0004\u0012\u00020.\u0012\u0006\u0012\u0004\u0018\u00010\u000100J\u0006\u00101\u001a\u00020\u0005J\u0006\u00102\u001a\u00020.J\u0006\u00103\u001a\u00020.R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00066"}, d2={"Lau/com/dius/pact/core/model/OptionalBody;", "", "state", "Lau/com/dius/pact/core/model/OptionalBody$State;", "value", "", "contentType", "Lau/com/dius/pact/core/model/ContentType;", "contentTypeHint", "Lau/com/dius/pact/core/model/ContentTypeHint;", "(Lau/com/dius/pact/core/model/OptionalBody$State;[BLau/com/dius/pact/core/model/ContentType;Lau/com/dius/pact/core/model/ContentTypeHint;)V", "getContentType", "()Lau/com/dius/pact/core/model/ContentType;", "setContentType", "(Lau/com/dius/pact/core/model/ContentType;)V", "getContentTypeHint", "()Lau/com/dius/pact/core/model/ContentTypeHint;", "setContentTypeHint", "(Lau/com/dius/pact/core/model/ContentTypeHint;)V", "getState", "()Lau/com/dius/pact/core/model/OptionalBody$State;", "getValue", "()[B", "component1", "component2", "component3", "component4", "copy", "detectContentType", "detectStandardTextContentType", "equals", "", "other", "hashCode", "", "isEmpty", "isMissing", "isNotPresent", "isNull", "isPresent", "orElse", "defaultValue", "orEmpty", "slice", "size", "toString", "", "toV4Format", "", "unwrap", "valueAsBase64", "valueAsString", "Companion", "State", "model"})
public final class OptionalBody {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final State state;
    @Nullable
    private final byte[] value;
    @NotNull
    private ContentType contentType;
    @NotNull
    private ContentTypeHint contentTypeHint;
    @Nullable
    private static final TikaConfig tika;

    @JvmOverloads
    public OptionalBody(@NotNull State state, @Nullable byte[] value, @NotNull ContentType contentType, @NotNull ContentTypeHint contentTypeHint) {
        ContentType detectedContentType;
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)((Object)contentTypeHint), (String)"contentTypeHint");
        this.state = state;
        this.value = value;
        this.contentType = contentType;
        this.contentTypeHint = contentTypeHint;
        if (Intrinsics.areEqual((Object)this.contentType, (Object)ContentType.Companion.getUNKNOWN()) && (detectedContentType = this.detectContentType()) != null) {
            this.contentType = detectedContentType;
        }
    }

    public /* synthetic */ OptionalBody(State state, byte[] byArray, ContentType contentType, ContentTypeHint contentTypeHint, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            byArray = null;
        }
        if ((n & 4) != 0) {
            contentType = ContentType.Companion.getUNKNOWN();
        }
        if ((n & 8) != 0) {
            contentTypeHint = ContentTypeHint.DEFAULT;
        }
        this(state, byArray, contentType, contentTypeHint);
    }

    @NotNull
    public final State getState() {
        return this.state;
    }

    @Nullable
    public final byte[] getValue() {
        return this.value;
    }

    @NotNull
    public final ContentType getContentType() {
        return this.contentType;
    }

    public final void setContentType(@NotNull ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"<set-?>");
        this.contentType = contentType;
    }

    @NotNull
    public final ContentTypeHint getContentTypeHint() {
        return this.contentTypeHint;
    }

    public final void setContentTypeHint(@NotNull ContentTypeHint contentTypeHint) {
        Intrinsics.checkNotNullParameter((Object)((Object)contentTypeHint), (String)"<set-?>");
        this.contentTypeHint = contentTypeHint;
    }

    public final boolean isMissing() {
        return this.state == State.MISSING;
    }

    public final boolean isEmpty() {
        return this.state == State.EMPTY;
    }

    public final boolean isNull() {
        return this.state == State.NULL;
    }

    public final boolean isPresent() {
        return this.state == State.PRESENT;
    }

    public final boolean isNotPresent() {
        return this.state != State.PRESENT;
    }

    @NotNull
    public final byte[] orElse(@NotNull byte[] defaultValue) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        if (this.state == State.EMPTY || this.state == State.PRESENT) {
            byArray = this.value;
            Intrinsics.checkNotNull((Object)this.value);
        } else {
            byArray = defaultValue;
        }
        return byArray;
    }

    @NotNull
    public final byte[] orEmpty() {
        return this.orElse(new byte[0]);
    }

    @NotNull
    public final byte[] unwrap() {
        if (this.isPresent() || this.isEmpty()) {
            Intrinsics.checkNotNull((Object)this.value);
            return this.value;
        }
        throw new UnwrapMissingBodyException("Failed to unwrap value from a " + this.state + " body");
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type au.com.dius.pact.core.model.OptionalBody");
        OptionalBody cfr_ignored_0 = (OptionalBody)other;
        if (this.state != ((OptionalBody)other).state) {
            return false;
        }
        if (this.value != null) {
            if (((OptionalBody)other).value == null) {
                return false;
            }
            if (!Arrays.equals(this.value, ((OptionalBody)other).value)) {
                return false;
            }
        } else if (((OptionalBody)other).value != null) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.state.hashCode();
        result = 31 * result + (this.value != null ? Arrays.hashCode(this.value) : 0);
        return result;
    }

    @NotNull
    public String toString() {
        Object object;
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                if (this.contentTypeHint == ContentTypeHint.BINARY || this.contentType.isBinaryType()) {
                    Intrinsics.checkNotNull((Object)this.value);
                    object = "PRESENT(" + this.value.length + " bytes starting with " + Hex.encodeHexString((byte[])this.slice(16)) + "...)";
                    break;
                }
                Intrinsics.checkNotNull((Object)this.value);
                object = "PRESENT(" + new String(this.value, this.contentType.asCharset()) + ")";
                break;
            }
            case 2: {
                object = "EMPTY";
                break;
            }
            case 3: {
                object = "NULL";
                break;
            }
            case 4: {
                object = "MISSING";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return object;
    }

    @NotNull
    public final String valueAsString() {
        String string;
        if (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()] == 1) {
            Intrinsics.checkNotNull((Object)this.value);
            string = new String(this.value, this.contentType.asCharset());
        } else {
            string = "";
        }
        return string;
    }

    @Nullable
    public final ContentType detectContentType() {
        ContentType contentType;
        if (this.isPresent()) {
            if (tika != null) {
                org.apache.tika.metadata.Metadata metadata2 = new org.apache.tika.metadata.Metadata();
                Detector detector = tika.getDetector();
                Intrinsics.checkNotNull((Object)this.value);
                MediaType mimetype = detector.detect((InputStream)TikaInputStream.get((byte[])this.value), metadata2);
                if (Intrinsics.areEqual((Object)mimetype.getBaseType().getType(), (Object)"text")) {
                    contentType = this.detectStandardTextContentType();
                    if (contentType == null) {
                        contentType = new ContentType(mimetype);
                    }
                } else {
                    contentType = new ContentType(mimetype);
                }
            } else {
                contentType = this.detectStandardTextContentType();
            }
        } else {
            contentType = null;
        }
        return contentType;
    }

    @Nullable
    public final ContentType detectStandardTextContentType() {
        ContentType contentType;
        if (this.isPresent()) {
            Intrinsics.checkNotNull((Object)this.value);
            contentType = Companion.detectContentTypeInByteArray(this.value);
        } else {
            contentType = null;
        }
        return contentType;
    }

    @NotNull
    public final String valueAsBase64() {
        String string;
        if (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()] == 1) {
            Base64.Encoder encoder = Base64.getEncoder();
            Intrinsics.checkNotNull((Object)this.value);
            String string2 = encoder.encodeToString(this.value);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getEncoder().encodeToString(value!!)");
        } else {
            string = "";
        }
        return string;
    }

    @NotNull
    public final byte[] slice(int size2) {
        byte[] byArray;
        if (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()] == 1) {
            Intrinsics.checkNotNull((Object)this.value);
            if (this.value.length > size2) {
                byte[] byArray2 = Arrays.copyOf(this.value, size2);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(this, newSize)");
            } else {
                byArray = this.value;
            }
        } else {
            byArray = new byte[]{};
        }
        return byArray;
    }

    @NotNull
    public final Map<String, Object> toV4Format() {
        Map map;
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull((Object)this.value);
                if (!(this.value.length == 0)) {
                    if (this.contentType.isJson()) {
                        if (this.contentTypeHint == ContentTypeHint.BINARY) {
                            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"content", (Object)this.valueAsString()), TuplesKt.to((Object)"contentType", (Object)this.contentType.toString()), TuplesKt.to((Object)"encoded", (Object)"JSON")};
                            map = MapsKt.mapOf((Pair[])pairArray);
                            break;
                        }
                        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"content", (Object)JsonParser.parseString((String)this.valueAsString())), TuplesKt.to((Object)"contentType", (Object)this.contentType.toString()), TuplesKt.to((Object)"encoded", (Object)false)};
                        map = MapsKt.mapOf((Pair[])pairArray);
                        break;
                    }
                    if (this.contentTypeHint == ContentTypeHint.BINARY || this.contentType.isBinaryType()) {
                        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"content", (Object)this.valueAsBase64()), TuplesKt.to((Object)"contentType", (Object)this.contentType.toString()), TuplesKt.to((Object)"encoded", (Object)"base64"), TuplesKt.to((Object)"contentTypeHint", (Object)this.contentTypeHint.name())};
                        map = MapsKt.mapOf((Pair[])pairArray);
                        break;
                    }
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"content", (Object)this.valueAsString()), TuplesKt.to((Object)"contentType", (Object)this.contentType.toString()), TuplesKt.to((Object)"encoded", (Object)false), TuplesKt.to((Object)"contentTypeHint", (Object)this.contentTypeHint.name())};
                    map = MapsKt.mapOf((Pair[])pairArray);
                    break;
                }
                map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"content", (Object)""));
                break;
            }
            case 2: {
                map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"content", (Object)""));
                break;
            }
            default: {
                map = MapsKt.emptyMap();
            }
        }
        return map;
    }

    @NotNull
    public final State component1() {
        return this.state;
    }

    @Nullable
    public final byte[] component2() {
        return this.value;
    }

    @NotNull
    public final ContentType component3() {
        return this.contentType;
    }

    @NotNull
    public final ContentTypeHint component4() {
        return this.contentTypeHint;
    }

    @NotNull
    public final OptionalBody copy(@NotNull State state, @Nullable byte[] value, @NotNull ContentType contentType, @NotNull ContentTypeHint contentTypeHint) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)((Object)contentTypeHint), (String)"contentTypeHint");
        return new OptionalBody(state, value, contentType, contentTypeHint);
    }

    public static /* synthetic */ OptionalBody copy$default(OptionalBody optionalBody, State state, byte[] byArray, ContentType contentType, ContentTypeHint contentTypeHint, int n, Object object) {
        if ((n & 1) != 0) {
            state = optionalBody.state;
        }
        if ((n & 2) != 0) {
            byArray = optionalBody.value;
        }
        if ((n & 4) != 0) {
            contentType = optionalBody.contentType;
        }
        if ((n & 8) != 0) {
            contentTypeHint = optionalBody.contentTypeHint;
        }
        return optionalBody.copy(state, byArray, contentType, contentTypeHint);
    }

    @JvmOverloads
    public OptionalBody(@NotNull State state, @Nullable byte[] value, @NotNull ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this(state, value, contentType, null, 8, null);
    }

    @JvmOverloads
    public OptionalBody(@NotNull State state, @Nullable byte[] value) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this(state, value, null, null, 12, null);
    }

    @JvmOverloads
    public OptionalBody(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this(state, null, null, null, 14, null);
    }

    @JvmStatic
    @NotNull
    public static final OptionalBody missing() {
        return Companion.missing();
    }

    @JvmStatic
    @NotNull
    public static final OptionalBody empty() {
        return Companion.empty();
    }

    @JvmStatic
    @NotNull
    public static final OptionalBody nullBody() {
        return Companion.nullBody();
    }

    @JvmStatic
    @NotNull
    public static final OptionalBody body(@Nullable byte[] body) {
        return Companion.body(body);
    }

    @JvmStatic
    @NotNull
    public static final OptionalBody body(@Nullable byte[] body, @NotNull ContentType contentType) {
        return Companion.body(body, contentType);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final OptionalBody body(@Nullable String body, @NotNull ContentType contentType) {
        return Companion.body(body, contentType);
    }

    @JvmStatic
    @NotNull
    public static final OptionalBody body(@Nullable byte[] body, @NotNull ContentType contentType, @NotNull ContentTypeHint contentTypeHint) {
        return Companion.body(body, contentType, contentTypeHint);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final OptionalBody body(@Nullable String body) {
        return Companion.body(body);
    }

    static {
        TikaConfig tikaConfig;
        Companion = new Companion(null);
        try {
            tikaConfig = new TikaConfig();
        }
        catch (RuntimeException e) {
            Companion.getLogger().warn((Throwable)e, (Function0)Companion.tika.1.INSTANCE);
            tikaConfig = null;
        }
        tika = tikaConfig;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lau/com/dius/pact/core/model/OptionalBody$State;", "", "(Ljava/lang/String;I)V", "MISSING", "EMPTY", "NULL", "PRESENT", "model"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State MISSING = new State();
        public static final /* enum */ State EMPTY = new State();
        public static final /* enum */ State NULL = new State();
        public static final /* enum */ State PRESENT = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        static {
            $VALUES = stateArray = new State[]{State.MISSING, State.EMPTY, State.NULL, State.PRESENT};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\bH\u0007J\u001a\u0010\u0006\u001a\u00020\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\"\u0010\u0006\u001a\u00020\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u001c\u0010\u0006\u001a\u00020\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\bJ\b\u0010\u0010\u001a\u00020\u0007H\u0007J\b\u0010\u0011\u001a\u00020\u0007H\u0007J\b\u0010\u0012\u001a\u00020\u0007H\u0007R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\u0013"}, d2={"Lau/com/dius/pact/core/model/OptionalBody$Companion;", "Lmu/KLogging;", "()V", "tika", "Lorg/apache/tika/config/TikaConfig;", "getTika$annotations", "body", "Lau/com/dius/pact/core/model/OptionalBody;", "", "contentType", "Lau/com/dius/pact/core/model/ContentType;", "contentTypeHint", "Lau/com/dius/pact/core/model/ContentTypeHint;", "", "detectContentTypeInByteArray", "value", "empty", "missing", "nullBody", "model"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final OptionalBody missing() {
            return new OptionalBody(State.MISSING, null, null, null, 14, null);
        }

        @JvmStatic
        @NotNull
        public final OptionalBody empty() {
            return new OptionalBody(State.EMPTY, new byte[0], null, null, 12, null);
        }

        @JvmStatic
        @NotNull
        public final OptionalBody nullBody() {
            return new OptionalBody(State.NULL, null, null, null, 14, null);
        }

        @JvmStatic
        @NotNull
        public final OptionalBody body(@Nullable byte[] body) {
            return this.body(body, ContentType.Companion.getUNKNOWN(), ContentTypeHint.DEFAULT);
        }

        @JvmStatic
        @NotNull
        public final OptionalBody body(@Nullable byte[] body, @NotNull ContentType contentType) {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            return this.body(body, contentType, ContentTypeHint.DEFAULT);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final OptionalBody body(@Nullable String body, @NotNull ContentType contentType) {
            byte[] byArray;
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            String string = body;
            if (string != null) {
                String string2 = string;
                byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
            } else {
                byArray = null;
            }
            return this.body(byArray, contentType, ContentTypeHint.DEFAULT);
        }

        public static /* synthetic */ OptionalBody body$default(Companion companion, String string, ContentType contentType, int n, Object object) {
            if ((n & 2) != 0) {
                contentType = ContentType.Companion.getUNKNOWN();
            }
            return companion.body(string, contentType);
        }

        @JvmStatic
        @NotNull
        public final OptionalBody body(@Nullable byte[] body, @NotNull ContentType contentType, @NotNull ContentTypeHint contentTypeHint) {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            Intrinsics.checkNotNullParameter((Object)((Object)contentTypeHint), (String)"contentTypeHint");
            return body == null ? this.nullBody() : (body.length == 0 ? this.empty() : new OptionalBody(State.PRESENT, body, contentType, contentTypeHint));
        }

        private static /* synthetic */ void getTika$annotations() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final ContentType detectContentTypeInByteArray(@NotNull byte[] value) {
            ContentType contentType;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            int newLine = 10;
            int cReturn = 13;
            Iterable $this$map$iv = ArraysKt.take((byte[])value, (int)32);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                byte by = ((Number)item$iv$iv).byteValue();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Character.valueOf(it == newLine || it == cReturn ? (char)' ' : (char)it));
            }
            String s = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            CharSequence charSequence = s;
            if (ContentType.Companion.getXMLREGEXP().matches(charSequence)) {
                contentType = ContentType.Companion.getXML();
            } else {
                String string = s.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                charSequence = string;
                if (ContentType.Companion.getHTMLREGEXP().matches(charSequence)) {
                    contentType = ContentType.Companion.getHTML();
                } else {
                    charSequence = s;
                    if (ContentType.Companion.getJSONREGEXP().matches(charSequence)) {
                        contentType = ContentType.Companion.getJSON();
                    } else {
                        charSequence = s;
                        contentType = ContentType.Companion.getXMLREGEXP2().matches(charSequence) ? ContentType.Companion.getXML() : null;
                    }
                }
            }
            return contentType;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final OptionalBody body(@Nullable String body) {
            return au.com.dius.pact.core.model.OptionalBody$Companion.body$default(this, body, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.PRESENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.EMPTY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.NULL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.MISSING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

