/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.model;

import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.MergeResult;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.support.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00050\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0004H\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0007\u00a8\u0006\u000e"}, d2={"Lau/com/dius/pact/core/model/PactMerge;", "Lmu/KLogging;", "()V", "cartesianProduct", "", "Lkotlin/Pair;", "Lau/com/dius/pact/core/model/Interaction;", "list1", "list2", "merge", "Lau/com/dius/pact/core/model/MergeResult;", "newPact", "Lau/com/dius/pact/core/model/Pact;", "existing", "model"})
public final class PactMerge
extends KLogging {
    @NotNull
    public static final PactMerge INSTANCE = new PactMerge();

    private PactMerge() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final MergeResult merge(@NotNull Pact newPact, @NotNull Pact existing) {
        MergeResult mergeResult;
        Intrinsics.checkNotNullParameter((Object)newPact, (String)"newPact");
        Intrinsics.checkNotNullParameter((Object)existing, (String)"existing");
        Result<Boolean, String> compatibleTo = newPact.compatibleTo(existing);
        if (compatibleTo instanceof Result.Err) {
            return new MergeResult(false, "Cannot merge pacts as they are not compatible - " + ((Result.Err)compatibleTo).getError(), null, 4, null);
        }
        if (existing.getInteractions().isEmpty()) {
            mergeResult = new MergeResult(true, "", newPact);
        } else if (newPact.getInteractions().isEmpty()) {
            mergeResult = new MergeResult(true, "", existing);
        } else {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = INSTANCE.cartesianProduct(existing.getInteractions(), newPact.getInteractions());
            boolean $i$f$filter = false;
            void var6_5 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Pair it = (Pair)element$iv$iv;
                boolean bl = false;
                if (!((Interaction)it.getFirst()).conflictsWith((Interaction)it.getSecond())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List conflicts = (List)destination$iv$iv;
            mergeResult = conflicts.isEmpty() ? new MergeResult(true, "", existing.mergeInteractions(newPact.getInteractions())) : new MergeResult(false, "Cannot merge pacts as there were " + conflicts.size() + " conflict(s) between the interactions - " + CollectionsKt.joinToString$default((Iterable)conflicts, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, 4, null);
        }
        return mergeResult;
    }

    private final List<Pair<Interaction, Interaction>> cartesianProduct(List<? extends Interaction> list1, List<? extends Interaction> list2) {
        List result = new ArrayList();
        Iterable $this$forEach$iv = list1;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Interaction item1 = (Interaction)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = list2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Interaction item2 = (Interaction)element$iv2;
                boolean bl2 = false;
                result.add(TuplesKt.to((Object)item1, (Object)item2));
            }
        }
        return result;
    }
}

