/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.model;

import au.com.dius.pact.core.model.BrokerUrlSource;
import au.com.dius.pact.core.model.InvalidHttpResponseException;
import au.com.dius.pact.core.model.PactReaderKt;
import au.com.dius.pact.core.model.PactSource;
import au.com.dius.pact.core.model.UrlPactSource;
import au.com.dius.pact.core.pactbroker.PactBrokerClient;
import au.com.dius.pact.core.pactbroker.PactBrokerClientConfig;
import au.com.dius.pact.core.pactbroker.PactResponse;
import au.com.dius.pact.core.support.Auth;
import au.com.dius.pact.core.support.HttpClientUtils;
import au.com.dius.pact.core.support.KotlinLanguageSupportKt;
import au.com.dius.pact.core.support.Result;
import au.com.dius.pact.core.support.Utils;
import au.com.dius.pact.core.support.json.JsonParser;
import au.com.dius.pact.core.support.json.JsonValue;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.util.TimeValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002\u001a.\u0010\n\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000e\u001a6\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\f2\u0006\u0010\u0012\u001a\u00020\u000e2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0010\u001a\u00020\u0011\u001a$\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00180\u0017H\u0007\u001a.\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u001b0\u00172\b\u0010\u001c\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"logger", "Lmu/KLogger;", "basicAuth", "", "baseUrl", "", "username", "password", "builder", "Lorg/apache/hc/client5/http/impl/classic/HttpClientBuilder;", "fetchJsonResource", "Lau/com/dius/pact/core/support/Result;", "Lkotlin/Pair;", "Lau/com/dius/pact/core/support/json/JsonValue;", "Lau/com/dius/pact/core/model/UrlPactSource;", "", "http", "Lorg/apache/hc/client5/http/impl/classic/CloseableHttpClient;", "source", "loadPactFromUrl", "Lau/com/dius/pact/core/support/json/JsonValue$Object;", "Lau/com/dius/pact/core/model/PactSource;", "options", "", "", "newHttpClient", "queryStringToMap", "", "query", "decode", "", "model"})
public final class PactReaderKt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final Pair<JsonValue.Object, PactSource> loadPactFromUrl(@NotNull UrlPactSource source, @NotNull Map<String, ? extends Object> options, @NotNull CloseableHttpClient http) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        if (source instanceof BrokerUrlSource) {
            boolean insecureTLS = (Boolean)Utils.INSTANCE.lookupInMap(options, "insecureTLS", Boolean.TYPE, (Object)false);
            PactBrokerClient brokerClient = new PactBrokerClient(((BrokerUrlSource)source).getPactBrokerUrl(), MapsKt.toMutableMap(options), new PactBrokerClientConfig(0, 0, insecureTLS, 3, null));
            PactResponse pactResponse = brokerClient.fetchPact(source.getUrl(), source.getEncodePath());
            pair = TuplesKt.to((Object)pactResponse.getPactFile(), (Object)BrokerUrlSource.copy$default((BrokerUrlSource)source, null, null, pactResponse.getLinks(), options, ((BrokerUrlSource)source).getTag(), null, 35, null));
            return pair;
        } else {
            Result<Pair<JsonValue, UrlPactSource>, Throwable> jsonResource = PactReaderKt.fetchJsonResource(http, source);
            if (jsonResource instanceof Result.Ok) {
                if (!(((Pair)((Result.Ok)jsonResource).getValue()).getFirst() instanceof JsonValue.Object)) throw new UnsupportedOperationException("Was expected a JSON document, got " + ((Result.Ok)jsonResource).getValue());
                JsonValue.Object object = ((JsonValue)((Pair)((Result.Ok)jsonResource).getValue()).getFirst()).asObject();
                Intrinsics.checkNotNull((Object)object);
                pair = TuplesKt.to((Object)object, (Object)((Pair)((Result.Ok)jsonResource).getValue()).getSecond());
                return pair;
            } else {
                if (!(jsonResource instanceof Result.Err)) throw new NoWhenBranchMatchedException();
                throw (Throwable)((Result.Err)jsonResource).getError();
            }
        }
    }

    @NotNull
    public static final Result<Pair<JsonValue, UrlPactSource>, Throwable> fetchJsonResource(@NotNull CloseableHttpClient http, @NotNull UrlPactSource source) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        URL url = new URL(source.getUrl());
        return KotlinLanguageSupportKt.handleWith((Function0)((Function0)new Function0<Object>(url, source, http){
            final /* synthetic */ URL $url;
            final /* synthetic */ UrlPactSource $source;
            final /* synthetic */ CloseableHttpClient $http;
            {
                this.$url = $url;
                this.$source = $source;
                this.$http = $http;
                super(0);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invoke() {
                Pair pair;
                if (Intrinsics.areEqual((Object)this.$url.getProtocol(), (Object)"file")) {
                    URL uRL = new URL(this.$source.getUrl());
                    Charset charset = Charsets.UTF_8;
                    byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
                    pair = TuplesKt.to((Object)JsonParser.parseString((String)new String(byArray, charset)), (Object)this.$source);
                    return pair;
                } else {
                    HttpGet httpGet = new HttpGet(HttpClientUtils.INSTANCE.buildUrl("", this.$source.getUrl(), this.$source.getEncodePath()));
                    httpGet.addHeader("Content-Type", (Object)"application/json");
                    httpGet.addHeader("Accept", (Object)"application/hal+json, application/json");
                    CloseableHttpResponse response2 = this.$http.execute((ClassicHttpRequest)httpGet);
                    if (response2.getCode() < 300) {
                        ContentType contentType = ContentType.parseLenient((CharSequence)response2.getEntity().getContentType());
                        Intrinsics.checkNotNullExpressionValue((Object)contentType, (String)"contentType");
                        if (!HttpClientUtils.INSTANCE.isJsonResponse(contentType)) throw new InvalidHttpResponseException("Expected a JSON response, but got '" + contentType + "'");
                        String string = EntityUtils.toString((HttpEntity)response2.getEntity());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(response.entity)");
                        pair = TuplesKt.to((Object)JsonParser.parseString((String)string), (Object)this.$source);
                        return pair;
                    } else {
                        if (response2.getCode() != 404) throw new InvalidHttpResponseException("Request to source '" + this.$source + "' failed with response " + response2.getCode());
                        throw new InvalidHttpResponseException("No JSON document found at source '" + this.$source + "'");
                    }
                }
            }
        }));
    }

    @Deprecated(message="Use HttpClient.newHttpClient instead")
    @NotNull
    public static final CloseableHttpClient newHttpClient(@NotNull String baseUrl, @NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        HttpClientBuilder builder = HttpClients.custom().useSystemProperties().setRetryStrategy((HttpRequestRetryStrategy)new DefaultHttpRequestRetryStrategy(5, TimeValue.ofMilliseconds((long)3000L)));
        if (options.get("authentication") instanceof Auth) {
            Object object = options.get("authentication");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type au.com.dius.pact.core.support.Auth");
            Auth auth = (Auth)object;
            if (auth instanceof Auth.BasicAuthentication) {
                String string = ((Auth.BasicAuthentication)auth).getUsername();
                String string2 = ((Auth.BasicAuthentication)auth).getPassword();
                Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
                PactReaderKt.basicAuth(baseUrl, string, string2, builder);
            } else if (auth instanceof Auth.BearerAuthentication) {
                builder.setDefaultHeaders((Collection)CollectionsKt.listOf((Object)new BasicHeader(((Auth.BearerAuthentication)auth).getHeaderName(), (Object)("Bearer " + ((Auth.BearerAuthentication)auth).getToken()))));
            }
        } else if (options.get("authentication") instanceof List) {
            Object object = options.get("authentication");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
            List authentication = (List)object;
            String string = String.valueOf(CollectionsKt.first((List)authentication)).toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
            String scheme = string;
            if (Intrinsics.areEqual((Object)scheme, (Object)"basic")) {
                if (authentication.size() > 2) {
                    String string3 = String.valueOf(authentication.get(1));
                    String string4 = String.valueOf(authentication.get(2));
                    Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
                    PactReaderKt.basicAuth(baseUrl, string3, string4, builder);
                } else {
                    logger.warn((Function0)newHttpClient.1.INSTANCE);
                }
            } else {
                logger.warn((Function0)new Function0<Object>(scheme){
                    final /* synthetic */ String $scheme;
                    {
                        this.$scheme = $scheme;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Only supports basic authentication, got '" + this.$scheme + "', ignoring.";
                    }
                });
            }
        } else if (options.containsKey("authentication")) {
            logger.warn((Function0)new Function0<Object>(options){
                final /* synthetic */ Map<String, Object> $options;
                {
                    this.$options = $options;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Authentication options needs to be a Auth class or a list of values, got '" + this.$options.get("authentication") + "', ignoring.";
                }
            });
        }
        CloseableHttpClient closeableHttpClient = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)closeableHttpClient, (String)"builder.build()");
        return closeableHttpClient;
    }

    private static final void basicAuth(String baseUrl, String username, String password, HttpClientBuilder builder) {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        URI uri = new URI(baseUrl);
        AuthScope authScope = new AuthScope(uri.getHost(), uri.getPort());
        char[] cArray = password.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        credsProvider.setCredentials(authScope, (Credentials)new UsernamePasswordCredentials(username, cArray));
        builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public static final Map<String, List<String>> queryStringToMap(@Nullable String query, boolean decode) {
        Map map;
        String[] stringArray = (String[])query;
        if (stringArray == null || stringArray.length() == 0) {
            map = MapsKt.emptyMap();
        } else {
            void $this$fold$iv;
            void $this$mapTo$iv$iv;
            String it;
            Iterable $this$filterTo$iv$iv;
            stringArray = new String[]{"&"};
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)query, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)it).length() > 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String[] stringArray2 = new String[]{"="};
                List nv = StringsKt.split$default((CharSequence)it, (String[])stringArray2, (boolean)false, (int)2, (int)2, null);
                collection.add(TuplesKt.to(nv.get(0), nv.get(1)));
            }
            $this$map$iv = (List)destination$iv$iv;
            Map initial$iv = new LinkedHashMap();
            boolean $i$f$fold = false;
            Map accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                String value;
                void nameAndValue;
                Object item$iv$iv;
                item$iv$iv = (Pair)element$iv;
                Map map2 = accumulator$iv;
                boolean bl = false;
                String name = decode ? URLDecoder.decode((String)nameAndValue.getFirst(), "UTF-8") : (String)nameAndValue.getFirst();
                String string = value = decode ? URLDecoder.decode((String)nameAndValue.getSecond(), "UTF-8") : (String)nameAndValue.getSecond();
                if (map2.containsKey(name)) {
                    Object v = map2.get(name);
                    Intrinsics.checkNotNull(v);
                    List list = (List)v;
                    Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                    list.add(value);
                } else {
                    Map map3 = map2;
                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                    String string2 = name;
                    Object object = new String[1];
                    Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                    object[0] = value;
                    object = CollectionsKt.mutableListOf((Object[])object);
                    map3.put(string2, object);
                }
                accumulator$iv = map2;
            }
            map = accumulator$iv;
        }
        return map;
    }

    public static /* synthetic */ Map queryStringToMap$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return PactReaderKt.queryStringToMap(string, bl);
    }

    @JvmOverloads
    @NotNull
    public static final Map<String, List<String>> queryStringToMap(@Nullable String query) {
        return PactReaderKt.queryStringToMap$default(query, false, 2, null);
    }
}

