/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.model.generators;

import au.com.dius.pact.core.model.generators.DateExpression;
import au.com.dius.pact.core.model.generators.ParsedDateExpression;
import au.com.dius.pact.core.support.Result;
import au.com.dius.pact.core.support.generators.expressions.Adjustment;
import au.com.dius.pact.core.support.generators.expressions.DateBase;
import au.com.dius.pact.core.support.generators.expressions.DateExpressionLexer;
import au.com.dius.pact.core.support.generators.expressions.DateExpressionParser;
import au.com.dius.pact.core.support.generators.expressions.DateOffsetType;
import au.com.dius.pact.core.support.generators.expressions.Operation;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u00072\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\nH\u0002J@\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u001a\b\u0002\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\n2\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J@\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u001a\b\u0002\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\n2\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u001e\u0010\u0012\u001a\u00020\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J$\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0016\u001a\u00020\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019J\u001e\u0010\u001b\u001a\u00020\u00042\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u001c\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u001e\u0010 \u001a\u00020\u00042\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a8\u0006!"}, d2={"Lau/com/dius/pact/core/model/generators/DateExpression;", "Lmu/KLogging;", "()V", "adjustDateTime", "Ljava/time/OffsetDateTime;", "date", "stopCondition", "Lkotlin/Function1;", "", "adjuster", "Lkotlin/Function2;", "", "adjustDownTo", "adjustMonthDownTo", "month", "Ljava/time/Month;", "adjustMonthUpTo", "adjustUpTo", "baseDate", "result", "Lau/com/dius/pact/core/support/Result$Ok;", "Lau/com/dius/pact/core/model/generators/ParsedDateExpression;", "base", "executeDateExpression", "Lau/com/dius/pact/core/support/Result;", "", "expression", "forwardDateBy", "it", "Lau/com/dius/pact/core/support/generators/expressions/Adjustment;", "Lau/com/dius/pact/core/support/generators/expressions/DateOffsetType;", "parseDateExpression", "reverseDateBy", "model"})
public final class DateExpression
extends KLogging {
    @NotNull
    public static final DateExpression INSTANCE = new DateExpression();

    private DateExpression() {
    }

    @NotNull
    public final Result<OffsetDateTime, String> executeDateExpression(@NotNull OffsetDateTime base, @Nullable String expression) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        CharSequence charSequence = expression;
        if (!(charSequence == null || charSequence.length() == 0)) {
            Result result;
            Result result2 = this.parseDateExpression(expression);
            if (result2 instanceof Result.Err) {
                result = result2;
            } else if (result2 instanceof Result.Ok) {
                OffsetDateTime date = null;
                date = this.baseDate((Result.Ok<ParsedDateExpression>)((Result.Ok)result2), base);
                Iterable $this$forEach$iv = ((ParsedDateExpression)((Result.Ok)result2).getValue()).getAdjustments();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    OffsetDateTime offsetDateTime;
                    Adjustment it = (Adjustment)element$iv;
                    boolean bl = false;
                    switch (WhenMappings.$EnumSwitchMapping$0[it.getOperation().ordinal()]) {
                        case 1: {
                            offsetDateTime = INSTANCE.forwardDateBy((Adjustment<DateOffsetType>)it, date);
                            break;
                        }
                        case 2: {
                            offsetDateTime = INSTANCE.reverseDateBy((Adjustment<DateOffsetType>)it, date);
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    date = offsetDateTime;
                }
                result = (Result)new Result.Ok((Object)date);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return result;
        }
        return (Result)new Result.Ok((Object)base);
    }

    private final OffsetDateTime reverseDateBy(Adjustment<DateOffsetType> it, OffsetDateTime date) {
        OffsetDateTime offsetDateTime;
        switch (WhenMappings.$EnumSwitchMapping$1[((DateOffsetType)it.getType()).ordinal()]) {
            case 1: {
                OffsetDateTime offsetDateTime2 = date.minusDays(it.getValue());
                offsetDateTime = offsetDateTime2;
                Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime2, (String)"date.minusDays(it.value.toLong())");
                break;
            }
            case 2: {
                OffsetDateTime offsetDateTime3 = date.minus(it.getValue(), ChronoUnit.WEEKS);
                offsetDateTime = offsetDateTime3;
                Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime3, (String)"date.minus(it.value.toLong(), ChronoUnit.WEEKS)");
                break;
            }
            case 3: {
                OffsetDateTime offsetDateTime4 = date.minus(it.getValue(), ChronoUnit.MONTHS);
                offsetDateTime = offsetDateTime4;
                Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime4, (String)"date.minus(it.value.toLong(), ChronoUnit.MONTHS)");
                break;
            }
            case 4: {
                OffsetDateTime offsetDateTime5 = date.minus(it.getValue(), ChronoUnit.YEARS);
                offsetDateTime = offsetDateTime5;
                Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime5, (String)"date.minus(it.value.toLong(), ChronoUnit.YEARS)");
                break;
            }
            case 5: {
                offsetDateTime = DateExpression.adjustDownTo$default(this, date, null, reverseDateBy.1.INSTANCE, 2, null);
                break;
            }
            case 6: {
                offsetDateTime = DateExpression.adjustDownTo$default(this, date, null, reverseDateBy.2.INSTANCE, 2, null);
                break;
            }
            case 7: {
                offsetDateTime = DateExpression.adjustDownTo$default(this, date, null, reverseDateBy.3.INSTANCE, 2, null);
                break;
            }
            case 8: {
                offsetDateTime = DateExpression.adjustDownTo$default(this, date, null, reverseDateBy.4.INSTANCE, 2, null);
                break;
            }
            case 9: {
                offsetDateTime = DateExpression.adjustDownTo$default(this, date, null, reverseDateBy.5.INSTANCE, 2, null);
                break;
            }
            case 10: {
                offsetDateTime = DateExpression.adjustDownTo$default(this, date, null, reverseDateBy.6.INSTANCE, 2, null);
                break;
            }
            case 11: {
                offsetDateTime = DateExpression.adjustDownTo$default(this, date, null, reverseDateBy.7.INSTANCE, 2, null);
                break;
            }
            case 12: {
                offsetDateTime = this.adjustMonthDownTo(date, Month.JANUARY);
                break;
            }
            case 13: {
                offsetDateTime = this.adjustMonthDownTo(date, Month.FEBRUARY);
                break;
            }
            case 14: {
                offsetDateTime = this.adjustMonthDownTo(date, Month.MARCH);
                break;
            }
            case 15: {
                offsetDateTime = this.adjustMonthDownTo(date, Month.APRIL);
                break;
            }
            case 16: {
                offsetDateTime = this.adjustMonthDownTo(date, Month.MAY);
                break;
            }
            case 17: {
                offsetDateTime = this.adjustMonthDownTo(date, Month.JUNE);
                break;
            }
            case 18: {
                offsetDateTime = this.adjustMonthDownTo(date, Month.JULY);
                break;
            }
            case 19: {
                offsetDateTime = this.adjustMonthDownTo(date, Month.AUGUST);
                break;
            }
            case 20: {
                offsetDateTime = this.adjustMonthDownTo(date, Month.SEPTEMBER);
                break;
            }
            case 21: {
                offsetDateTime = this.adjustMonthDownTo(date, Month.OCTOBER);
                break;
            }
            case 22: {
                offsetDateTime = this.adjustMonthDownTo(date, Month.NOVEMBER);
                break;
            }
            case 23: {
                offsetDateTime = this.adjustMonthDownTo(date, Month.DECEMBER);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return offsetDateTime;
    }

    private final OffsetDateTime forwardDateBy(Adjustment<DateOffsetType> it, OffsetDateTime date) {
        OffsetDateTime offsetDateTime;
        switch (WhenMappings.$EnumSwitchMapping$1[((DateOffsetType)it.getType()).ordinal()]) {
            case 1: {
                OffsetDateTime offsetDateTime2 = date.plusDays(it.getValue());
                offsetDateTime = offsetDateTime2;
                Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime2, (String)"date.plusDays(it.value.toLong())");
                break;
            }
            case 2: {
                OffsetDateTime offsetDateTime3 = date.plus(it.getValue(), ChronoUnit.WEEKS);
                offsetDateTime = offsetDateTime3;
                Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime3, (String)"date.plus(it.value.toLong(), ChronoUnit.WEEKS)");
                break;
            }
            case 3: {
                OffsetDateTime offsetDateTime4 = date.plus(it.getValue(), ChronoUnit.MONTHS);
                offsetDateTime = offsetDateTime4;
                Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime4, (String)"date.plus(it.value.toLong(), ChronoUnit.MONTHS)");
                break;
            }
            case 4: {
                OffsetDateTime offsetDateTime5 = date.plus(it.getValue(), ChronoUnit.YEARS);
                offsetDateTime = offsetDateTime5;
                Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime5, (String)"date.plus(it.value.toLong(), ChronoUnit.YEARS)");
                break;
            }
            case 5: {
                offsetDateTime = DateExpression.adjustUpTo$default(this, date, null, forwardDateBy.1.INSTANCE, 2, null);
                break;
            }
            case 6: {
                offsetDateTime = DateExpression.adjustUpTo$default(this, date, null, forwardDateBy.2.INSTANCE, 2, null);
                break;
            }
            case 7: {
                offsetDateTime = DateExpression.adjustUpTo$default(this, date, null, forwardDateBy.3.INSTANCE, 2, null);
                break;
            }
            case 8: {
                offsetDateTime = DateExpression.adjustUpTo$default(this, date, null, forwardDateBy.4.INSTANCE, 2, null);
                break;
            }
            case 9: {
                offsetDateTime = DateExpression.adjustUpTo$default(this, date, null, forwardDateBy.5.INSTANCE, 2, null);
                break;
            }
            case 10: {
                offsetDateTime = DateExpression.adjustUpTo$default(this, date, null, forwardDateBy.6.INSTANCE, 2, null);
                break;
            }
            case 11: {
                offsetDateTime = DateExpression.adjustUpTo$default(this, date, null, forwardDateBy.7.INSTANCE, 2, null);
                break;
            }
            case 12: {
                offsetDateTime = this.adjustMonthUpTo(date, Month.JANUARY);
                break;
            }
            case 13: {
                offsetDateTime = this.adjustMonthUpTo(date, Month.FEBRUARY);
                break;
            }
            case 14: {
                offsetDateTime = this.adjustMonthUpTo(date, Month.MARCH);
                break;
            }
            case 15: {
                offsetDateTime = this.adjustMonthUpTo(date, Month.APRIL);
                break;
            }
            case 16: {
                offsetDateTime = this.adjustMonthUpTo(date, Month.MAY);
                break;
            }
            case 17: {
                offsetDateTime = this.adjustMonthUpTo(date, Month.JUNE);
                break;
            }
            case 18: {
                offsetDateTime = this.adjustMonthUpTo(date, Month.JULY);
                break;
            }
            case 19: {
                offsetDateTime = this.adjustMonthUpTo(date, Month.AUGUST);
                break;
            }
            case 20: {
                offsetDateTime = this.adjustMonthUpTo(date, Month.SEPTEMBER);
                break;
            }
            case 21: {
                offsetDateTime = this.adjustMonthUpTo(date, Month.OCTOBER);
                break;
            }
            case 22: {
                offsetDateTime = this.adjustMonthUpTo(date, Month.NOVEMBER);
                break;
            }
            case 23: {
                offsetDateTime = this.adjustMonthUpTo(date, Month.DECEMBER);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return offsetDateTime;
    }

    private final OffsetDateTime baseDate(Result.Ok<ParsedDateExpression> result, OffsetDateTime base) {
        OffsetDateTime offsetDateTime;
        switch (WhenMappings.$EnumSwitchMapping$2[((ParsedDateExpression)result.getValue()).getBase().ordinal()]) {
            case 1: 
            case 2: {
                offsetDateTime = base;
                break;
            }
            case 3: {
                OffsetDateTime offsetDateTime2 = base.minusDays(1L);
                offsetDateTime = offsetDateTime2;
                Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime2, (String)"base.minusDays(1)");
                break;
            }
            case 4: {
                OffsetDateTime offsetDateTime3 = base.plusDays(1L);
                offsetDateTime = offsetDateTime3;
                Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime3, (String)"base.plusDays(1)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return offsetDateTime;
    }

    private final OffsetDateTime adjustMonthDownTo(OffsetDateTime date, Month month) {
        OffsetDateTime d = date.minusMonths(1L).withDayOfMonth(1);
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"d");
        return this.adjustDownTo(d, (Function2<? super OffsetDateTime, ? super Long, OffsetDateTime>)((Function2)adjustMonthDownTo.1.INSTANCE), (Function1<? super OffsetDateTime, Boolean>)((Function1)new Function1<OffsetDateTime, Boolean>(month){
            final /* synthetic */ Month $month;
            {
                this.$month = $month;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull OffsetDateTime it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getMonth() == this.$month;
            }
        }));
    }

    private final OffsetDateTime adjustMonthUpTo(OffsetDateTime date, Month month) {
        OffsetDateTime d = date.plusMonths(1L).withDayOfMonth(1);
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"d");
        return this.adjustUpTo(d, (Function2<? super OffsetDateTime, ? super Long, OffsetDateTime>)((Function2)adjustMonthUpTo.1.INSTANCE), (Function1<? super OffsetDateTime, Boolean>)((Function1)new Function1<OffsetDateTime, Boolean>(month){
            final /* synthetic */ Month $month;
            {
                this.$month = $month;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull OffsetDateTime it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getMonth() == this.$month;
            }
        }));
    }

    private final OffsetDateTime adjustUpTo(OffsetDateTime date, Function2<? super OffsetDateTime, ? super Long, OffsetDateTime> adjuster, Function1<? super OffsetDateTime, Boolean> stopCondition) {
        return this.adjustDateTime(date, stopCondition, adjuster);
    }

    static /* synthetic */ OffsetDateTime adjustUpTo$default(DateExpression dateExpression, OffsetDateTime offsetDateTime, Function2 function2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function2 = adjustUpTo.1.INSTANCE;
        }
        return dateExpression.adjustUpTo(offsetDateTime, (Function2<? super OffsetDateTime, ? super Long, OffsetDateTime>)function2, (Function1<? super OffsetDateTime, Boolean>)function1);
    }

    private final OffsetDateTime adjustDownTo(OffsetDateTime date, Function2<? super OffsetDateTime, ? super Long, OffsetDateTime> adjuster, Function1<? super OffsetDateTime, Boolean> stopCondition) {
        return this.adjustDateTime(date, stopCondition, adjuster);
    }

    static /* synthetic */ OffsetDateTime adjustDownTo$default(DateExpression dateExpression, OffsetDateTime offsetDateTime, Function2 function2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function2 = adjustDownTo.1.INSTANCE;
        }
        return dateExpression.adjustDownTo(offsetDateTime, (Function2<? super OffsetDateTime, ? super Long, OffsetDateTime>)function2, (Function1<? super OffsetDateTime, Boolean>)function1);
    }

    private final OffsetDateTime adjustDateTime(OffsetDateTime date, Function1<? super OffsetDateTime, Boolean> stopCondition, Function2<? super OffsetDateTime, ? super Long, OffsetDateTime> adjuster) {
        OffsetDateTime result = date;
        while (!((Boolean)stopCondition.invoke((Object)result)).booleanValue()) {
            result = (OffsetDateTime)adjuster.invoke((Object)result, (Object)1L);
        }
        return result;
    }

    private final Result<ParsedDateExpression, String> parseDateExpression(String expression) {
        Result result;
        DateExpressionLexer lexer = new DateExpressionLexer(expression);
        DateExpressionParser parser = new DateExpressionParser(lexer);
        Result result2 = parser.expression();
        if (result2 instanceof Result.Err) {
            result = (Result)new Result.Err((Object)("Error parsing expression: " + ((Result.Err)result2).getError()));
        } else if (result2 instanceof Result.Ok) {
            result = (Result)new Result.Ok((Object)new ParsedDateExpression((DateBase)((Pair)((Result.Ok)result2).getValue()).getFirst(), CollectionsKt.toMutableList((Collection)((Collection)((Pair)((Result.Ok)result2).getValue()).getSecond()))));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[Operation.values().length];
            try {
                nArray[Operation.PLUS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operation.MINUS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[DateOffsetType.values().length];
            try {
                nArray[DateOffsetType.DAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateOffsetType.WEEK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateOffsetType.MONTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateOffsetType.YEAR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateOffsetType.MONDAY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateOffsetType.TUESDAY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateOffsetType.WEDNESDAY.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateOffsetType.THURSDAY.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateOffsetType.FRIDAY.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateOffsetType.SATURDAY.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateOffsetType.SUNDAY.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateOffsetType.JAN.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateOffsetType.FEB.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateOffsetType.MAR.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateOffsetType.APR.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateOffsetType.MAY.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateOffsetType.JUNE.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateOffsetType.JULY.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateOffsetType.AUG.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateOffsetType.SEP.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateOffsetType.OCT.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateOffsetType.NOV.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateOffsetType.DEC.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[DateBase.values().length];
            try {
                nArray[DateBase.NOW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateBase.TODAY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateBase.YESTERDAY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateBase.TOMORROW.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

