/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.model.generators;

import au.com.dius.pact.core.model.PactSpecVersion;
import au.com.dius.pact.core.model.generators.Generator;
import au.com.dius.pact.core.model.generators.GeneratorKt;
import au.com.dius.pact.core.model.generators.GeneratorTestMode;
import au.com.dius.pact.core.support.json.JsonValue;
import java.math.BigDecimal;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J&\u0010\u0011\u001a\u00020\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0010H\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\t\u0010\u001a\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lau/com/dius/pact/core/model/generators/RandomDecimalGenerator;", "Lau/com/dius/pact/core/model/generators/Generator;", "digits", "", "(I)V", "getDigits", "()I", "type", "", "getType", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "generate", "context", "", "exampleValue", "hashCode", "toMap", "", "pactSpecVersion", "Lau/com/dius/pact/core/model/PactSpecVersion;", "toString", "Companion", "model"})
public final class RandomDecimalGenerator
implements Generator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int digits;

    public RandomDecimalGenerator(int digits2) {
        this.digits = digits2;
    }

    public final int getDigits() {
        return this.digits;
    }

    @Override
    @NotNull
    public String getType() {
        return "RandomDecimal";
    }

    @Override
    @NotNull
    public Map<String, Object> toMap(@NotNull PactSpecVersion pactSpecVersion) {
        Intrinsics.checkNotNullParameter((Object)((Object)pactSpecVersion), (String)"pactSpecVersion");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)this.getType()), TuplesKt.to((Object)"digits", (Object)this.digits)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @NotNull
    public Object generate(@NotNull Map<String, Object> context, @Nullable Object exampleValue) {
        BigDecimal bigDecimal;
        Intrinsics.checkNotNullParameter(context, (String)"context");
        if (this.digits < 1) {
            throw new UnsupportedOperationException("RandomDecimalGenerator digits must be > 0, got " + this.digits);
        }
        if (this.digits == 1) {
            bigDecimal = new BigDecimal(RandomUtils.nextInt((int)0, (int)9));
        } else if (this.digits == 2) {
            bigDecimal = new BigDecimal(RandomUtils.nextInt((int)0, (int)9) + "." + RandomUtils.nextInt((int)0, (int)9));
        } else {
            Object object;
            String sampleDigits = RandomStringUtils.randomNumeric((int)(this.digits + 1));
            int pos = RandomUtils.nextInt((int)1, (int)(this.digits - 1));
            Intrinsics.checkNotNullExpressionValue((Object)sampleDigits, (String)"sampleDigits");
            if (StringsKt.startsWith$default((String)sampleDigits, (String)"00", (boolean)false, (int)2, null)) {
                int n = RandomUtils.nextInt((int)1, (int)9);
                String string = sampleDigits.substring(1, this.digits);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                object = n + string;
            } else if (pos != 1 && StringsKt.startsWith$default((CharSequence)sampleDigits, (char)'0', (boolean)false, (int)2, null)) {
                String string = sampleDigits.substring(1);
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            } else {
                String string = sampleDigits.substring(0, this.digits);
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            }
            Object selectedDigits = object;
            String string = ((String)selectedDigits).substring(0, pos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string2 = ((String)selectedDigits).substring(pos);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            String generated = string + "." + string2;
            GeneratorKt.access$getLogger$p().trace((Function0)new Function0<Object>(sampleDigits, pos, (String)selectedDigits, generated){
                final /* synthetic */ String $sampleDigits;
                final /* synthetic */ int $pos;
                final /* synthetic */ String $selectedDigits;
                final /* synthetic */ String $generated;
                {
                    this.$sampleDigits = $sampleDigits;
                    this.$pos = $pos;
                    this.$selectedDigits = $selectedDigits;
                    this.$generated = $generated;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "RandomDecimalGenerator: sampleDigits=[" + this.$sampleDigits + "], pos=" + this.$pos + ", selectedDigits=[" + this.$selectedDigits + "], generated=[" + this.$generated + "]";
                }
            });
            bigDecimal = new BigDecimal(generated);
        }
        return bigDecimal;
    }

    @Override
    public boolean correspondsToMode(@NotNull GeneratorTestMode mode) {
        return Generator.DefaultImpls.correspondsToMode(this, mode);
    }

    public final int component1() {
        return this.digits;
    }

    @NotNull
    public final RandomDecimalGenerator copy(int digits2) {
        return new RandomDecimalGenerator(digits2);
    }

    public static /* synthetic */ RandomDecimalGenerator copy$default(RandomDecimalGenerator randomDecimalGenerator, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = randomDecimalGenerator.digits;
        }
        return randomDecimalGenerator.copy(n);
    }

    @NotNull
    public String toString() {
        return "RandomDecimalGenerator(digits=" + this.digits + ")";
    }

    public int hashCode() {
        return Integer.hashCode(this.digits);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RandomDecimalGenerator)) {
            return false;
        }
        RandomDecimalGenerator randomDecimalGenerator = (RandomDecimalGenerator)other;
        return this.digits == randomDecimalGenerator.digits;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lau/com/dius/pact/core/model/generators/RandomDecimalGenerator$Companion;", "", "()V", "fromJson", "Lau/com/dius/pact/core/model/generators/RandomDecimalGenerator;", "json", "Lau/com/dius/pact/core/support/json/JsonValue$Object;", "model"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RandomDecimalGenerator fromJson(@NotNull JsonValue.Object json2) {
            int n;
            Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
            if (json2.get("digits").isNumber()) {
                Number number = json2.get("digits").asNumber();
                Intrinsics.checkNotNull((Object)number);
                n = number.intValue();
            } else {
                GeneratorKt.access$getLogger$p().warn((Function0)new Function0<Object>(json2){
                    final /* synthetic */ JsonValue.Object $json;
                    {
                        this.$json = $json;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Ignoring invalid value for digits: '" + this.$json.get("digits") + "'";
                    }
                });
                n = 10;
            }
            int digits2 = n;
            return new RandomDecimalGenerator(digits2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

