/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.model.generators;

import au.com.dius.pact.core.model.generators.ParsedTimeExpression;
import au.com.dius.pact.core.support.Result;
import au.com.dius.pact.core.support.generators.expressions.Adjustment;
import au.com.dius.pact.core.support.generators.expressions.Operation;
import au.com.dius.pact.core.support.generators.expressions.TimeBase;
import au.com.dius.pact.core.support.generators.expressions.TimeExpressionLexer;
import au.com.dius.pact.core.support.generators.expressions.TimeExpressionParser;
import au.com.dius.pact.core.support.generators.expressions.TimeOffsetType;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0006J\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lau/com/dius/pact/core/model/generators/TimeExpression;", "Lmu/KLogging;", "()V", "executeTimeExpression", "Lau/com/dius/pact/core/support/Result;", "Ljava/time/OffsetDateTime;", "", "base", "expression", "parseTimeExpression", "Lau/com/dius/pact/core/model/generators/ParsedTimeExpression;", "model"})
public final class TimeExpression
extends KLogging {
    @NotNull
    public static final TimeExpression INSTANCE = new TimeExpression();

    private TimeExpression() {
    }

    @NotNull
    public final Result<OffsetDateTime, String> executeTimeExpression(@NotNull OffsetDateTime base, @Nullable String expression) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        CharSequence charSequence = expression;
        if (!(charSequence == null || charSequence.length() == 0)) {
            Result result;
            Result result2 = this.parseTimeExpression(expression);
            if (result2 instanceof Result.Err) {
                result = result2;
            } else if (result2 instanceof Result.Ok) {
                OffsetDateTime offsetDateTime;
                OffsetDateTime midnight = OffsetDateTime.of(base.toLocalDate(), LocalTime.MIDNIGHT, ZoneOffset.from(base));
                OffsetDateTime noon = OffsetDateTime.of(base.toLocalDate(), LocalTime.NOON, ZoneOffset.from(base));
                OffsetDateTime time = null;
                TimeBase valBase = ((ParsedTimeExpression)((Result.Ok)result2).getValue()).getBase();
                if (Intrinsics.areEqual((Object)valBase, (Object)TimeBase.Now.INSTANCE)) {
                    offsetDateTime = base;
                } else if (Intrinsics.areEqual((Object)valBase, (Object)TimeBase.Midnight.INSTANCE)) {
                    offsetDateTime = midnight;
                } else if (Intrinsics.areEqual((Object)valBase, (Object)TimeBase.Noon.INSTANCE)) {
                    offsetDateTime = noon;
                } else if (valBase instanceof TimeBase.Am) {
                    offsetDateTime = midnight.plusHours(((TimeBase.Am)valBase).getHour());
                } else if (valBase instanceof TimeBase.Pm) {
                    offsetDateTime = noon.plusHours(((TimeBase.Pm)valBase).getHour());
                } else if (valBase instanceof TimeBase.Next) {
                    offsetDateTime = base.isBefore(noon) ? noon.plusHours(((TimeBase.Next)valBase).getHour()) : midnight.plusHours(((TimeBase.Next)valBase).getHour());
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                time = offsetDateTime;
                Iterable $this$forEach$iv = ((ParsedTimeExpression)((Result.Ok)result2).getValue()).getAdjustments();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Adjustment it = (Adjustment)element$iv;
                    boolean bl = false;
                    switch (WhenMappings.$EnumSwitchMapping$1[it.getOperation().ordinal()]) {
                        case 1: {
                            OffsetDateTime offsetDateTime2;
                            switch (WhenMappings.$EnumSwitchMapping$0[((TimeOffsetType)it.getType()).ordinal()]) {
                                case 1: {
                                    offsetDateTime2 = time.plusHours(it.getValue());
                                    break;
                                }
                                case 2: {
                                    offsetDateTime2 = time.plusMinutes(it.getValue());
                                    break;
                                }
                                case 3: {
                                    offsetDateTime2 = time.plusSeconds(it.getValue());
                                    break;
                                }
                                case 4: {
                                    offsetDateTime2 = time.plus(it.getValue(), ChronoUnit.MILLIS);
                                    break;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            time = offsetDateTime2;
                            break;
                        }
                        case 2: {
                            OffsetDateTime offsetDateTime3;
                            switch (WhenMappings.$EnumSwitchMapping$0[((TimeOffsetType)it.getType()).ordinal()]) {
                                case 1: {
                                    offsetDateTime3 = time.minusHours(it.getValue());
                                    break;
                                }
                                case 2: {
                                    offsetDateTime3 = time.minusMinutes(it.getValue());
                                    break;
                                }
                                case 3: {
                                    offsetDateTime3 = time.minusSeconds(it.getValue());
                                    break;
                                }
                                case 4: {
                                    offsetDateTime3 = time.minus(it.getValue(), ChronoUnit.MILLIS);
                                    break;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            time = offsetDateTime3;
                        }
                    }
                }
                result = (Result)new Result.Ok((Object)time);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return result;
        }
        return (Result)new Result.Ok((Object)base);
    }

    private final Result<ParsedTimeExpression, String> parseTimeExpression(String expression) {
        Result result;
        TimeExpressionLexer lexer = new TimeExpressionLexer(expression);
        TimeExpressionParser parser = new TimeExpressionParser(lexer);
        Result result2 = parser.expression();
        if (result2 instanceof Result.Err) {
            result = (Result)new Result.Err((Object)("Error parsing expression: " + ((Result.Err)result2).getError()));
        } else if (result2 instanceof Result.Ok) {
            result = (Result)new Result.Ok((Object)new ParsedTimeExpression((TimeBase)((Pair)((Result.Ok)result2).getValue()).getFirst(), CollectionsKt.toMutableList((Collection)((Collection)((Pair)((Result.Ok)result2).getValue()).getSecond()))));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TimeOffsetType.values().length];
            try {
                nArray[TimeOffsetType.HOUR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimeOffsetType.MINUTE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimeOffsetType.SECOND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimeOffsetType.MILLISECOND.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Operation.values().length];
            try {
                nArray[Operation.PLUS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operation.MINUS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

