/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.model.generators;

import au.com.dius.pact.core.model.PactSpecVersion;
import au.com.dius.pact.core.model.generators.Generator;
import au.com.dius.pact.core.model.generators.GeneratorTestMode;
import au.com.dius.pact.core.model.generators.TimeExpression;
import au.com.dius.pact.core.support.ResultKt;
import au.com.dius.pact.core.support.json.JsonValue;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001f\b\u0007\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J!\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J&\u0010\u0012\u001a\u00020\u00112\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00110\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0011H\u0016J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00110\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u0014\u0010\t\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lau/com/dius/pact/core/model/generators/TimeGenerator;", "Lau/com/dius/pact/core/model/generators/Generator;", "format", "", "expression", "(Ljava/lang/String;Ljava/lang/String;)V", "getExpression", "()Ljava/lang/String;", "getFormat", "type", "getType", "component1", "component2", "copy", "equals", "", "other", "", "generate", "context", "", "exampleValue", "hashCode", "", "toMap", "", "pactSpecVersion", "Lau/com/dius/pact/core/model/PactSpecVersion;", "toString", "Companion", "model"})
public final class TimeGenerator
implements Generator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String format;
    @Nullable
    private final String expression;

    @JvmOverloads
    public TimeGenerator(@Nullable String format, @Nullable String expression) {
        this.format = format;
        this.expression = expression;
    }

    public /* synthetic */ TimeGenerator(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(string, string2);
    }

    @Nullable
    public final String getFormat() {
        return this.format;
    }

    @Nullable
    public final String getExpression() {
        return this.expression;
    }

    @Override
    @NotNull
    public String getType() {
        return "Time";
    }

    @Override
    @NotNull
    public Map<String, Object> toMap(@NotNull PactSpecVersion pactSpecVersion) {
        Intrinsics.checkNotNullParameter((Object)((Object)pactSpecVersion), (String)"pactSpecVersion");
        Object object = new Pair[]{TuplesKt.to((Object)"type", (Object)this.getType())};
        Map map = MapsKt.mutableMapOf((Pair[])object);
        object = this.format;
        if (!(object == null || object.length() == 0)) {
            map.put("format", this.format);
        }
        if (!((object = (CharSequence)this.expression) == null || object.length() == 0)) {
            map.put("expression", this.expression);
        }
        return map;
    }

    @Override
    @NotNull
    public Object generate(@NotNull Map<String, Object> context, @Nullable Object exampleValue) {
        OffsetDateTime offsetDateTime;
        Intrinsics.checkNotNullParameter(context, (String)"context");
        if (context.containsKey("baseTime")) {
            Object object = context.get("baseTime");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.time.OffsetDateTime");
            offsetDateTime = (OffsetDateTime)object;
        } else {
            offsetDateTime = OffsetDateTime.now();
        }
        OffsetDateTime base = offsetDateTime;
        Intrinsics.checkNotNullExpressionValue((Object)base, (String)"base");
        OffsetDateTime time = (OffsetDateTime)ResultKt.getOr(TimeExpression.INSTANCE.executeTimeExpression(base, this.expression), (Object)base);
        CharSequence charSequence = this.format;
        String string = !(charSequence == null || charSequence.length() == 0) ? time.format(DateTimeFormatter.ofPattern(this.format)) : time.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (!format.isNullOrEmpt\u2026    time.toString()\n    }");
        return string;
    }

    @Override
    public boolean correspondsToMode(@NotNull GeneratorTestMode mode) {
        return Generator.DefaultImpls.correspondsToMode(this, mode);
    }

    @Nullable
    public final String component1() {
        return this.format;
    }

    @Nullable
    public final String component2() {
        return this.expression;
    }

    @NotNull
    public final TimeGenerator copy(@Nullable String format, @Nullable String expression) {
        return new TimeGenerator(format, expression);
    }

    public static /* synthetic */ TimeGenerator copy$default(TimeGenerator timeGenerator, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = timeGenerator.format;
        }
        if ((n & 2) != 0) {
            string2 = timeGenerator.expression;
        }
        return timeGenerator.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "TimeGenerator(format=" + this.format + ", expression=" + this.expression + ")";
    }

    public int hashCode() {
        int result = this.format == null ? 0 : this.format.hashCode();
        result = result * 31 + (this.expression == null ? 0 : this.expression.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TimeGenerator)) {
            return false;
        }
        TimeGenerator timeGenerator = (TimeGenerator)other;
        if (!Intrinsics.areEqual((Object)this.format, (Object)timeGenerator.format)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.expression, (Object)timeGenerator.expression);
    }

    @JvmOverloads
    public TimeGenerator(@Nullable String format) {
        this(format, null, 2, null);
    }

    @JvmOverloads
    public TimeGenerator() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lau/com/dius/pact/core/model/generators/TimeGenerator$Companion;", "", "()V", "fromJson", "Lau/com/dius/pact/core/model/generators/TimeGenerator;", "json", "Lau/com/dius/pact/core/support/json/JsonValue$Object;", "model"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TimeGenerator fromJson(@NotNull JsonValue.Object json2) {
            Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
            String format = json2.get("format").isString() ? json2.get("format").asString() : null;
            String expression = json2.get("expression").isString() ? json2.get("expression").asString() : null;
            return new TimeGenerator(format, expression);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

