/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.model.matchingrules.expressions;

import au.com.dius.pact.core.model.generators.Generator;
import au.com.dius.pact.core.model.matchingrules.MatchingRule;
import au.com.dius.pact.core.model.matchingrules.expressions.MatcherDefinitionLexer;
import au.com.dius.pact.core.model.matchingrules.expressions.MatcherDefinitionParser;
import au.com.dius.pact.core.model.matchingrules.expressions.MatchingReference;
import au.com.dius.pact.core.model.matchingrules.expressions.ValueType;
import au.com.dius.pact.core.support.Either;
import au.com.dius.pact.core.support.KotlinLanguageSupportKt;
import au.com.dius.pact.core.support.Result;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 &2\u00020\u0001:\u0001&B%\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB#\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\t\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\nB;\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0018\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\u000f0\u000e\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0010J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\fH\u00c6\u0003J\u001b\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\u000f0\u000eH\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003JG\u0010\u001d\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u000b\u001a\u00020\f2\u001a\b\u0002\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\u000f0\u000e2\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\u0010\u0010#\u001a\u00020\u00002\b\u0010 \u001a\u0004\u0018\u00010\u0000J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R#\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006'"}, d2={"Lau/com/dius/pact/core/model/matchingrules/expressions/MatchingRuleDefinition;", "", "value", "", "rule", "Lau/com/dius/pact/core/model/matchingrules/MatchingRule;", "generator", "Lau/com/dius/pact/core/model/generators/Generator;", "(Ljava/lang/String;Lau/com/dius/pact/core/model/matchingrules/MatchingRule;Lau/com/dius/pact/core/model/generators/Generator;)V", "Lau/com/dius/pact/core/model/matchingrules/expressions/MatchingReference;", "(Ljava/lang/String;Lau/com/dius/pact/core/model/matchingrules/expressions/MatchingReference;Lau/com/dius/pact/core/model/generators/Generator;)V", "valueType", "Lau/com/dius/pact/core/model/matchingrules/expressions/ValueType;", "rules", "", "Lau/com/dius/pact/core/support/Either;", "(Ljava/lang/String;Lau/com/dius/pact/core/model/matchingrules/expressions/ValueType;Ljava/util/List;Lau/com/dius/pact/core/model/generators/Generator;)V", "getGenerator", "()Lau/com/dius/pact/core/model/generators/Generator;", "getRules", "()Ljava/util/List;", "getValue", "()Ljava/lang/String;", "getValueType", "()Lau/com/dius/pact/core/model/matchingrules/expressions/ValueType;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "merge", "toString", "withType", "Companion", "model"})
public final class MatchingRuleDefinition {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String value;
    @NotNull
    private final ValueType valueType;
    @NotNull
    private final List<Either<MatchingRule, MatchingReference>> rules;
    @Nullable
    private final Generator generator;

    public MatchingRuleDefinition(@Nullable String value, @NotNull ValueType valueType, @NotNull List<? extends Either<? extends MatchingRule, MatchingReference>> rules, @Nullable Generator generator) {
        Intrinsics.checkNotNullParameter((Object)((Object)valueType), (String)"valueType");
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        this.value = value;
        this.valueType = valueType;
        this.rules = rules;
        this.generator = generator;
    }

    @Nullable
    public final String getValue() {
        return this.value;
    }

    @NotNull
    public final ValueType getValueType() {
        return this.valueType;
    }

    @NotNull
    public final List<Either<MatchingRule, MatchingReference>> getRules() {
        return this.rules;
    }

    @Nullable
    public final Generator getGenerator() {
        return this.generator;
    }

    public MatchingRuleDefinition(@Nullable String value, @Nullable MatchingRule rule, @Nullable Generator generator) {
        this(value, ValueType.Unknown, rule != null ? CollectionsKt.listOf((Object)new Either.A((Object)rule)) : CollectionsKt.emptyList(), generator);
    }

    public MatchingRuleDefinition(@Nullable String value, @NotNull MatchingReference rule, @Nullable Generator generator) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        this(value, ValueType.Unknown, CollectionsKt.listOf((Object)new Either.B((Object)rule)), generator);
    }

    @NotNull
    public final MatchingRuleDefinition merge(@Nullable MatchingRuleDefinition other) {
        if (other != null) {
            if (KotlinLanguageSupportKt.isNotEmpty((String)this.value) && KotlinLanguageSupportKt.isNotEmpty((String)other.value)) {
                Companion.getLogger().warn((Function0)new Function0<Object>(other){
                    final /* synthetic */ MatchingRuleDefinition $other;
                    {
                        this.$other = $other;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "There are multiple matching rules with values for the same value. There is no reliable way to combine them, so the later value ('" + this.$other.getValue() + "') will be ignored.";
                    }
                });
            }
            if (this.generator != null && other.generator != null) {
                Companion.getLogger().warn((Function0)new Function0<Object>(other){
                    final /* synthetic */ MatchingRuleDefinition $other;
                    {
                        this.$other = $other;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "There are multiple generators for the same value. There is no reliable way to combine them, so the later generator (" + this.$other.getGenerator() + ") will be ignored.";
                    }
                });
            }
            String string = KotlinLanguageSupportKt.isNotEmpty((String)this.value) ? this.value : other.value;
            ValueType valueType = this.valueType.merge(other.valueType);
            List list = CollectionsKt.plus((Collection)this.rules, (Iterable)other.rules);
            Generator generator = this.generator;
            if (generator == null) {
                generator = other.generator;
            }
            return new MatchingRuleDefinition(string, valueType, list, generator);
        }
        return this;
    }

    @NotNull
    public final MatchingRuleDefinition withType(@NotNull ValueType valueType) {
        Intrinsics.checkNotNullParameter((Object)((Object)valueType), (String)"valueType");
        return MatchingRuleDefinition.copy$default(this, null, valueType, null, null, 13, null);
    }

    @Nullable
    public final String component1() {
        return this.value;
    }

    @NotNull
    public final ValueType component2() {
        return this.valueType;
    }

    @NotNull
    public final List<Either<MatchingRule, MatchingReference>> component3() {
        return this.rules;
    }

    @Nullable
    public final Generator component4() {
        return this.generator;
    }

    @NotNull
    public final MatchingRuleDefinition copy(@Nullable String value, @NotNull ValueType valueType, @NotNull List<? extends Either<? extends MatchingRule, MatchingReference>> rules, @Nullable Generator generator) {
        Intrinsics.checkNotNullParameter((Object)((Object)valueType), (String)"valueType");
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        return new MatchingRuleDefinition(value, valueType, rules, generator);
    }

    public static /* synthetic */ MatchingRuleDefinition copy$default(MatchingRuleDefinition matchingRuleDefinition, String string, ValueType valueType, List list, Generator generator, int n, Object object) {
        if ((n & 1) != 0) {
            string = matchingRuleDefinition.value;
        }
        if ((n & 2) != 0) {
            valueType = matchingRuleDefinition.valueType;
        }
        if ((n & 4) != 0) {
            list = matchingRuleDefinition.rules;
        }
        if ((n & 8) != 0) {
            generator = matchingRuleDefinition.generator;
        }
        return matchingRuleDefinition.copy(string, valueType, list, generator);
    }

    @NotNull
    public String toString() {
        return "MatchingRuleDefinition(value=" + this.value + ", valueType=" + this.valueType + ", rules=" + this.rules + ", generator=" + this.generator + ")";
    }

    public int hashCode() {
        int result = this.value == null ? 0 : this.value.hashCode();
        result = result * 31 + this.valueType.hashCode();
        result = result * 31 + ((Object)this.rules).hashCode();
        result = result * 31 + (this.generator == null ? 0 : this.generator.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MatchingRuleDefinition)) {
            return false;
        }
        MatchingRuleDefinition matchingRuleDefinition = (MatchingRuleDefinition)other;
        if (!Intrinsics.areEqual((Object)this.value, (Object)matchingRuleDefinition.value)) {
            return false;
        }
        if (this.valueType != matchingRuleDefinition.valueType) {
            return false;
        }
        if (!Intrinsics.areEqual(this.rules, matchingRuleDefinition.rules)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.generator, (Object)matchingRuleDefinition.generator);
    }

    @JvmStatic
    @NotNull
    public static final Result<MatchingRuleDefinition, String> parseMatchingRuleDefinition(@NotNull String expression) {
        return Companion.parseMatchingRuleDefinition(expression);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Lau/com/dius/pact/core/model/matchingrules/expressions/MatchingRuleDefinition$Companion;", "Lmu/KLogging;", "()V", "parseMatchingRuleDefinition", "Lau/com/dius/pact/core/support/Result;", "Lau/com/dius/pact/core/model/matchingrules/expressions/MatchingRuleDefinition;", "", "expression", "model"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Result<MatchingRuleDefinition, String> parseMatchingRuleDefinition(@NotNull String expression) {
            Result result;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            MatcherDefinitionLexer lexer = new MatcherDefinitionLexer(expression);
            MatcherDefinitionParser parser = new MatcherDefinitionParser(lexer);
            Result<MatchingRuleDefinition, String> result2 = parser.matchingDefinition();
            if (result2 instanceof Result.Ok) {
                if (((Result.Ok)result2).getValue() == null) {
                    result = (Result)new Result.Err((Object)"Error parsing expression");
                } else {
                    Object object = ((Result.Ok)result2).getValue();
                    Intrinsics.checkNotNull((Object)object);
                    result = (Result)new Result.Ok(object);
                }
            } else if (result2 instanceof Result.Err) {
                result = (Result)new Result.Err((Object)("Error parsing expression: " + ((Result.Err)result2).getError()));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

