/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.model.messaging;

import au.com.dius.pact.core.model.BasePact;
import au.com.dius.pact.core.model.Consumer;
import au.com.dius.pact.core.model.DefaultPactReader;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.InvalidPactException;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.PactSource;
import au.com.dius.pact.core.model.PactSpecVersion;
import au.com.dius.pact.core.model.Provider;
import au.com.dius.pact.core.model.UnknownPactSource;
import au.com.dius.pact.core.model.V4Interaction;
import au.com.dius.pact.core.model.V4Pact;
import au.com.dius.pact.core.model.messaging.Message;
import au.com.dius.pact.core.model.messaging.MessagePact;
import au.com.dius.pact.core.support.Json;
import au.com.dius.pact.core.support.JsonKt;
import au.com.dius.pact.core.support.Result;
import au.com.dius.pact.core.support.Utils;
import au.com.dius.pact.core.support.json.JsonParser;
import au.com.dius.pact.core.support.json.JsonValue;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 ?2\u00020\u0001:\u0001?BI\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00000$H\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0&H\u0016J\u0014\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u000b0(H\u0016J\u0013\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020+H\u0016J\u0016\u00100\u001a\u0002012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u001502H\u0016J\u000e\u00103\u001a\u00020\u00002\u0006\u0010,\u001a\u000201J.\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u00106\u001a\u000207J\b\u00108\u001a\u000201H\u0016J\u001c\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020\u000bH\u0016J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020\u000b022\u0006\u0010>\u001a\u00020;H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0017\"\u0004\b\u0019\u0010\u001aR\"\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006@"}, d2={"Lau/com/dius/pact/core/model/messaging/MessagePact;", "Lau/com/dius/pact/core/model/BasePact;", "provider", "Lau/com/dius/pact/core/model/Provider;", "consumer", "Lau/com/dius/pact/core/model/Consumer;", "messages", "", "Lau/com/dius/pact/core/model/messaging/Message;", "metadata", "", "", "", "source", "Lau/com/dius/pact/core/model/PactSource;", "(Lau/com/dius/pact/core/model/Provider;Lau/com/dius/pact/core/model/Consumer;Ljava/util/List;Ljava/util/Map;Lau/com/dius/pact/core/model/PactSource;)V", "getConsumer", "()Lau/com/dius/pact/core/model/Consumer;", "setConsumer", "(Lau/com/dius/pact/core/model/Consumer;)V", "interactions", "Lau/com/dius/pact/core/model/Interaction;", "getInteractions", "()Ljava/util/List;", "getMessages", "setMessages", "(Ljava/util/List;)V", "getMetadata", "()Ljava/util/Map;", "getProvider", "()Lau/com/dius/pact/core/model/Provider;", "setProvider", "(Lau/com/dius/pact/core/model/Provider;)V", "getSource", "()Lau/com/dius/pact/core/model/PactSource;", "asMessagePact", "Lau/com/dius/pact/core/support/Result$Ok;", "asRequestResponsePact", "Lau/com/dius/pact/core/support/Result$Err;", "asV4Pact", "Lau/com/dius/pact/core/support/Result;", "Lau/com/dius/pact/core/model/V4Pact;", "equals", "", "other", "hashCode", "", "isRequestResponsePact", "mergeInteractions", "Lau/com/dius/pact/core/model/Pact;", "", "mergePact", "mergePacts", "pact", "pactFile", "Ljava/io/File;", "sortInteractions", "toMap", "pactSpecVersion", "Lau/com/dius/pact/core/model/PactSpecVersion;", "toString", "validateForVersion", "pactVersion", "Companion", "model"})
public final class MessagePact
extends BasePact {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Provider provider;
    @NotNull
    private Consumer consumer;
    @NotNull
    private List<Message> messages;
    @NotNull
    private final Map<String, Object> metadata;
    @NotNull
    private final PactSource source;

    @JvmOverloads
    public MessagePact(@NotNull Provider provider, @NotNull Consumer consumer, @NotNull List<Message> messages, @NotNull Map<String, ? extends Object> metadata2, @NotNull PactSource source) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Intrinsics.checkNotNullParameter(metadata2, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        super(consumer, provider, metadata2, source);
        this.provider = provider;
        this.consumer = consumer;
        this.messages = messages;
        this.metadata = metadata2;
        this.source = source;
    }

    public /* synthetic */ MessagePact(Provider provider, Consumer consumer, List list, Map map, PactSource pactSource, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = new ArrayList();
        }
        if ((n & 8) != 0) {
            map = BasePact.Companion.getDEFAULT_METADATA();
        }
        if ((n & 0x10) != 0) {
            pactSource = UnknownPactSource.INSTANCE;
        }
        this(provider, consumer, list, map, pactSource);
    }

    @Override
    @NotNull
    public Provider getProvider() {
        return this.provider;
    }

    @Override
    public void setProvider(@NotNull Provider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"<set-?>");
        this.provider = provider;
    }

    @Override
    @NotNull
    public Consumer getConsumer() {
        return this.consumer;
    }

    @Override
    public void setConsumer(@NotNull Consumer consumer) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"<set-?>");
        this.consumer = consumer;
    }

    @NotNull
    public final List<Message> getMessages() {
        return this.messages;
    }

    public final void setMessages(@NotNull List<Message> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.messages = list;
    }

    @Override
    @NotNull
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Override
    @NotNull
    public PactSource getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public Map<String, Object> toMap(@NotNull PactSpecVersion pactSpecVersion) {
        Collection<Pair> collection;
        Map.Entry it;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)pactSpecVersion), (String)"pactSpecVersion");
        if (pactSpecVersion.compareTo((Enum)PactSpecVersion.V3) < 0) {
            throw new InvalidPactException("Message pacts only support version 3+, cannot write pact specification version " + pactSpecVersion);
        }
        Pair[] pairArray = new Pair[4];
        pairArray[0] = TuplesKt.to((Object)"consumer", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)this.getConsumer().getName())));
        pairArray[1] = TuplesKt.to((Object)"provider", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)this.getProvider().getName())));
        Iterable iterable = this.messages;
        String string = "messages";
        int n = 2;
        Pair[] pairArray2 = pairArray;
        boolean $i$f$map = false;
        void var5_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Message message = (Message)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(((Message)((Object)it)).toMap(pactSpecVersion));
        }
        object = (List)destination$iv$iv;
        pairArray2[n] = TuplesKt.to((Object)string, (Object)object);
        $this$map$iv = this.getMetadata().entrySet();
        object = BasePact.Companion;
        string = "metadata";
        n = 3;
        pairArray2 = pairArray;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it.getKey(), (Object)Json.toJson(it.getValue())));
        }
        collection = (List)destination$iv$iv;
        pairArray2[n] = TuplesKt.to((Object)string, ((BasePact.Companion)((Object)object)).metaData((JsonValue)JsonKt.jsonObject((List)collection), pactSpecVersion));
        return MapsKt.mapOf((Pair[])pairArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> mergePacts(@NotNull Map<String, ? extends Object> pact, @NotNull File pactFile) {
        List list;
        String[] it2;
        Intrinsics.checkNotNullParameter(pact, (String)"pact");
        Intrinsics.checkNotNullParameter((Object)pactFile, (String)"pactFile");
        Map newPact = MapsKt.toMutableMap(pact);
        Object object = pactFile;
        Object object2 = Charsets.UTF_8;
        int n = 8192;
        Object object3 = object;
        object3 = new InputStreamReader((InputStream)new FileInputStream((File)object3), (Charset)object2);
        object = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
        object2 = null;
        try {
            it2 = (String[])object;
            boolean bl = false;
            it2 = JsonParser.parseReader((Reader)((Reader)it2));
        }
        catch (Throwable it2) {
            object2 = it2;
            throw it2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        String[] json2 = it2;
        String pactSpec = "pact-specification";
        it2 = new String[]{"metadata", pactSpec, "version"};
        Object version = Json.INSTANCE.extractFromJson((JsonValue)json2, it2);
        String[] bl = new String[]{"metadata", pactSpec, "version"};
        Object pactVersion = Utils.INSTANCE.extractFromMap(pact, bl);
        if (version != null && !Intrinsics.areEqual((Object)version, (Object)pactVersion)) {
            throw new InvalidPactException("Could not merge pact into '" + pactFile + "': pact specification version is " + pactVersion + ", while the file is version " + version);
        }
        if (json2 instanceof JsonValue.Object && json2.has("interactions")) {
            throw new InvalidPactException("Could not merge pact into '" + pactFile + "': file is not a message pact (it contains request/response interactions)");
        }
        Object v = newPact.get("messages");
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.collections.Map<kotlin.String, kotlin.Any>>");
        Collection collection = (List)v;
        Object object4 = json2.get((Object)"messages").asArray();
        if (object4 != null && (object4 = object4.getValues()) != null) {
            void $this$distinctBy$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = (Iterable)object4;
            Collection collection2 = collection;
            boolean $i$f$map = false;
            void var11_17 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                JsonValue jsonValue = (JsonValue)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                boolean bl2 = false;
                collection3.add(Json.INSTANCE.toMap((JsonValue)it3));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$distinctBy = false;
            HashSet set$iv = new HashSet();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                Map it4 = (Map)e$iv;
                boolean bl3 = false;
                Object key$iv = it4.get("description");
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            list = list$iv;
            collection = collection2;
        } else {
            list = null;
        }
        List messages = CollectionsKt.plus((Collection)collection, list);
        newPact.put("messages", messages);
        return newPact;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Pact mergeInteractions(@NotNull List<? extends Interaction> interactions2) {
        void $this$distinctBy$iv;
        Intrinsics.checkNotNullParameter(interactions2, (String)"interactions");
        Iterable iterable = CollectionsKt.plus((Collection)interactions2, (Iterable)this.messages);
        MessagePact messagePact = this;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Message it = (Message)e$iv;
            boolean bl = false;
            String key$iv = it.uniqueKey();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        messagePact.messages = CollectionsKt.toMutableList((Collection)list$iv);
        this.sortInteractions();
        return this;
    }

    @Override
    public boolean isRequestResponsePact() {
        return false;
    }

    @NotNull
    public Result.Err<String> asRequestResponsePact() {
        return new Result.Err((Object)"A V3 Message Pact can not be converted to a V3 Request/Response Pact");
    }

    @NotNull
    public Result.Ok<MessagePact> asMessagePact() {
        return new Result.Ok((Object)this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Result<V4Pact, String> asV4Pact() {
        Collection<V4Interaction> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.getInteractions();
        Provider provider = this.getProvider();
        Consumer consumer = this.getConsumer();
        boolean $i$f$map = false;
        void var3_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Interaction interaction = (Interaction)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.asV4Interaction());
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 16;
        PactSource pactSource = null;
        Map<String, Object> map = this.getMetadata();
        List list = CollectionsKt.toMutableList((Collection)collection);
        Provider provider2 = provider;
        Consumer consumer2 = consumer;
        V4Pact v4Pact = new V4Pact(consumer2, provider2, list, map, pactSource, n, defaultConstructorMarker);
        return (Result)new Result.Ok((Object)v4Pact);
    }

    @Override
    @NotNull
    public List<Interaction> getInteractions() {
        return CollectionsKt.toMutableList((Collection)this.messages);
    }

    @Override
    @NotNull
    public Pact sortInteractions() {
        List<Message> $this$sortBy$iv = this.messages;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Message message = (Message)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)(CollectionsKt.joinToString$default((Iterable)message.getProviderStates(), null, null, null, (int)0, null, (Function1)sortInteractions.1.1.INSTANCE, (int)31, null) + message.getDescription()));
                    message = (Message)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)(CollectionsKt.joinToString$default((Iterable)message.getProviderStates(), null, null, null, (int)0, null, (Function1)sortInteractions.1.1.INSTANCE, (int)31, null) + message.getDescription()))));
                }
            });
        }
        return this;
    }

    @NotNull
    public final MessagePact mergePact(@NotNull Pact other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other instanceof MessagePact)) {
            throw new InvalidPactException("Unable to merge pact " + other + " as it is not a MessagePact");
        }
        this.mergeInteractions(other.getInteractions());
        return this;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type au.com.dius.pact.core.model.messaging.MessagePact");
        MessagePact cfr_ignored_0 = (MessagePact)other;
        if (!Intrinsics.areEqual((Object)this.getProvider(), (Object)((MessagePact)other).getProvider())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getConsumer(), (Object)((MessagePact)other).getConsumer())) {
            return false;
        }
        return Intrinsics.areEqual(this.messages, ((MessagePact)other).messages);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getProvider().hashCode();
        result = 31 * result + this.getConsumer().hashCode();
        result = 31 * result + ((Object)this.messages).hashCode();
        return result;
    }

    @Override
    @NotNull
    public String toString() {
        return "MessagePact(provider=" + this.getProvider() + ", consumer=" + this.getConsumer() + ", messages=" + this.messages + ", metadata=" + this.getMetadata() + ")";
    }

    @Override
    @NotNull
    public List<String> validateForVersion(@NotNull PactSpecVersion pactVersion) {
        Intrinsics.checkNotNullParameter((Object)((Object)pactVersion), (String)"pactVersion");
        return pactVersion.compareTo((Enum)PactSpecVersion.V3) < 0 ? CollectionsKt.plus((Collection)super.validateForVersion(pactVersion), (Object)"Message pacts can only be used with V3 or above of the Pact specification") : super.validateForVersion(pactVersion);
    }

    @JvmOverloads
    public MessagePact(@NotNull Provider provider, @NotNull Consumer consumer, @NotNull List<Message> messages, @NotNull Map<String, ? extends Object> metadata2) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Intrinsics.checkNotNullParameter(metadata2, (String)"metadata");
        this(provider, consumer, messages, metadata2, null, 16, null);
    }

    @JvmOverloads
    public MessagePact(@NotNull Provider provider, @NotNull Consumer consumer, @NotNull List<Message> messages) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        this(provider, consumer, messages, null, null, 24, null);
    }

    @JvmOverloads
    public MessagePact(@NotNull Provider provider, @NotNull Consumer consumer) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        this(provider, consumer, null, null, null, 28, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lau/com/dius/pact/core/model/messaging/MessagePact$Companion;", "Lmu/KLogging;", "()V", "fromJson", "Lau/com/dius/pact/core/model/messaging/MessagePact;", "json", "Lau/com/dius/pact/core/support/json/JsonValue$Object;", "source", "Lau/com/dius/pact/core/model/PactSource;", "model"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final MessagePact fromJson(@NotNull JsonValue.Object json2, @NotNull PactSource source) {
            List list;
            Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            JsonValue.Object transformedJson = DefaultPactReader.transformJson(json2);
            Consumer consumer = Consumer.Companion.fromJson(transformedJson.get("consumer"));
            Provider provider = Provider.Companion.fromJson(transformedJson.get("provider"));
            Object object = transformedJson.get("messages").asArray();
            if (object != null && (object = object.getValues()) != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JsonValue jsonValue = (JsonValue)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void this_$iv = it;
                    boolean $i$f$downcast = false;
                    if (!(this_$iv instanceof JsonValue.Object)) {
                        throw new UnsupportedOperationException("Can not downcast " + this_$iv.getName() + " to type " + Reflection.getOrCreateKotlinClass(JsonValue.Object.class));
                    }
                    collection.add(Message.Companion.fromJson((JsonValue.Object)this_$iv));
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            List messages = list;
            Map metadata2 = transformedJson.has("metadata") ? Json.INSTANCE.toMap(transformedJson.get("metadata")) : MapsKt.emptyMap();
            return new MessagePact(provider, consumer, CollectionsKt.toMutableList((Collection)messages), metadata2, source);
        }

        public static /* synthetic */ MessagePact fromJson$default(Companion companion, JsonValue.Object object, PactSource pactSource, int n, Object object2) {
            if ((n & 2) != 0) {
                pactSource = UnknownPactSource.INSTANCE;
            }
            return companion.fromJson(object, pactSource);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

