/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.gvt;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.bridge.InterruptedBridgeException;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.util.EventDispatcher;

public class GVTTreeRenderer
extends Thread {
    protected ImageRenderer renderer;
    protected Shape areaOfInterest;
    protected int width;
    protected int height;
    protected AffineTransform user2DeviceTransform;
    protected boolean doubleBuffering;
    protected List listeners = Collections.synchronizedList(new LinkedList());
    protected boolean beenInterrupted;
    static EventDispatcher.Dispatcher prepareDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object object, Object object2) {
            ((GVTTreeRendererListener)object).gvtRenderingPrepare((GVTTreeRendererEvent)object2);
        }
    };
    static EventDispatcher.Dispatcher startedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object object, Object object2) {
            ((GVTTreeRendererListener)object).gvtRenderingStarted((GVTTreeRendererEvent)object2);
        }
    };
    static EventDispatcher.Dispatcher cancelledDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object object, Object object2) {
            ((GVTTreeRendererListener)object).gvtRenderingCancelled((GVTTreeRendererEvent)object2);
        }
    };
    static EventDispatcher.Dispatcher completedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object object, Object object2) {
            ((GVTTreeRendererListener)object).gvtRenderingCompleted((GVTTreeRendererEvent)object2);
        }
    };
    static EventDispatcher.Dispatcher failedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object object, Object object2) {
            ((GVTTreeRendererListener)object).gvtRenderingFailed((GVTTreeRendererEvent)object2);
        }
    };

    public GVTTreeRenderer(ImageRenderer imageRenderer, AffineTransform affineTransform, boolean bl, Shape shape, int n, int n2) {
        this.renderer = imageRenderer;
        this.areaOfInterest = shape;
        this.user2DeviceTransform = affineTransform;
        this.doubleBuffering = bl;
        this.width = n;
        this.height = n2;
        this.beenInterrupted = false;
    }

    public boolean getBeenInterrupted() {
        GVTTreeRenderer gVTTreeRenderer = this;
        synchronized (gVTTreeRenderer) {
            boolean bl = this.beenInterrupted;
            return bl;
        }
    }

    public void run() {
        GVTTreeRendererEvent gVTTreeRendererEvent = new GVTTreeRendererEvent(this, null);
        try {
            this.fireEvent(prepareDispatcher, gVTTreeRendererEvent);
            this.renderer.setTransform(this.user2DeviceTransform);
            this.renderer.setDoubleBuffered(this.doubleBuffering);
            this.renderer.updateOffScreen(this.width, this.height);
            this.renderer.clearOffScreen();
            if (this.getBeenInterrupted()) {
                this.fireEvent(cancelledDispatcher, gVTTreeRendererEvent);
                return;
            }
            gVTTreeRendererEvent = new GVTTreeRendererEvent(this, this.renderer.getOffScreen());
            this.fireEvent(startedDispatcher, gVTTreeRendererEvent);
            if (this.getBeenInterrupted()) {
                this.fireEvent(cancelledDispatcher, gVTTreeRendererEvent);
                return;
            }
            this.renderer.repaint(this.areaOfInterest);
            if (this.getBeenInterrupted()) {
                this.fireEvent(cancelledDispatcher, gVTTreeRendererEvent);
                return;
            }
            gVTTreeRendererEvent = new GVTTreeRendererEvent(this, this.renderer.getOffScreen());
            this.fireEvent(completedDispatcher, gVTTreeRendererEvent);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (InterruptedBridgeException interruptedBridgeException) {
            this.fireEvent(cancelledDispatcher, gVTTreeRendererEvent);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.fireEvent(failedDispatcher, gVTTreeRendererEvent);
        }
    }

    public void interrupt() {
        super.interrupt();
        GVTTreeRenderer gVTTreeRenderer = this;
        synchronized (gVTTreeRenderer) {
            this.beenInterrupted = true;
        }
    }

    public void fireEvent(EventDispatcher.Dispatcher dispatcher, Object object) {
        EventDispatcher.fireEvent((EventDispatcher.Dispatcher)dispatcher, (List)this.listeners, (Object)object, (boolean)true);
    }

    public void addGVTTreeRendererListener(GVTTreeRendererListener gVTTreeRendererListener) {
        this.listeners.add(gVTTreeRendererListener);
    }

    public void removeGVTTreeRendererListener(GVTTreeRendererListener gVTTreeRendererListener) {
        this.listeners.remove(gVTTreeRendererListener);
    }
}

