/*
 * Decompiled with CFR 0.152.
 */
package aQute.junit.runtime;

import aQute.junit.runtime.BasicTestReport;
import aQute.junit.runtime.GenericFramework;
import aQute.junit.runtime.JUnitReport;
import aQute.junit.runtime.PlainResultFormatter;
import aQute.junit.runtime.TestReporter;
import aQute.junit.runtime.XMLReport;
import aQute.junit.runtime.XMLResultFormatter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Target {
    final List testNames = new ArrayList();
    int port = -1;
    boolean keepAlive;
    String target;
    boolean deferred = false;
    boolean clear = false;
    boolean verbose = true;
    final Properties properties = new Properties();
    final GenericFramework framework = new GenericFramework(this.properties);
    String reportName = "test-report.xml";
    boolean waitForEver;

    public static void main(String[] args) {
        Target target = new Target();
        System.exit(target.run(args));
    }

    int run(String[] args) {
        try {
            this.init(args);
            if (this.port == -1) {
                return this.doTesting(new XMLReport(this.reportName));
            }
            return this.doTesting(new JUnitReport(this.port));
        }
        catch (Throwable e) {
            this.error("bnd runtime", e);
            this.framework.report(System.out);
            return -1;
        }
    }

    void init(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if ("-version".equals(args[i])) {
                if ("3".equals(args[++i].trim())) continue;
                throw new RuntimeException("This target only works with JUnit protocol #3");
            }
            if ("-port".equals(args[i])) {
                this.port = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-deferred".equals(args[i])) {
                this.deferred = true;
                continue;
            }
            if ("-clear".equals(args[i])) {
                this.clear = true;
                continue;
            }
            if ("-testNameFile".equals(args[i])) {
                this.processFile(new File(args[++i]));
                continue;
            }
            if ("-testLoaderClass".equals(args[i])) {
                ++i;
                continue;
            }
            if ("-loaderpluginname".equals(args[i])) {
                ++i;
                continue;
            }
            if ("-test".equals(args[i])) {
                this.testNames.add(args[++i]);
                continue;
            }
            if ("-classNames".equals(args[i])) {
                this.testNames.add(args[++i]);
                continue;
            }
            if ("-bundle".equals(args[i])) {
                this.framework.addBundle(new File(args[++i]));
                continue;
            }
            if ("-export".equals(args[i])) {
                this.framework.addSystemPackage(args[++i]);
                continue;
            }
            if ("-framework".equals(args[i])) {
                this.framework.setFramework(args[++i]);
                continue;
            }
            if ("-keepalive".equals(args[i])) {
                this.keepAlive = true;
                continue;
            }
            if ("-set".equals(args[i])) {
                this.properties.setProperty(args[++i], args[++i]);
                continue;
            }
            if ("-target".equals(args[i])) {
                this.target = args[++i];
                this.framework.addBundle(new File(this.target));
                continue;
            }
            if ("-storage".equals(args[i])) {
                this.framework.setStorage(new File(args[++i]));
                continue;
            }
            if ("-report".equals(args[i])) {
                this.reportName = args[++i];
                continue;
            }
            if ("-verbose".equals(args[i])) {
                this.verbose = true;
                System.out.println("bnd OSGi Runtime");
                continue;
            }
            this.warning("Do not understand arg: " + args[i]);
        }
        System.getProperties().putAll((Map<?, ?>)this.properties);
    }

    void checkTestCases(Bundle bundle) throws Throwable {
        String testcases = (String)bundle.getHeaders().get("Test-Cases");
        if (testcases == null) {
            return;
        }
        String[] classes = testcases.split("\\s*,\\s*");
        for (int i = 0; i < classes.length; ++i) {
            this.testNames.add(classes[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doTesting(TestReporter testReporter) throws Throwable {
        Bundle targetBundle;
        long startTime = System.currentTimeMillis();
        try {
            List<Throwable> activateErrors = this.framework.activate();
            if (activateErrors.size() > 0) {
                this.handleSetupErrors(activateErrors, startTime);
                return activateErrors.size();
            }
            boolean report = this.properties.containsKey("report");
            if (report) {
                this.framework.report(System.out);
            }
            if ((targetBundle = this.framework.getBundle(this.target)) == null) {
                throw new IllegalArgumentException("Cannot obtain target bundle: " + this.target);
            }
            if (this.testNames.size() == 0) {
                this.checkTestCases(targetBundle);
            }
            if (this.testNames.size() == 0) {
                System.out.println("No test cases to run, waiting for the framework to quit");
                this.framework.waitForStop(0L);
                System.out.println("And the framework is gone!");
                return 0;
            }
        }
        catch (Throwable th) {
            this.handleSetupError(th, startTime);
            throw th;
        }
        int allErrors = 0;
        TestSuite suite = this.createSuite(targetBundle, this.testNames);
        testReporter.begin(this.framework, targetBundle, null, suite.countTestCases());
        try {
            Enumeration tests = suite.tests();
            while (tests.hasMoreElements()) {
                Test test = (Test)tests.nextElement();
                TestResult result = new TestResult();
                BasicTestReport basicReport = new BasicTestReport();
                result.addListener((TestListener)basicReport);
                result.addListener((TestListener)testReporter);
                String testName = null;
                if (test instanceof TestSuite) {
                    testName = ((TestSuite)test).getName();
                } else if (test instanceof TestCase) {
                    testName = ((TestCase)test).getName();
                }
                List<JUnitResultFormatter> formatters = this.getResultFormatters(testName);
                for (JUnitResultFormatter formatter : formatters) {
                    result.addListener((TestListener)formatter);
                }
                JUnitTest junitTest = new JUnitTest(testName);
                junitTest.setProperties(System.getProperties());
                startTime = System.currentTimeMillis();
                this.fireStartTestSuite(formatters, junitTest);
                basicReport.begin(this.framework, targetBundle, null, test.countTestCases());
                try {
                    test.run(result);
                }
                finally {
                    junitTest.setCounts(test.countTestCases(), result.failureCount(), result.errorCount());
                    junitTest.setRunTime(System.currentTimeMillis() - startTime);
                    this.fireEndTestSuite(formatters, junitTest);
                    basicReport.end();
                }
                allErrors += result.errorCount();
            }
            int n = allErrors;
            return n;
        }
        finally {
            testReporter.end();
            if (this.properties.containsKey("wait")) {
                this.framework.waitForStop(10000000L);
            }
            this.framework.deactivate();
        }
    }

    private List<JUnitResultFormatter> getResultFormatters(String testName) throws IOException {
        String reportDir = new File(this.reportName).getParentFile() + "/test-reports";
        ArrayList<JUnitResultFormatter> formatters = new ArrayList<JUnitResultFormatter>();
        formatters.add(new XMLResultFormatter(reportDir, testName));
        formatters.add(new PlainResultFormatter(reportDir, testName));
        return formatters;
    }

    private void handleSetupError(Throwable th, long startTime) throws IOException {
        List<Throwable> errors = Arrays.asList(th);
        this.handleSetupErrors(errors, startTime);
    }

    private void handleSetupErrors(List<Throwable> errors, long startTime) throws IOException {
        PrintStream ps = new PrintStream(new FileOutputStream(this.reportName));
        for (Throwable ex : errors) {
            ex.printStackTrace(ps);
            ps.println();
        }
        ps.close();
        TestResult result = new TestResult();
        String targetName = new File(this.target).getName();
        if (targetName.endsWith(".jar")) {
            // empty if block
        }
        targetName = targetName.substring(0, targetName.length() - 4);
        List<JUnitResultFormatter> formatters = this.getResultFormatters(targetName);
        for (JUnitResultFormatter formatter : formatters) {
            result.addListener((TestListener)formatter);
        }
        JUnitTest junitTest = new JUnitTest(targetName);
        junitTest.setProperties(System.getProperties());
        this.fireStartTestSuite(formatters, junitTest);
        for (Throwable ex : errors) {
            result.addError(null, ex);
        }
        junitTest.setCounts(0L, result.failureCount(), result.errorCount());
        junitTest.setRunTime(System.currentTimeMillis() - startTime);
        this.fireEndTestSuite(formatters, junitTest);
    }

    private void fireStartTestSuite(List<JUnitResultFormatter> formatters, JUnitTest junitTest) {
        for (JUnitResultFormatter formatter : formatters) {
            formatter.startTestSuite(junitTest);
        }
    }

    private void fireEndTestSuite(List<JUnitResultFormatter> formatters, JUnitTest junitTest) {
        for (JUnitResultFormatter formatter : formatters) {
            formatter.endTestSuite(junitTest);
        }
    }

    private TestSuite createSuite(Bundle tfw, List testNames) throws Exception {
        TestSuite suite = new TestSuite();
        for (String fqn : testNames) {
            int n = fqn.indexOf(58);
            if (n > 0) {
                String method = fqn.substring(n + 1);
                fqn = fqn.substring(0, n);
                Class clazz = tfw.loadClass(fqn);
                suite.addTest(TestSuite.createTest((Class)clazz, (String)method));
                continue;
            }
            Class clazz = tfw.loadClass(fqn);
            suite.addTestSuite(clazz);
        }
        return suite;
    }

    private void warning(String string) {
        System.out.println("warning: " + string);
    }

    private void error(String string, Throwable e) {
        if (e instanceof BundleException) {
            GenericFramework.report((BundleException)e, System.out);
        } else {
            System.out.println(string + " : " + e);
            if (this.verbose) {
                e.printStackTrace();
            }
        }
    }

    private void processFile(File file) throws IOException {
        FileReader rdr = new FileReader(file);
        BufferedReader brdr = new BufferedReader(rdr);
        String line = brdr.readLine();
        while (line != null) {
            this.testNames.add(line.trim());
            line = brdr.readLine();
        }
        rdr.close();
    }
}

