package aQute.bnd.annotation.component;

import java.lang.annotation.*;

@Retention(RetentionPolicy.CLASS)
@Target(ElementType.TYPE)
public @interface Component {
    final static String PROVIDE             = "provide";
    final static String NAME                = "name";
    final static String FACTORY             = "factory";
    final static String SERVICEFACTORY      = "servicefactory";
    final static String IMMEDIATE           = "immediate";
    final static String CONFIGURATION_POLICY = "configurationPolicy";
    final static String ENABLED             = "enabled";

    String name() default "";

    Class<?>[] provide() default Object.class;

    boolean factory() default false;

    boolean servicefactory() default false;

    boolean enabled() default true;

    boolean immediate() default false;

    ConfigurationPolicy configurationPolicy() default ConfigurationPolicy.OPTIONAL;

}
