/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.signatures;

import aQute.bnd.signatures.ArrayTypeSignature;
import aQute.bnd.signatures.BaseType;
import aQute.bnd.signatures.ClassTypeSignature;
import aQute.bnd.signatures.JavaTypeSignature;
import aQute.bnd.signatures.ReferenceTypeSignature;
import aQute.bnd.signatures.SimpleClassTypeSignature;
import aQute.bnd.signatures.TypeArgument;
import aQute.bnd.signatures.TypeVariableSignature;
import aQute.lib.stringrover.StringRover;
import java.util.Set;

class Signatures {
    static final JavaTypeSignature[] EMPTY_JavaTypeSignature = new JavaTypeSignature[0];
    static final ReferenceTypeSignature[] EMPTY_ReferenceTypeSignature = new ReferenceTypeSignature[0];

    private Signatures() {
    }

    static JavaTypeSignature parseJavaTypeSignature(StringRover signature) {
        return switch (signature.charAt(0)) {
            case 'B' -> {
                signature.increment();
                yield BaseType.B;
            }
            case 'C' -> {
                signature.increment();
                yield BaseType.C;
            }
            case 'D' -> {
                signature.increment();
                yield BaseType.D;
            }
            case 'F' -> {
                signature.increment();
                yield BaseType.F;
            }
            case 'I' -> {
                signature.increment();
                yield BaseType.I;
            }
            case 'J' -> {
                signature.increment();
                yield BaseType.J;
            }
            case 'S' -> {
                signature.increment();
                yield BaseType.S;
            }
            case 'Z' -> {
                signature.increment();
                yield BaseType.Z;
            }
            default -> Signatures.parseReferenceTypeSignature(signature);
        };
    }

    static ReferenceTypeSignature parseReferenceTypeSignature(StringRover signature) {
        return switch (signature.charAt(0)) {
            case 'T' -> TypeVariableSignature.parseTypeVariableSignature(signature);
            case 'L' -> ClassTypeSignature.parseClassTypeSignature(signature);
            case '[' -> ArrayTypeSignature.parseArrayTypeSignature(signature);
            default -> throw new IllegalArgumentException("invalid signature: " + signature);
        };
    }

    static void erasedBinaryReferences(JavaTypeSignature sig, Set<String> references) {
        ReferenceTypeSignature type;
        while (sig instanceof ArrayTypeSignature) {
            type = (ArrayTypeSignature)sig;
            sig = type.component;
        }
        if (sig instanceof ClassTypeSignature) {
            type = (ClassTypeSignature)sig;
            references.add(((ClassTypeSignature)type).binary);
            TypeArgument.erasedBinaryReferences(((ClassTypeSignature)type).classType.typeArguments, references);
            for (SimpleClassTypeSignature innerType : ((ClassTypeSignature)type).innerTypes) {
                TypeArgument.erasedBinaryReferences(innerType.typeArguments, references);
            }
        }
    }

    static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    static String intern(String s) {
        return s.intern();
    }
}

