/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.version;

import aQute.bnd.version.Version;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionRange {
    final Version high;
    final Version low;
    final boolean includeLow;
    final boolean includeHigh;
    private static final Pattern RANGE = Pattern.compile("(\\(|\\[)\\s*((\\d{1,10})(\\.(\\d{1,10})(\\.(\\d{1,10})(\\.([-\\w]+))?)?)?)\\s*,\\s*((\\d{1,10})(\\.(\\d{1,10})(\\.(\\d{1,10})(\\.([-\\w]+))?)?)?)\\s*(\\)|\\])");

    public VersionRange(String string) {
        string = string.trim();
        int auto = 0;
        if (string.startsWith("@")) {
            string = string.substring(1);
            auto = 1;
        } else if (string.endsWith("@")) {
            string = string.substring(0, string.length() - 1);
            auto = 2;
        } else if (string.startsWith("=")) {
            string = string.substring(1);
            auto = 3;
        }
        Matcher m = RANGE.matcher(string);
        if (m.matches()) {
            this.includeLow = m.group(1).charAt(0) == '[';
            String v1 = m.group(2);
            String v2 = m.group(10);
            this.low = new Version(v1);
            this.high = new Version(v2);
            boolean bl = this.includeHigh = m.group(18).charAt(0) == ']';
            if (this.low.compareTo(this.high) > 0) {
                throw new IllegalArgumentException("Low Range is higher than High Range: " + this.low + "-" + this.high);
            }
        } else {
            Version v = new Version(string);
            if (auto == 3) {
                this.includeLow = true;
                this.low = v;
                this.high = v;
                this.includeHigh = true;
            } else if (auto != 0) {
                this.includeLow = true;
                this.low = v;
                this.high = auto == 1 ? v.bumpMajor() : v.bumpMinor();
                this.includeHigh = false;
            } else {
                this.includeLow = true;
                this.low = v;
                this.high = Version.HIGHEST;
                this.includeHigh = true;
            }
        }
    }

    public VersionRange(boolean includeLow, Version low, Version high, boolean includeHigh) {
        this.includeLow = includeLow;
        this.low = low;
        this.high = VersionRange.unique(high);
        this.includeHigh = includeHigh;
    }

    public VersionRange(String low, String high) {
        this(new Version(low), new Version(high));
    }

    public VersionRange(Version low, Version high) {
        this.includeLow = true;
        this.low = low;
        this.high = VersionRange.unique(high);
        this.includeHigh = this.low.equals(this.high);
    }

    public VersionRange(Version v) {
        this.includeLow = true;
        this.low = v;
        this.high = Version.HIGHEST;
        this.includeHigh = true;
    }

    public VersionRange(org.osgi.framework.Version v) {
        this.includeLow = true;
        this.low = new Version(v);
        this.high = Version.HIGHEST;
        this.includeHigh = true;
    }

    public VersionRange(org.osgi.framework.Version low, org.osgi.framework.Version high) {
        this(new Version(low), new Version(high));
    }

    public VersionRange(boolean includeLow, org.osgi.framework.Version low, org.osgi.framework.Version high, boolean includeHigh) {
        this(includeLow, new Version(low), new Version(high), includeHigh);
    }

    static Version unique(Version v) {
        if (Version.HIGHEST.equals(v)) {
            return Version.HIGHEST;
        }
        if (Version.LOWEST.equals(v)) {
            return Version.LOWEST;
        }
        return v;
    }

    public boolean isRange() {
        return this.getHigh() != this.getLow();
    }

    public boolean includeLow() {
        return this.includeLow;
    }

    public boolean includeHigh() {
        return this.includeHigh;
    }

    public String toString() {
        if (this.isSingleVersion()) {
            return this.getLow().toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.includeLow() ? (char)'[' : '(').append(this.getLow()).append(',').append(this.getHigh()).append(this.includeHigh() ? (char)']' : ')');
        return sb.toString();
    }

    public Version getLow() {
        return this.low;
    }

    public Version getHigh() {
        return this.high;
    }

    public boolean includes(Version v) {
        if (this.includeLow() ? v.compareTo(this.getLow()) < 0 : v.compareTo(this.getLow()) <= 0) {
            return false;
        }
        return this.isSingleVersion() || !(this.includeHigh() ? v.compareTo(this.getHigh()) > 0 : v.compareTo(this.getHigh()) >= 0);
    }

    public Iterable<Version> filter(Iterable<Version> versions) {
        ArrayList<Version> list = new ArrayList<Version>();
        for (Version v : versions) {
            if (!this.includes(v)) continue;
            list.add(v);
        }
        return list;
    }

    public String toFilter() {
        return this.toFilter("version");
    }

    public String toFilter(String versionAttribute) {
        boolean multipleTerms;
        StringBuilder result = new StringBuilder(128);
        boolean needPresence = !this.includeLow() && (this.isSingleVersion() || !this.includeHigh());
        boolean bl = multipleTerms = needPresence || !this.isSingleVersion();
        if (multipleTerms) {
            result.append('(').append('&');
        }
        if (needPresence) {
            result.append('(').append(versionAttribute).append('=').append('*').append(')');
        }
        if (this.includeLow()) {
            result.append('(').append(versionAttribute).append('>').append('=').append(this.getLow()).append(')');
        } else {
            result.append('(').append('!').append('(').append(versionAttribute).append('<').append('=').append(this.getLow()).append(')').append(')');
        }
        if (!this.isSingleVersion()) {
            if (this.includeHigh()) {
                result.append('(').append(versionAttribute).append('<').append('=').append(this.getHigh()).append(')');
            } else {
                result.append('(').append('!').append('(').append(versionAttribute).append('>').append('=').append(this.getHigh()).append(')').append(')');
            }
        }
        if (multipleTerms) {
            result.append(')');
        }
        return result.toString();
    }

    public static boolean isVersionRange(String stringRange) {
        return stringRange != null && RANGE.matcher(stringRange).matches();
    }

    public VersionRange intersect(VersionRange other) {
        Version low = this.getLow();
        boolean includeLow = this.includeLow();
        int lowc = low.compareTo(other.getLow());
        if (lowc <= 0) {
            low = other.getLow();
            if (lowc != 0 || includeLow) {
                includeLow = other.includeLow();
            }
        }
        Version high = this.getHigh();
        boolean includeHigh = this.includeHigh();
        int highc = high.compareTo(other.getHigh());
        if (highc >= 0) {
            high = other.getHigh();
            if (highc != 0 || includeHigh) {
                includeHigh = other.includeHigh();
            }
        }
        return new VersionRange(includeLow, low, high, includeHigh);
    }

    public static VersionRange parseVersionRange(String version) {
        if (!VersionRange.isVersionRange(version)) {
            return null;
        }
        return new VersionRange(version);
    }

    public static VersionRange parseOSGiVersionRange(String version) {
        if (Version.isVersion(version)) {
            return new VersionRange(new Version(version), Version.HIGHEST);
        }
        if (VersionRange.isVersionRange(version)) {
            return new VersionRange(version);
        }
        return null;
    }

    public static boolean isOSGiVersionRange(String range) {
        return Version.isVersion(range) || VersionRange.isVersionRange(range);
    }

    public boolean isSingleVersion() {
        return this.getHigh() == Version.HIGHEST;
    }

    public boolean isEmpty() {
        if (this.isSingleVersion()) {
            return false;
        }
        int comparison = this.getLow().compareTo(this.getHigh());
        if (comparison == 0) {
            return !this.includeLow() || !this.includeHigh();
        }
        return comparison > 0;
    }

    public static VersionRange likeOSGi(String version) {
        if (version == null) {
            return new VersionRange(Version.LOWEST, Version.HIGHEST);
        }
        if (Version.isVersion(version)) {
            return new VersionRange(new Version(version), Version.HIGHEST);
        }
        if (VersionRange.isVersionRange(version)) {
            return new VersionRange(version);
        }
        return null;
    }
}

