/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.lesscss.extended.compiler;

import biz.gabrys.lesscss.compiler.LessCompiler;
import biz.gabrys.lesscss.compiler.LessCompilerImpl;
import biz.gabrys.lesscss.extended.compiler.CachingCompiledCodeExtendedCompiler;
import biz.gabrys.lesscss.extended.compiler.ExtendedCompiler;
import biz.gabrys.lesscss.extended.compiler.SimpleExtendedCompiler;
import biz.gabrys.lesscss.extended.compiler.cache.FullCache;
import biz.gabrys.lesscss.extended.compiler.control.expiration.CompiledSourceExpirationChecker;
import biz.gabrys.lesscss.extended.compiler.control.expiration.CompiledSourceExpirationCheckerImpl;
import biz.gabrys.lesscss.extended.compiler.control.expiration.SourceExpirationChecker;
import biz.gabrys.lesscss.extended.compiler.control.expiration.SourceModificationDateBasedExpirationChecker;
import biz.gabrys.lesscss.extended.compiler.control.processor.DoNothingPostCompilationProcessor;
import biz.gabrys.lesscss.extended.compiler.control.processor.PostCompilationProcessor;
import biz.gabrys.lesscss.extended.compiler.control.processor.PreCompilationProcessor;
import biz.gabrys.lesscss.extended.compiler.control.processor.SourceTreePreparationProcessorBuilder;
import biz.gabrys.lesscss.extended.compiler.control.provider.CachedSourceFileProvider;
import biz.gabrys.lesscss.extended.compiler.imports.LessImportResolver;
import biz.gabrys.lesscss.extended.compiler.imports.LessImportResolverImpl;
import biz.gabrys.lesscss.extended.compiler.source.SourceFactory;
import biz.gabrys.lesscss.extended.compiler.source.SourceFactoryBuilder;
import biz.gabrys.lesscss.extended.compiler.util.ParameterUtils;

public class CachingCompiledCodeExtendedCompilerBuilder {
    private final FullCache cache;
    private LessCompiler compiler;
    private SourceExpirationChecker expirationChecker;
    private LessImportResolver importResolver;
    private SourceFactory sourceFactory;
    private PostCompilationProcessor postProcessor;

    public CachingCompiledCodeExtendedCompilerBuilder(FullCache cache) {
        ParameterUtils.verifyNotNull("cache", cache);
        this.cache = cache;
    }

    public CachingCompiledCodeExtendedCompilerBuilder withCompiler(LessCompiler compiler) {
        this.compiler = compiler;
        return this;
    }

    public CachingCompiledCodeExtendedCompilerBuilder withExpirationChecker(SourceExpirationChecker expirationChecker) {
        this.expirationChecker = expirationChecker;
        return this;
    }

    public CachingCompiledCodeExtendedCompilerBuilder withImportResolver(LessImportResolver importResolver) {
        this.importResolver = importResolver;
        return this;
    }

    public CachingCompiledCodeExtendedCompilerBuilder withSourceFactory(SourceFactory sourceFactory) {
        this.sourceFactory = sourceFactory;
        return this;
    }

    public CachingCompiledCodeExtendedCompilerBuilder withPostProcessor(PostCompilationProcessor postProcessor) {
        this.postProcessor = postProcessor;
        return this;
    }

    public ExtendedCompiler create() {
        LessCompiler localCompiler = this.createLessCompiler();
        SourceFactory localSourceFactory = this.createSourceFactory(localCompiler);
        SourceTreePreparationProcessorBuilder sourceTreeBuilder = new SourceTreePreparationProcessorBuilder(this.cache);
        PreCompilationProcessor localPreProcessor = this.createPreProcessor(sourceTreeBuilder, localSourceFactory);
        PostCompilationProcessor localPostProcessor = this.createPostProcessor();
        ExtendedCompiler extendedCompiler = this.createSimpleExtendedCompiler(localCompiler, localPreProcessor, localPostProcessor);
        CompiledSourceExpirationChecker compiledSourceChecker = this.createCompiledSourceExpirationChecker(localSourceFactory);
        return new CachingCompiledCodeExtendedCompiler(extendedCompiler, compiledSourceChecker, this.cache, this.cache);
    }

    LessCompiler createLessCompiler() {
        return this.compiler != null ? this.compiler : new LessCompilerImpl();
    }

    SourceFactory createSourceFactory(LessCompiler compiler) {
        return this.sourceFactory != null ? this.sourceFactory : this.createSourceFactoryFromBuilder(compiler, new SourceFactoryBuilder());
    }

    SourceFactory createSourceFactoryFromBuilder(LessCompiler compiler, SourceFactoryBuilder builder) {
        if (compiler instanceof LessCompilerImpl) {
            builder.withLocal();
        } else {
            builder.withStandard();
        }
        return builder.create();
    }

    PreCompilationProcessor createPreProcessor(SourceTreePreparationProcessorBuilder builder, SourceFactory sourceFactory) {
        builder.withImportResolver(this.createImportResolver());
        builder.withSourceFactory(sourceFactory);
        return builder.create();
    }

    LessImportResolver createImportResolver() {
        return this.importResolver != null ? this.importResolver : new LessImportResolverImpl();
    }

    PostCompilationProcessor createPostProcessor() {
        return this.postProcessor != null ? this.postProcessor : new DoNothingPostCompilationProcessor();
    }

    ExtendedCompiler createSimpleExtendedCompiler(LessCompiler compiler, PreCompilationProcessor preProcessor, PostCompilationProcessor postProcessor) {
        CachedSourceFileProvider fileProvider = new CachedSourceFileProvider(this.cache);
        return new SimpleExtendedCompiler(compiler, preProcessor, fileProvider, postProcessor);
    }

    CompiledSourceExpirationChecker createCompiledSourceExpirationChecker(SourceFactory sourceFactory) {
        SourceExpirationChecker checker = this.createSourceExpirationChecker();
        return new CompiledSourceExpirationCheckerImpl(checker, this.cache, this.cache, sourceFactory);
    }

    SourceExpirationChecker createSourceExpirationChecker() {
        return this.expirationChecker != null ? this.expirationChecker : new SourceModificationDateBasedExpirationChecker(this.cache);
    }
}

